/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.ODEInterpolator;

public abstract class ExplicitRKSolver
implements ODEInterpolator {
    int error_code = 0;
    protected int nStages;
    protected int methodOrder;
    protected double[][] a;
    protected double[] b;
    protected double stepSize = 0.1;
    protected double takenStepSize = 0.0;
    protected double tolerance = 1.0E-6;
    protected int numEqn = 0;
    protected double[] state;
    protected double[] initialState;
    protected double[][] intermidiateStages;
    protected ODE ode;
    private double errOld = 1.0E-4;
    private double fac = 0.0;
    protected boolean interpolationIsValid = false;
    protected int nInterpolationStages;

    public ExplicitRKSolver(ODE _ode, double[][] a, double[] b, int methodOrder, int nStages, int nInterpolationStages) {
        this.nInterpolationStages = nInterpolationStages;
        this.nStages = nStages;
        this.methodOrder = methodOrder;
        this.a = a;
        this.b = b;
        this.ode = _ode;
        this.state = this.ode.getState();
        this.numEqn = this.state.length;
        this.initialState = new double[this.numEqn];
        this.intermidiateStages = new double[nStages + nInterpolationStages][this.numEqn];
    }

    public void initialize(double stepSize) {
        this.stepSize = stepSize;
        this.interpolationIsValid = false;
        if (this.state != this.ode.getState()) {
            this.state = this.ode.getState();
            this.numEqn = this.state.length;
            this.initialState = new double[this.numEqn];
            this.intermidiateStages = new double[this.nStages + this.nInterpolationStages][this.numEqn];
        }
    }

    public final double step() {
        this.error_code = 0;
        this.interpolationIsValid = false;
        if (this.state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        double err = 0.0;
        int iterations = 500;
        if (this.takenStepSize == 0.0) {
            this.stepSize = this.getInitialStepSize(this.stepSize);
        }
        System.arraycopy(this.state, 0, this.initialState, 0, this.numEqn);
        this.ode.getRate(this.state, this.intermidiateStages[0]);
        do {
            int i;
            --iterations;
            this.takenStepSize = this.stepSize;
            int s = 1;
            while (s < this.nStages) {
                i = 0;
                while (i < this.numEqn) {
                    this.state[i] = this.initialState[i];
                    int j = 0;
                    while (j < s) {
                        int n = i;
                        this.state[n] = this.state[n] + this.stepSize * this.a[s - 1][j] * this.intermidiateStages[j][i];
                        ++j;
                    }
                    ++i;
                }
                this.ode.getRate(this.state, this.intermidiateStages[s]);
                ++s;
            }
            i = 0;
            while (i < this.numEqn) {
                this.state[i] = this.initialState[i];
                s = 0;
                while (s < this.nStages) {
                    int n = i;
                    this.state[n] = this.state[n] + this.stepSize * this.b[s] * this.intermidiateStages[s][i];
                    ++s;
                }
                ++i;
            }
            err = this.estimateError();
            this.stepSize = this.estimateStepSize(err);
            if (iterations >= 499) continue;
            this.stepSize = Math.min(this.stepSize, this.takenStepSize);
        } while (err > 1.0 && iterations > 0);
        if (err > 1.0 || Double.isNaN(err)) {
            System.err.println("Method did not converge");
            this.error_code = 1;
        }
        return this.takenStepSize;
    }

    public int getErrorCode() {
        return this.error_code;
    }

    protected abstract double estimateError();

    private double estimateStepSize(double err) {
        double fac1 = 0.33;
        double fac2 = 6.0;
        double beta = 0.0;
        double safe = 0.9;
        double expO1 = 1.0 / (double)this.methodOrder - beta * 0.75;
        double estStepSize = 0.0;
        double fac11 = 0.0;
        if (err != 0.0) {
            fac11 = Math.exp(expO1 * Math.log(err));
            this.fac = fac11 / Math.exp(beta * Math.log(this.errOld));
            this.fac = Math.max(1.0 / fac2, Math.min(1.0 / fac1, this.fac / safe));
        } else {
            fac11 = 1.0 / fac1;
            this.fac = 1.0 / fac2;
        }
        if (err <= 1.0) {
            this.errOld = Math.max(err, 1.0E-4);
            estStepSize = this.stepSize / this.fac;
        } else {
            estStepSize = this.stepSize / Math.min(1.0 / fac1, fac11 / safe);
        }
        return estStepSize;
    }

    public double getInitialStepSize(double hMax) {
        double sk;
        double[] initialState = this.state;
        double[] state = new double[initialState.length];
        double[] rate = new double[state.length];
        double[] initialRate = new double[state.length];
        int posneg = hMax < 0.0 ? -1 : 1;
        hMax = Math.abs(hMax);
        this.ode.getRate(initialState, initialRate);
        double normF = 0.0;
        double normX = 0.0;
        int i = 0;
        while (i < this.numEqn) {
            sk = this.tolerance + this.tolerance * Math.abs(initialState[i]);
            normF += Math.pow(initialRate[i] / sk, 2.0);
            normX += Math.pow(initialState[i] / sk, 2.0);
            ++i;
        }
        double h = normF <= 1.0E-10 || normX <= 1.0E-10 ? 1.0E-6 : Math.sqrt(normX / normF) * 0.01;
        h = (double)posneg * Math.min(h, hMax);
        i = 0;
        while (i < this.numEqn) {
            state[i] = initialState[i] + h * initialRate[i];
            ++i;
        }
        this.ode.getRate(state, rate);
        double der2 = 0.0;
        i = 0;
        while (i < state.length) {
            sk = this.tolerance + this.tolerance * Math.abs(initialState[i]);
            der2 += Math.pow((rate[i] - initialRate[i]) / sk, 2.0);
            ++i;
        }
        der2 = Math.sqrt(der2) / h;
        double der12 = Math.max(Math.abs(der2), Math.sqrt(normF));
        double h1 = 0.0;
        h1 = der12 <= 1.0E-15 ? Math.max(1.0E-6, Math.abs(h) * 0.001) : Math.exp(1.0 / (double)this.methodOrder * Math.log(0.01 / der12));
        h = (double)posneg * Math.min(100.0 * h, h1);
        if (hMax != 0.0) {
            h = (double)posneg * Math.min(Math.abs(h), hMax);
        }
        return h;
    }

    public void setStepSize(double _stepSize) {
        this.stepSize = _stepSize;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setTolerance(double _tol) {
        this.tolerance = Math.abs(_tol);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void doInterpolation(double shortStepValue, double[] result) {
        if (result != this.state) {
            int i = 0;
            while (i < this.numEqn) {
                result[i] = this.initialState[i] + (this.state[i] - this.initialState[i]) * shortStepValue / this.takenStepSize;
                ++i;
            }
        } else {
            System.err.println("Cann't interpolate to the internal state vector. Please call initialize(double, double []) method");
        }
    }
}

