/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

public class IRKLinearAlgebra {
    public int dec(int N, int NDIM, double[][] A, int[] IP) {
        int IER = -1;
        IP[N - 1] = 1;
        int K = 0;
        while (K < N - 1) {
            int KP1 = K + 1;
            int M = K;
            int I = KP1;
            while (I < N) {
                if (Math.abs(A[I][K]) > Math.abs(A[M][K])) {
                    M = I;
                }
                ++I;
            }
            IP[K] = M;
            double T = A[M][K];
            if (M != K) {
                IP[N - 1] = -IP[N - 1];
                A[M][K] = A[K][K];
                A[K][K] = T;
            }
            if (T == 0.0) {
                IER = K;
                IP[N - 1] = 0;
                return IER;
            }
            T = 1.0 / T;
            I = KP1;
            while (I < N) {
                double[] dArray = A[I];
                int n = K;
                dArray[n] = dArray[n] * -T;
                ++I;
            }
            int J = KP1;
            while (J < N) {
                T = A[M][J];
                A[M][J] = A[K][J];
                A[K][J] = T;
                if (T != 0.0) {
                    I = KP1;
                    while (I < N) {
                        double[] dArray = A[I];
                        int n = J;
                        dArray[n] = dArray[n] + A[I][K] * T;
                        ++I;
                    }
                }
                ++J;
            }
            ++K;
        }
        K = N - 1;
        if (A[N - 1][N - 1] == 0.0) {
            IER = K;
            IP[N - 1] = 0;
        }
        return IER;
    }

    public void sol(int N, int NDIM, double[][] A, double[] B, int[] IP) {
        int I;
        double T;
        int K = 0;
        while (K < N - 1) {
            int KP1 = K + 1;
            int M = IP[K];
            T = B[M];
            B[M] = B[K];
            B[K] = T;
            I = KP1;
            while (I < N) {
                int n = I;
                B[n] = B[n] + A[I][K] * T;
                ++I;
            }
            ++K;
        }
        int KB = 1;
        while (KB <= N - 1) {
            int KM1;
            int n = K = (KM1 = N - KB);
            B[n] = B[n] / A[K][K];
            T = -B[K];
            I = 0;
            while (I < KM1) {
                int n2 = I;
                B[n2] = B[n2] + A[I][K] * T;
                ++I;
            }
            ++KB;
        }
        B[0] = B[0] / A[0][0];
    }

    public int decc(int N, int NDIM, double[][] AR, double[][] AI, int[] IP) {
        int IER = -1;
        IP[N - 1] = 1;
        int K = 0;
        while (K < N - 1) {
            double PRODI;
            double PRODR;
            int KP1 = K + 1;
            int M = K;
            int I = KP1;
            while (I < N) {
                if (Math.abs(AR[I][K]) + Math.abs(AI[I][K]) > Math.abs(AR[M][K]) + Math.abs(AI[M][K])) {
                    M = I;
                }
                ++I;
            }
            IP[K] = M;
            double TR = AR[M][K];
            double TI = AI[M][K];
            if (M != K) {
                IP[N - 1] = -IP[N - 1];
                AR[M][K] = AR[K][K];
                AI[M][K] = AI[K][K];
                AR[K][K] = TR;
                AI[K][K] = TI;
            }
            if (Math.abs(TR) + Math.abs(TI) == 0.0) {
                IER = K;
                IP[N - 1] = 0;
                return IER;
            }
            double DEN = TR * TR + TI * TI;
            TR /= DEN;
            TI /= -DEN;
            I = KP1;
            while (I < N) {
                PRODR = AR[I][K] * TR - AI[I][K] * TI;
                PRODI = AI[I][K] * TR + AR[I][K] * TI;
                AR[I][K] = -PRODR;
                AI[I][K] = -PRODI;
                ++I;
            }
            int J = KP1;
            while (J < N) {
                TR = AR[M][J];
                TI = AI[M][J];
                AR[M][J] = AR[K][J];
                AI[M][J] = AI[K][J];
                AR[K][J] = TR;
                AI[K][J] = TI;
                if (Math.abs(TR) + Math.abs(TI) != 0.0) {
                    if (TI == 0.0) {
                        I = KP1;
                        while (I < N) {
                            PRODR = AR[I][K] * TR;
                            PRODI = AI[I][K] * TR;
                            double[] dArray = AR[I];
                            int n = J;
                            dArray[n] = dArray[n] + PRODR;
                            double[] dArray2 = AI[I];
                            int n2 = J;
                            dArray2[n2] = dArray2[n2] + PRODI;
                            ++I;
                        }
                    } else if (TR == 0.0) {
                        I = KP1;
                        while (I < N) {
                            PRODR = -AI[I][K] * TI;
                            PRODI = AR[I][K] * TI;
                            double[] dArray = AR[I];
                            int n = J;
                            dArray[n] = dArray[n] + PRODR;
                            double[] dArray3 = AI[I];
                            int n3 = J;
                            dArray3[n3] = dArray3[n3] + PRODI;
                            ++I;
                        }
                    } else {
                        I = KP1;
                        while (I < N) {
                            PRODR = AR[I][K] * TR - AI[I][K] * TI;
                            PRODI = AI[I][K] * TR + AR[I][K] * TI;
                            double[] dArray = AR[I];
                            int n = J;
                            dArray[n] = dArray[n] + PRODR;
                            double[] dArray4 = AI[I];
                            int n4 = J;
                            dArray4[n4] = dArray4[n4] + PRODI;
                            ++I;
                        }
                    }
                }
                ++J;
            }
            ++K;
        }
        K = N - 1;
        if (Math.abs(AR[N - 1][N - 1]) + Math.abs(AI[N - 1][N - 1]) == 0.0) {
            IER = K;
            IP[N - 1] = 0;
        }
        return IER;
    }

    public void solc(int N, int NDIM, double[][] AR, double[][] AI, double[] BR, double[] BI, int[] IP) {
        double DEN;
        double PRODI;
        double PRODR;
        int I;
        double TI;
        double TR;
        int K = 0;
        while (K < N - 1) {
            int KP1 = K + 1;
            int M = IP[K];
            TR = BR[M];
            TI = BI[M];
            BR[M] = BR[K];
            BI[M] = BI[K];
            BR[K] = TR;
            BI[K] = TI;
            I = KP1;
            while (I < N) {
                PRODR = AR[I][K] * TR - AI[I][K] * TI;
                PRODI = AI[I][K] * TR + AR[I][K] * TI;
                int n = I;
                BR[n] = BR[n] + PRODR;
                int n2 = I++;
                BI[n2] = BI[n2] + PRODI;
            }
            ++K;
        }
        int KB = 1;
        while (KB <= N - 1) {
            int KM1;
            K = KM1 = N - KB;
            DEN = AR[K][K] * AR[K][K] + AI[K][K] * AI[K][K];
            PRODR = BR[K] * AR[K][K] + BI[K] * AI[K][K];
            PRODI = BI[K] * AR[K][K] - BR[K] * AI[K][K];
            BR[K] = PRODR / DEN;
            BI[K] = PRODI / DEN;
            TR = -BR[K];
            TI = -BI[K];
            I = 0;
            while (I < KM1) {
                PRODR = AR[I][K] * TR - AI[I][K] * TI;
                PRODI = AI[I][K] * TR + AR[I][K] * TI;
                int n = I;
                BR[n] = BR[n] + PRODR;
                int n3 = I++;
                BI[n3] = BI[n3] + PRODI;
            }
            ++KB;
        }
        DEN = AR[0][0] * AR[0][0] + AI[0][0] * AI[0][0];
        PRODR = BR[0] * AR[0][0] + BI[0] * AI[0][0];
        PRODI = BI[0] * AR[0][0] - BR[0] * AI[0][0];
        BR[0] = PRODR / DEN;
        BI[0] = PRODI / DEN;
    }

    static class Mathadd {
        public static double sign(double a) {
            if (a > 0.0) {
                return 1.0;
            }
            if (a < 0.0) {
                return -1.0;
            }
            return 0.0;
        }

        public static double sign(double a, double b) {
            if (b >= 0.0) {
                return Math.abs(a);
            }
            return -Math.abs(a);
        }
    }
}

