/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.ode.IRK.AlgebraicEquationSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewtonStep;
import org.opensourcephysics.ode.IRK.LAESolverLU;
import org.opensourcephysics.ode.IRK.NewtonLastIterationErrorIsTooLarge;
import org.opensourcephysics.ode.IRK.NewtonLostOfConvergence;

public class IRKSimplifiedNewton
extends IRKSimplifiedNewtonStep
implements AlgebraicEquationSolver {
    private int numEqn;
    private static final int maxIterations = 7;
    protected int nIteration = 0;
    private double[][] rightHand;
    private double[] tolerance;
    protected double thetaqOld;
    public double fnewt;
    private double convergenceRateOld = 1.0;
    private double faccon = 1.0;

    public IRKSimplifiedNewton(IRKAlgebraicEquation eqn) {
        super(eqn);
        this.initialize(eqn);
    }

    public IRKSimplifiedNewton(IRKAlgebraicEquation eqn, LAESolverLU laeSolver) {
        super(eqn, laeSolver);
        this.initialize(eqn);
    }

    private void initialize(IRKAlgebraicEquation eqn) {
        this.numEqn = eqn.getApproximation()[0].length;
        this.rightHand = super.getSubstitutedApproximationIncrement();
        this.tolerance = new double[this.numEqn];
        int i = 0;
        while (i < this.numEqn) {
            this.setTolerance(i, 1.0E-6);
            ++i;
        }
    }

    public double resolve() throws NewtonLostOfConvergence, NewtonLastIterationErrorIsTooLarge {
        double incrementNorm;
        this.nIteration = 0;
        this.faccon = Math.pow(Math.max(this.faccon, this.uround), 0.8);
        double convergenceRate = 0.001;
        do {
            ++this.nIteration;
            double tmp = super.singleStep();
            incrementNorm = this.estimateIncrementNorm(this.rightHand);
            if (1 < this.nIteration && this.nIteration < 7) {
                convergenceRate = this.nIteration == 2 ? tmp : Math.sqrt(tmp * this.convergenceRateOld);
                this.convergenceRateOld = tmp;
                if (convergenceRate > 0.99) {
                    throw new NewtonLostOfConvergence(this.nIteration, convergenceRate);
                }
                this.faccon = convergenceRate / (1.0 - convergenceRate);
                double error = this.predictLastIterationError(incrementNorm, convergenceRate);
                if (error > 1.0) {
                    throw new NewtonLastIterationErrorIsTooLarge(this.nIteration, 7, error);
                }
            }
            super.commitStep();
        } while (!this.convergenceAchieved(incrementNorm, convergenceRate));
        return convergenceRate;
    }

    protected double estimateIncrementNorm(double[][] dataArray) {
        double incrementNorm = 0.0;
        int i = 0;
        while (i < this.numEqn) {
            int j = 0;
            while (j < 3) {
                incrementNorm += Math.pow(dataArray[j][i] / this.tolerance[i], 2.0);
                ++j;
            }
            ++i;
        }
        return Math.sqrt(incrementNorm / (double)(3 * this.numEqn));
    }

    private double predictLastIterationError(double norm, double convergenceRate) {
        return convergenceRate / (1.0 - convergenceRate) * norm * Math.pow(convergenceRate, 6 - this.nIteration) / this.fnewt;
    }

    private boolean convergenceAchieved(double incrementNorm, double convergenceRate) {
        return this.faccon * incrementNorm < this.fnewt;
    }

    public double getTolerance(int index) {
        return this.tolerance[index];
    }

    public void setTolerance(int index, double tolerance) {
        this.tolerance[index] = tolerance;
    }
}

