/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.LAComplexEquation;
import org.opensourcephysics.ode.IRK.LAEComplexSolverLU;
import org.opensourcephysics.ode.IRK.LAESolverLU;
import org.opensourcephysics.ode.IRK.LAEquation;

public class IRKSimplifiedNewtonStep
implements AlgebraicEquationSimpleSolver {
    protected double uround = 2.220446049250313E-16;
    private IRKAlgebraicEquation eqn;
    private int numEqn;
    private InnerLinearAlgebraicEquation innerLinearAlgebraicEquation;
    private LAESolverLU laeSolver;
    private LAEComplexSolverLU laeComplexSolver;
    private double[][] temporary;
    private double multiplier = 1.0;
    private boolean bestConvergenceRequired;
    private boolean refreshLAEsMatrixes;
    private double[][] substitutedApproximation;
    private double[][] approximation;
    private double[][] substitutedApproximationIncrement;
    private double incrementNormOnPreviousStep = 1.0;

    public IRKSimplifiedNewtonStep(IRKAlgebraicEquation eqn) {
        this.eqn = eqn;
        this.numEqn = eqn.getApproximation()[0].length;
        this.innerLinearAlgebraicEquation = new InnerLinearAlgebraicEquation();
        this.initialize(new LAESolverLU(this.innerLinearAlgebraicEquation));
    }

    public IRKSimplifiedNewtonStep(IRKAlgebraicEquation eqn, LAESolverLU laeSolver) {
        this.eqn = eqn;
        this.numEqn = eqn.getApproximation()[0].length;
        this.innerLinearAlgebraicEquation = new InnerLinearAlgebraicEquation();
        this.initialize(laeSolver);
    }

    private void initialize(LAESolverLU laeSolver) {
        this.laeSolver = laeSolver;
        laeSolver.assignEquation(this.innerLinearAlgebraicEquation);
        this.laeComplexSolver = new LAEComplexSolverLU(this.innerLinearAlgebraicEquation);
        this.approximation = this.eqn.getApproximation();
        this.temporary = new double[3][this.numEqn];
        this.substitutedApproximation = new double[3][this.numEqn];
        this.substitutedApproximationIncrement = new double[3][this.numEqn];
        this.refreshLAEsMatrixes = true;
        this.bestConvergenceRequired = true;
    }

    public void updateInitialValue() {
        this.eqn.directChangeOfVariables(this.approximation, this.substitutedApproximation);
    }

    public void restart(boolean bestConvergenceRequired) {
        this.refreshLAEsMatrixes = this.multiplier != this.eqn.getScalarMultiplier();
        this.eqn.directChangeOfVariables(this.approximation, this.substitutedApproximation);
        this.bestConvergenceRequired = bestConvergenceRequired;
        this.incrementNormOnPreviousStep = 0.0;
    }

    protected double[][] getSubstitutedApproximationIncrement() {
        return this.substitutedApproximationIncrement;
    }

    public double singleStep() {
        this.multiplier = this.eqn.getScalarMultiplier();
        this.innerLinearAlgebraicEquation.initialize();
        if (this.refreshLAEsMatrixes || this.bestConvergenceRequired) {
            this.laeSolver.initialize();
            this.laeComplexSolver.initialize();
        }
        this.laeSolver.resolve(this.substitutedApproximationIncrement[0]);
        this.laeComplexSolver.resolve(this.substitutedApproximationIncrement[1], this.substitutedApproximationIncrement[2]);
        this.refreshLAEsMatrixes = false;
        this.bestConvergenceRequired = false;
        double incrementNorm = this.estimateIncrementNorm(this.substitutedApproximationIncrement);
        double convergenceRate = this.incrementNormOnPreviousStep != 0.0 ? incrementNorm / this.incrementNormOnPreviousStep : 0.001;
        this.incrementNormOnPreviousStep = Math.max(incrementNorm, this.uround);
        return convergenceRate;
    }

    protected void commitStep() {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < this.numEqn) {
                double[] dArray = this.substitutedApproximation[i];
                int n = j;
                dArray[n] = dArray[n] + this.substitutedApproximationIncrement[i][j];
                ++j;
            }
            ++i;
        }
        this.eqn.inverseChangeOfVariables(this.substitutedApproximation, this.approximation);
    }

    public double resolve() {
        double convergenceRate = this.singleStep();
        this.commitStep();
        return convergenceRate;
    }

    protected double estimateIncrementNorm(double[][] dataArray) {
        double incrementNorm = 0.0;
        int i = 0;
        while (i < this.numEqn) {
            int j = 0;
            while (j < 3) {
                incrementNorm += Math.pow(dataArray[j][i], 2.0);
                ++j;
            }
            ++i;
        }
        return Math.sqrt(incrementNorm / (double)(3 * this.numEqn));
    }

    private class InnerLinearAlgebraicEquation
    implements LAEquation,
    LAComplexEquation {
        private double[][] jac;
        private double[] realEigenvalues;
        private double[] complexEigenvalues;
        private double[][] substitutedNonLinearComponent;

        public InnerLinearAlgebraicEquation() {
            this.realEigenvalues = IRKSimplifiedNewtonStep.this.eqn.getRealEigenvalues();
            this.complexEigenvalues = IRKSimplifiedNewtonStep.this.eqn.getComplexEigenvalues();
            this.substitutedNonLinearComponent = new double[3][IRKSimplifiedNewtonStep.this.numEqn];
            this.jac = new double[IRKSimplifiedNewtonStep.this.numEqn][IRKSimplifiedNewtonStep.this.numEqn];
        }

        public void initialize() {
            int i = 0;
            while (i < 3) {
                IRKSimplifiedNewtonStep.this.eqn.evaluateNonLinearComponent(IRKSimplifiedNewtonStep.this.approximation[i], IRKSimplifiedNewtonStep.this.temporary[i]);
                ++i;
            }
            IRKSimplifiedNewtonStep.this.eqn.directChangeOfVariables(IRKSimplifiedNewtonStep.this.temporary, this.substitutedNonLinearComponent);
            if (IRKSimplifiedNewtonStep.this.bestConvergenceRequired) {
                IRKSimplifiedNewtonStep.this.eqn.evaluateNonLinearComponentJacobian(IRKSimplifiedNewtonStep.this.approximation[2], this.jac);
            }
        }

        public int getDimension() {
            return IRKSimplifiedNewtonStep.this.numEqn;
        }

        public void getMatrix(double[][] matrix) {
            int i = 0;
            while (i < IRKSimplifiedNewtonStep.this.numEqn) {
                int j = 0;
                while (j < IRKSimplifiedNewtonStep.this.numEqn) {
                    matrix[i][j] = -this.jac[i][j];
                    ++j;
                }
                double[] dArray = matrix[i];
                int n = i++;
                dArray[n] = dArray[n] + IRKSimplifiedNewtonStep.this.multiplier * this.realEigenvalues[0];
            }
        }

        public void getMatrixes(double[][] matrixRe, double[][] matrixIm) {
            int i = 0;
            while (i < IRKSimplifiedNewtonStep.this.numEqn) {
                int j = 0;
                while (j < IRKSimplifiedNewtonStep.this.numEqn) {
                    matrixRe[i][j] = -this.jac[i][j];
                    matrixIm[i][j] = 0.0;
                    ++j;
                }
                double[] dArray = matrixRe[i];
                int n = i;
                dArray[n] = dArray[n] + IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[0];
                double[] dArray2 = matrixIm[i];
                int n2 = i++;
                dArray2[n2] = dArray2[n2] + IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[1];
            }
        }

        public void getVector(double[] vector) {
            int i = 0;
            while (i < IRKSimplifiedNewtonStep.this.numEqn) {
                double lambdaN = IRKSimplifiedNewtonStep.this.multiplier * this.realEigenvalues[0];
                vector[i] = this.substitutedNonLinearComponent[0][i] - lambdaN * IRKSimplifiedNewtonStep.this.substitutedApproximation[0][i];
                ++i;
            }
        }

        public void getVectors(double[] vectorRe, double[] vectorIm) {
            int i = 0;
            while (i < IRKSimplifiedNewtonStep.this.numEqn) {
                double alphaN = IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[0];
                double betaN = IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[1];
                double s2 = -IRKSimplifiedNewtonStep.this.substitutedApproximation[1][i];
                double s3 = -IRKSimplifiedNewtonStep.this.substitutedApproximation[2][i];
                vectorRe[i] = this.substitutedNonLinearComponent[1][i];
                vectorIm[i] = this.substitutedNonLinearComponent[2][i];
                int n = i;
                vectorRe[n] = vectorRe[n] + (s2 * alphaN - s3 * betaN);
                int n2 = i++;
                vectorIm[n2] = vectorIm[n2] + (s3 * alphaN + s2 * betaN);
            }
        }
    }
}

