/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.ode.IRK.IRKLinearAlgebra;
import org.opensourcephysics.ode.IRK.LAComplexEquation;

public class LAEComplexSolverLU {
    LAComplexEquation eqn;
    private IRKLinearAlgebra linalg = new IRKLinearAlgebra();
    int numEqn;
    double[][] luDecompositionRe;
    double[][] luDecompositionIm;
    double[] rightHandVectorRe;
    double[] rightHandVectorIm;
    int[] stuff;

    public LAEComplexSolverLU(LAComplexEquation eqn) {
        this.numEqn = eqn.getDimension();
        this.assignEquation(eqn);
        this.luDecompositionRe = new double[this.numEqn][this.numEqn];
        this.luDecompositionIm = new double[this.numEqn][this.numEqn];
        this.rightHandVectorRe = new double[this.numEqn];
        this.rightHandVectorIm = new double[this.numEqn];
        this.stuff = new int[this.numEqn];
    }

    public void assignEquation(LAComplexEquation eqn) {
        if (eqn.getDimension() == this.numEqn) {
            this.eqn = eqn;
        } else {
            System.err.println("Equation hasn't been added because dimension");
        }
    }

    public void initialize() {
        this.eqn.getMatrixes(this.luDecompositionRe, this.luDecompositionIm);
        this.linalg.decc(this.numEqn, this.numEqn, this.luDecompositionRe, this.luDecompositionIm, this.stuff);
    }

    public void resolve(double[] solutionRe, double[] solutionIm) {
        if (this.luDecompositionRe != null && this.luDecompositionIm != null) {
            this.eqn.getVectors(this.rightHandVectorRe, this.rightHandVectorIm);
            this.linalg.solc(this.numEqn, this.numEqn, this.luDecompositionRe, this.luDecompositionIm, this.rightHandVectorRe, this.rightHandVectorIm, this.stuff);
            System.arraycopy(this.rightHandVectorRe, 0, solutionRe, 0, this.numEqn);
            System.arraycopy(this.rightHandVectorIm, 0, solutionIm, 0, this.numEqn);
        }
    }
}

