/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.ode.IRK.IRKLinearAlgebra;
import org.opensourcephysics.ode.IRK.LAEquation;

public class LAESolverLU {
    private LAEquation eqn;
    private IRKLinearAlgebra linalg = new IRKLinearAlgebra();
    private int numEqn;
    double[][] luDecomposition;
    double[] rightHandVector;
    int[] stuff;

    public LAEquation getEquation() {
        return this.eqn;
    }

    public LAESolverLU(int numEqn) {
        this.numEqn = numEqn;
        this.luDecomposition = new double[numEqn][numEqn];
        this.rightHandVector = new double[numEqn];
        this.stuff = new int[numEqn];
    }

    public LAESolverLU(LAEquation eqn) {
        this.assignEquation(eqn);
        this.numEqn = eqn.getDimension();
        this.luDecomposition = new double[this.numEqn][this.numEqn];
        this.rightHandVector = new double[this.numEqn];
        this.stuff = new int[this.numEqn];
    }

    public void assignEquation(LAEquation eqn) {
        if (eqn.getDimension() == this.numEqn) {
            this.eqn = eqn;
        } else {
            System.err.println("Equation hasn't been added because dimension");
        }
    }

    public void initialize() {
        this.eqn.getMatrix(this.luDecomposition);
        this.linalg.dec(this.numEqn, this.numEqn, this.luDecomposition, this.stuff);
    }

    public void resolve(double[] solution) {
        if (this.luDecomposition != null) {
            this.eqn.getVector(this.rightHandVector);
            this.linalg.sol(this.numEqn, this.numEqn, this.luDecomposition, this.rightHandVector, this.stuff);
            System.arraycopy(this.rightHandVector, 0, solution, 0, this.numEqn);
        }
    }
}

