/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.IRK.Radau5Adaptive;
import org.opensourcephysics.ode.ODEInterpolator;

public class Radau5
extends Radau5Adaptive
implements ODEInterpolator {
    static final double c1 = (4.0 - Math.sqrt(6.0)) / 10.0;
    static final double c2 = (4.0 + Math.sqrt(6.0)) / 10.0;
    static final double c1m1 = c1 - 1.0;
    static final double c2m1 = c2 - 1.0;
    static final double c1mc2 = c1 - c2;
    double[][] interpolationCoeffs;
    double takenStepSize = 0.0;

    public Radau5(ODE ode) {
        super(ode);
        this.interpolationCoeffs = new double[4][ode.getState().length];
    }

    public double step() {
        this.takenStepSize = super.step();
        this.constructInterpolationCoeffs();
        return this.takenStepSize;
    }

    public void constructInterpolationCoeffs() {
        int i = 0;
        while (i < this.numEqn) {
            this.interpolationCoeffs[0][i] = this.state[i];
            this.interpolationCoeffs[1][i] = (this.intermediateStagesIncrement[1][i] - this.intermediateStagesIncrement[2][i]) / c2m1;
            double ak = (this.intermediateStagesIncrement[0][i] - this.intermediateStagesIncrement[1][i]) / c1mc2;
            double acont3 = this.intermediateStagesIncrement[0][i] / c1;
            acont3 = (ak - acont3) / c2;
            this.interpolationCoeffs[2][i] = (ak - this.interpolationCoeffs[1][i]) / c1m1;
            this.interpolationCoeffs[3][i] = this.interpolationCoeffs[2][i] - acont3;
            ++i;
        }
    }

    public void doInterpolation(double time, double[] result) {
        if (this.takenStepSize == 0.0) {
            int i = 0;
            while (i < this.numEqn) {
                result[i] = this.state[i];
                ++i;
            }
        }
        double s = (time - this.takenStepSize) / this.takenStepSize;
        int i = 0;
        while (i < this.numEqn) {
            result[i] = this.interpolationCoeffs[0][i] + s * (this.interpolationCoeffs[1][i] + (s - c2m1) * (this.interpolationCoeffs[2][i] + (s - c1m1) * this.interpolationCoeffs[3][i]));
            ++i;
        }
    }

    protected void estimateNewtonInitialValue(double[][] initialvalue) {
        double s = this.stepSize / this.takenStepSize;
        double s1 = c1 * s;
        double s2 = c2 * s;
        int i = 0;
        while (i < this.numEqn) {
            initialvalue[0][i] = s1 * (this.interpolationCoeffs[1][i] + (s1 - c2m1) * (this.interpolationCoeffs[2][i] + (s1 - c1m1) * this.interpolationCoeffs[3][i]));
            initialvalue[1][i] = s2 * (this.interpolationCoeffs[1][i] + (s2 - c2m1) * (this.interpolationCoeffs[2][i] + (s2 - c1m1) * this.interpolationCoeffs[3][i]));
            initialvalue[2][i] = s * (this.interpolationCoeffs[1][i] + (s - c2m1) * (this.interpolationCoeffs[2][i] + (s - c1m1) * this.interpolationCoeffs[3][i]));
            ++i;
        }
    }
}

