/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewton;
import org.opensourcephysics.ode.IRK.LAESolverLU;
import org.opensourcephysics.ode.IRK.LAEquation;
import org.opensourcephysics.ode.IRK.NewtonLastIterationErrorIsTooLarge;
import org.opensourcephysics.ode.IRK.NewtonLostOfConvergence;
import org.opensourcephysics.ode.IRK.Radau5Light;

public class Radau5Adaptive
extends Radau5Light
implements ODEAdaptiveSolver {
    int error_code = 0;
    private double currentStepSize;
    private double tolerance = 1.0E-6;
    private int nRejected = 0;
    private int nAcceptedSteps = 0;
    double[] scal;
    private ErrorFirstAproximationEquation errorApproximationEquation = new ErrorFirstAproximationEquation(this.numEqn);
    private LAESolverLU laeSolver;
    Radau5Light.DifferenceSchemeEquation chekit;
    double hacc = 1.0;
    double erracc = 1.0;

    public Radau5Adaptive(ODE ode) {
        super(ode);
        this.scal = new double[this.numEqn];
    }

    protected AlgebraicEquationSimpleSolver getInnerSolver(IRKAlgebraicEquation algEqn) {
        this.laeSolver = new LAESolverLU(this.numEqn);
        return new MyNewton(algEqn, this.laeSolver);
    }

    protected void estimateNewtonInitialValue(double[][] initialvalue) {
        double factor = this.currentStepSize / this.stepSize;
        int j = 0;
        while (j < 3) {
            int i = 0;
            while (i < this.numEqn) {
                double[] dArray = initialvalue[j];
                int n = i++;
                dArray[n] = dArray[n] * factor;
            }
            ++j;
        }
    }

    protected void preStepPreparations() {
        super.preStepPreparations();
        this.nRejected = 0;
    }

    public double step() {
        this.error_code = 0;
        this.preStepPreparations();
        double error = 0.0;
        if (this.nAcceptedSteps > 0) {
            this.estimateNewtonInitialValue(this.intermediateStagesIncrement);
            this.aeSolver.updateInitialValue();
        }
        do {
            this.currentStepSize = this.stepSize;
            try {
                double newtonConvergenceRate = this.aeSolver.resolve();
                error = this.estimateError();
                this.stepSize = this.estimateStepSize(error, ((MyNewton)this.aeSolver).getnIter(), 7.0);
                if (error < 1.0) {
                    if (Math.abs(this.stepSize / this.currentStepSize - 1.1) <= 0.1 && newtonConvergenceRate <= 0.001) {
                        this.stepSize = this.currentStepSize;
                    }
                    this.aeSolver.restart(newtonConvergenceRate > 0.001);
                    continue;
                }
                ++this.nRejected;
                this.aeSolver.restart(this.jacobianAge > 0);
            }
            catch (NewtonLostOfConvergence newtonLostOfConvergence) {
                this.stepSize = this.currentStepSize / 2.0;
                this.aeSolver.restart(this.jacobianAge > 0);
                ++this.nRejected;
                error = 10.0;
            }
            catch (NewtonLastIterationErrorIsTooLarge e) {
                double qnewt = Math.max(1.0E-4, Math.min(20.0, e.getToleranceViolation()));
                this.stepSize = this.currentStepSize * 0.8 * Math.pow(qnewt, -1.0 / (4.0 + (double)e.getMaxIterationsAllowed() - 1.0 - (double)e.getIterationNumber()));
                this.aeSolver.restart(this.jacobianAge > 0);
                ++this.nRejected;
                error = 10.0;
            }
        } while (error > 1.0);
        this.commitStepResults();
        return this.currentStepSize;
    }

    protected void commitStepResults() {
        super.commitStepResults();
        ++this.nAcceptedSteps;
        ++this.jacobianAge;
    }

    protected double estimateError() {
        double[] someState = new double[this.numEqn];
        double error = 0.0;
        LAEquation newtonsLAE = this.laeSolver.getEquation();
        this.laeSolver.assignEquation(this.errorApproximationEquation);
        this.laeSolver.resolve(someState);
        error = 0.0;
        int i = 0;
        while (i < this.numEqn) {
            error += Math.pow(someState[i] / this.scal[i], 2.0);
            ++i;
        }
        if ((error = Math.max(Math.sqrt(error / (double)this.numEqn), 1.0E-10)) > 1.0 && (this.nRejected > 0 || this.nAcceptedSteps == 0)) {
            this.laeSolver.assignEquation(this.errorApproximationEquation.getSecondErrorAproximationEquation(someState));
            this.laeSolver.resolve(someState);
            error = 0.0;
            i = 0;
            while (i < this.numEqn) {
                error += Math.pow(someState[i] / this.scal[i], 2.0);
                ++i;
            }
            error = Math.max(Math.sqrt(error / (double)this.numEqn), 1.0E-10);
        }
        this.laeSolver.assignEquation(newtonsLAE);
        return error;
    }

    protected double estimateStepSize(double error, double nNewtonIteration, double maxNewtonIterations) {
        double safe = 0.9;
        double facLeft = 5.0;
        double facRight = 0.125;
        double cfac = safe * (1.0 + 2.0 * maxNewtonIterations);
        double fac = Math.min(safe, cfac / (nNewtonIteration + 2.0 * maxNewtonIterations));
        double quot = Math.max(facRight, Math.min(facLeft, Math.pow(error, 0.25) / fac));
        double hnew = this.currentStepSize / quot;
        if (error < 1.0) {
            if (this.nAcceptedSteps > 0) {
                double facgus = this.hacc / this.currentStepSize * Math.pow(error * error / this.erracc, 0.25) / safe;
                facgus = Math.max(facRight, Math.min(facLeft, facgus));
                quot = Math.max(quot, facgus);
                hnew = this.currentStepSize / quot;
            }
            this.hacc = this.currentStepSize;
            this.erracc = Math.max(0.01, error);
        } else if (this.nAcceptedSteps == 0) {
            hnew = this.currentStepSize * 0.1;
        }
        return hnew;
    }

    public void setStepSize(double stepSize) {
        super.setStepSize(stepSize);
        this.aeSolver.restart(false);
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance = 0.1 * Math.pow(tolerance, 0.6666666666666666);
        int i = 0;
        while (i < this.numEqn) {
            this.scal[i] = tolerance + tolerance * Math.abs(this.state[i]);
            ((AlgebraicEquationSolver)this.aeSolver).setTolerance(i, this.scal[i]);
            ++i;
        }
        double uround = 2.220446049250313E-16;
        ((IRKSimplifiedNewton)this.aeSolver).fnewt = Math.max(10.0 * uround / tolerance, Math.min(0.03, Math.pow(tolerance, 0.5)));
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getErrorCode() {
        return this.error_code;
    }

    private class ErrorFirstAproximationEquation
    implements LAEquation {
        private double[] err = new double[]{-10.048809399827414, 1.382142733160748, -0.3333333333333333};
        private double[] temporary;
        ErrorSecondApproximationEquation errorSecondApproximationEquation;

        public ErrorFirstAproximationEquation(int numEqn) {
            this.temporary = new double[numEqn];
        }

        public int getDimension() {
            return Radau5Adaptive.this.numEqn;
        }

        public void getMatrix(double[][] matrix) {
        }

        public void getVector(double[] vector) {
            int i = 0;
            while (i < Radau5Adaptive.this.numEqn) {
                this.temporary[i] = 0.0;
                int j = 0;
                while (j < this.err.length) {
                    int n = i;
                    this.temporary[n] = this.temporary[n] + this.err[j] / Radau5Adaptive.this.currentStepSize * Radau5Adaptive.this.intermediateStagesIncrement[j][i];
                    ++j;
                }
                vector[i] = this.temporary[i] + Radau5Adaptive.this.rate[i];
                ++i;
            }
        }

        public ErrorSecondApproximationEquation getSecondErrorAproximationEquation(double[] errorApproximation) {
            if (this.errorSecondApproximationEquation == null) {
                this.errorSecondApproximationEquation = new ErrorSecondApproximationEquation(Radau5Adaptive.this.numEqn, errorApproximation);
            }
            return this.errorSecondApproximationEquation;
        }

        private class ErrorSecondApproximationEquation
        implements LAEquation {
            double[] tmpRate;
            double[] errorApproximation;

            public ErrorSecondApproximationEquation(int numEqn, double[] errorApproximation) {
                this.tmpRate = new double[numEqn];
                this.errorApproximation = errorApproximation;
            }

            public int getDimension() {
                return ((ErrorFirstAproximationEquation)ErrorFirstAproximationEquation.this).Radau5Adaptive.this.numEqn;
            }

            public void getMatrix(double[][] matrix) {
            }

            public void getVector(double[] vector) {
                if (ErrorFirstAproximationEquation.this.temporary == null) {
                    System.err.println("Inner's getVector should be invoked earlier than that one");
                }
                int i = 0;
                while (i < ((ErrorFirstAproximationEquation)ErrorFirstAproximationEquation.this).Radau5Adaptive.this.numEqn) {
                    int n = i;
                    this.errorApproximation[n] = this.errorApproximation[n] + ((ErrorFirstAproximationEquation)ErrorFirstAproximationEquation.this).Radau5Adaptive.this.state[i];
                    ++i;
                }
                ((ErrorFirstAproximationEquation)ErrorFirstAproximationEquation.this).Radau5Adaptive.this.ode.getRate(this.errorApproximation, this.tmpRate);
                i = 0;
                while (i < ((ErrorFirstAproximationEquation)ErrorFirstAproximationEquation.this).Radau5Adaptive.this.numEqn) {
                    vector[i] = ErrorFirstAproximationEquation.this.temporary[i] + this.tmpRate[i];
                    ++i;
                }
            }
        }
    }

    private class MyNewton
    extends IRKSimplifiedNewton {
        MyNewton(IRKAlgebraicEquation eqn, LAESolverLU laeSolver) {
            super(eqn, laeSolver);
        }

        MyNewton(IRKAlgebraicEquation eqn) {
            super(eqn);
        }

        double getnIter() {
            return this.nIteration;
        }
    }
}

