/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewtonStep;

public class Radau5Light
implements ODESolver {
    protected ODE ode;
    protected double stepSize = 1.0E-6;
    protected int numEqn;
    protected int jacobianAge = 0;
    private int nSteps = 0;
    protected double[] state;
    protected double[] rate;
    protected double[][] intermediateStagesIncrement;
    protected AlgebraicEquationSimpleSolver aeSolver;
    protected static int maxNewtonIterations = 7;

    public Radau5Light(ODE ode) {
        this.ode = ode;
        this.state = ode.getState();
        this.numEqn = this.state.length;
        this.rate = new double[this.numEqn];
        this.intermediateStagesIncrement = new double[3][this.numEqn];
        this.aeSolver = this.getInnerSolver(new DifferenceSchemeEquation(this.numEqn));
    }

    protected AlgebraicEquationSimpleSolver getInnerSolver(IRKAlgebraicEquation algEqn) {
        return new IRKSimplifiedNewtonStep(algEqn);
    }

    protected void preStepPreparations() {
        this.ode.getRate(this.state, this.rate);
    }

    protected void performStep() {
        double convergenceRate = 0.0;
        int i = 0;
        while (i < maxNewtonIterations) {
            convergenceRate += this.aeSolver.resolve() / (double)maxNewtonIterations;
            ++i;
        }
        this.aeSolver.restart(convergenceRate > 0.001);
    }

    protected void commitStepResults() {
        int i = 0;
        while (i < this.numEqn) {
            int n = i;
            this.state[n] = this.state[n] + this.intermediateStagesIncrement[2][i];
            ++i;
        }
    }

    public double step() {
        this.preStepPreparations();
        this.commitStepResults();
        this.aeSolver.restart(++this.nSteps % 4 == 0);
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void initialize(double stepSize) {
    }

    protected class DifferenceSchemeEquation
    implements IRKAlgebraicEquation {
        private double[] realEigenvalues = new double[]{3.6378342527444962};
        private double[] complexEigenvalues = new double[]{2.6810828736277523, 3.0504301992474105};
        private double[][] T = new double[][]{{0.09123239487089295, -0.1412552950209542, -0.030029194105147424}, {0.241717932707107, 0.20412935229379994, 0.3829421127572619}, {0.966048182615093, 1.0, 0.0}};
        private double[][] inverseT = new double[][]{{4.325579890063155, 0.33919925181580984, 0.5417705399358749}, {-4.178718591551905, -0.32768282076106237, 0.47662355450055044}, {-0.5028726349457868, 2.571926949855605, -0.5960392048282249}};
        private int nStgs = 3;
        private double[] someState;
        private double[] someRate;
        double uRound = 2.220446049250313E-16;

        public void evaluate(double[][] stageIncrement, double[][] residual) {
            int j;
            int k;
            int j2;
            double[][] a = new double[3][3];
            double[][] tmp_a = new double[3][3];
            a[0][0] = this.realEigenvalues[0];
            a[1][1] = this.complexEigenvalues[0];
            a[1][2] = -this.complexEigenvalues[1];
            a[2][1] = this.complexEigenvalues[1];
            a[2][2] = this.complexEigenvalues[0];
            int i = 0;
            while (i < 3) {
                j2 = 0;
                while (j2 < 3) {
                    tmp_a[i][j2] = 0.0;
                    k = 0;
                    while (k < 3) {
                        double[] dArray = tmp_a[i];
                        int n = j2;
                        dArray[n] = dArray[n] + this.T[i][k] * a[k][j2];
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
            i = 0;
            while (i < 3) {
                j2 = 0;
                while (j2 < 3) {
                    a[i][j2] = 0.0;
                    k = 0;
                    while (k < 3) {
                        double[] dArray = a[i];
                        int n = j2;
                        dArray[n] = dArray[n] + tmp_a[i][k] * this.inverseT[k][j2];
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
            double[][] f = new double[3][Radau5Light.this.numEqn];
            int i2 = 0;
            while (i2 < 3) {
                this.evaluateNonLinearComponent(stageIncrement[i2], f[i2]);
                ++i2;
            }
            int k2 = 0;
            while (k2 < Radau5Light.this.numEqn) {
                j = 0;
                while (j < 3) {
                    int i3 = 0;
                    while (i3 < 3) {
                        residual[j][k2] = a[j][i3] * f[i3][k2];
                        ++i3;
                    }
                    ++j;
                }
                ++k2;
            }
            k2 = 0;
            while (k2 < Radau5Light.this.numEqn) {
                j = 0;
                while (j < 3) {
                    double[] dArray = residual[j];
                    int n = k2;
                    dArray[n] = dArray[n] - stageIncrement[j][k2] / Radau5Light.this.stepSize;
                    ++j;
                }
                ++k2;
            }
        }

        public DifferenceSchemeEquation(int numEqn) {
            this.someState = new double[numEqn];
            this.someRate = new double[numEqn];
        }

        public double[][] getApproximation() {
            return Radau5Light.this.intermediateStagesIncrement;
        }

        public double[] getComplexEigenvalues() {
            return this.complexEigenvalues;
        }

        public double[] getRealEigenvalues() {
            return this.realEigenvalues;
        }

        public double getScalarMultiplier() {
            return 1.0 / Radau5Light.this.stepSize;
        }

        public void evaluateNonLinearComponent(double[] freeVariable, double[] functionValue) {
            int i = 0;
            while (i < Radau5Light.this.numEqn) {
                this.someState[i] = Radau5Light.this.state[i] + freeVariable[i];
                ++i;
            }
            Radau5Light.this.ode.getRate(this.someState, functionValue);
        }

        public void evaluateNonLinearComponentJacobian(double[] freeVariable, double[][] jacobian) {
            System.arraycopy(Radau5Light.this.state, 0, this.someState, 0, Radau5Light.this.numEqn);
            int i = 0;
            while (i < Radau5Light.this.numEqn) {
                double delta = Math.sqrt(this.uRound * Math.max(1.0E-5, Math.abs(Radau5Light.this.state[i])));
                int n = i;
                this.someState[n] = this.someState[n] + delta;
                Radau5Light.this.ode.getRate(this.someState, this.someRate);
                int n2 = i;
                this.someState[n2] = this.someState[n2] - delta;
                int j = 0;
                while (j < Radau5Light.this.numEqn) {
                    jacobian[j][i] = (this.someRate[j] - Radau5Light.this.rate[j]) / delta;
                    ++j;
                }
                ++i;
            }
            Radau5Light.this.jacobianAge = 0;
        }

        public void directChangeOfVariables(double[][] freeVariable, double[][] substitutedVariable) {
            int k = 0;
            while (k < Radau5Light.this.numEqn) {
                int i = 0;
                while (i < this.nStgs) {
                    substitutedVariable[i][k] = 0.0;
                    int j = 0;
                    while (j < this.nStgs) {
                        double[] dArray = substitutedVariable[i];
                        int n = k;
                        dArray[n] = dArray[n] + this.inverseT[i][j] * freeVariable[j][k];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
        }

        public void inverseChangeOfVariables(double[][] substitutedVariable, double[][] freeVariable) {
            int k = 0;
            while (k < Radau5Light.this.numEqn) {
                int i = 0;
                while (i < this.nStgs) {
                    freeVariable[i][k] = 0.0;
                    int j = 0;
                    while (j < this.nStgs) {
                        double[] dArray = freeVariable[i];
                        int n = k;
                        dArray[n] = dArray[n] + this.T[i][j] * substitutedVariable[j][k];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
        }
    }
}

