/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.ode.Dopri5;
import org.opensourcephysics.ode.Dopri853;
import org.opensourcephysics.ode.IRK.Radau5;
import org.opensourcephysics.ode.ODEInterpolator;

public class ODEInterpolationSolver
implements org.opensourcephysics.numerics.ODEInterpolationSolver,
ODE {
    private double fixedStepSize;
    private double remainder;
    private double takenStepSize;
    private double[] odeSolverState;
    private ODEInterpolator solverCore;
    private ODE userODE;

    private ODEInterpolationSolver() {
        this.remainder = this.fixedStepSize = 0.1;
        this.takenStepSize = 0.0;
        this.remainder = this.fixedStepSize;
    }

    public ODEInterpolationSolver(ODE ode) {
        this.remainder = this.fixedStepSize = 0.1;
        this.takenStepSize = 0.0;
        this.odeSolverState = new double[ode.getState().length];
        this.solverCore = new Dopri853(this.setODE(ode));
        this.initialize(0.1);
    }

    public ODEInterpolationSolver(ODE ode, String solverClass) {
        this.remainder = this.fixedStepSize = 0.1;
        this.takenStepSize = 0.0;
        this.odeSolverState = new double[ode.getState().length];
        this.solverCore = "dopri5".equalsIgnoreCase(solverClass) ? new Dopri5(this.setODE(ode)) : ("radau5".equalsIgnoreCase(solverClass) ? new Radau5(this.setODE(ode)) : new Dopri853(this.setODE(ode)));
        this.initialize(0.1);
    }

    public static ODEAdaptiveSolver Dopri5(ODE ode) {
        ODEInterpolationSolver interpolationSolver = new ODEInterpolationSolver(ode);
        interpolationSolver.solverCore = new Dopri5(interpolationSolver.setODE(ode));
        return interpolationSolver;
    }

    public static ODEAdaptiveSolver Dopri853(ODE ode) {
        ODEInterpolationSolver interpolationSolver = new ODEInterpolationSolver(ode);
        interpolationSolver.solverCore = new Dopri853(interpolationSolver.setODE(ode));
        return interpolationSolver;
    }

    public static ODEAdaptiveSolver Radau5(ODE ode) {
        ODEInterpolationSolver interpolationSolver = new ODEInterpolationSolver(ode);
        interpolationSolver.solverCore = new Radau5(interpolationSolver.setODE(ode));
        return interpolationSolver;
    }

    public void initialize(double _stepSize) {
        this.remainder = this.fixedStepSize = _stepSize;
        System.arraycopy(this.userODE.getState(), 0, this.odeSolverState, 0, this.odeSolverState.length);
        this.solverCore.initialize(0.1);
    }

    public double step() {
        while (this.fixedStepSize * this.remainder > 0.0) {
            this.takenStepSize = this.solverCore.step();
            this.remainder -= this.takenStepSize;
        }
        this.solverCore.doInterpolation(this.remainder + this.takenStepSize, this.userODE.getState());
        this.remainder += this.fixedStepSize;
        return this.fixedStepSize;
    }

    public int getErrorCode() {
        return this.solverCore.getErrorCode();
    }

    public void getRate(double[] state, double[] rate) {
        this.userODE.getRate(state, rate);
    }

    public double[] getState() {
        return this.odeSolverState;
    }

    public double getStepSize() {
        return this.fixedStepSize;
    }

    public double getTolerance() {
        return this.solverCore.getTolerance();
    }

    private ODE setODE(ODE ode) {
        this.userODE = ode;
        System.arraycopy(ode.getState(), 0, this.odeSolverState, 0, this.odeSolverState.length);
        return this;
    }

    public void setStepSize(double stepSize) {
        if (stepSize == 0.0) {
            System.err.println("Error: The stepsize in ODE solvers cannot be zero.");
            stepSize = 0.1;
        }
        if (this.fixedStepSize * stepSize < 0.0) {
            this.solverCore.setStepSize(-this.solverCore.getStepSize());
        }
        this.remainder += stepSize - this.fixedStepSize;
        this.fixedStepSize = stepSize;
    }

    public void setTolerance(double _tol) {
        this.solverCore.setTolerance(_tol);
    }
}

