/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class DataTool
extends OSPFrame
implements Tool,
PropertyChangeListener {
    public static boolean loadClass = false;
    protected static JFileChooser chooser;
    protected static Dimension dim;
    protected static int buttonHeight;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControl control = new XMLControlElement();
    protected JobManager jobManager = new JobManager(this);
    protected Data addableData = null;
    protected JMenuBar emptyMenubar;
    protected JMenu emptyFileMenu;
    protected JMenuItem emptyOpenItem;
    protected JMenuItem emptyExitItem;
    protected JMenu emptyEditMenu;
    protected JMenuItem emptyPasteItem;
    protected JMenuBar menubar;
    protected JMenu fileMenu;
    protected JMenuItem openItem;
    protected JMenuItem exportItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenu editMenu;
    protected JMenu copyMenu;
    protected JMenuItem copyImageItem;
    protected JMenuItem copyTabItem;
    protected JMenuItem copyDatasetItem;
    protected JMenuItem copyDataRowsItem;
    protected JMenu pasteMenu;
    protected JMenuItem pasteNewTabItem;
    protected JMenuItem pasteColumnsItem;
    protected JMenu helpMenu;
    protected JMenuItem helpItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected FunctionTool dataFunctionTool;
    protected JLabel helpLabel;
    protected TextFrame helpFrame;
    protected String helpPath = "data_tool_help.html";
    protected String helpBase = "http://www.opensourcephysics.org/online_help/tools/";
    static final DataTool DATATOOL;

    static {
        dim = new Dimension(720, 500);
        buttonHeight = 28;
        DATATOOL = new DataTool();
    }

    public static DataTool getTool() {
        return DATATOOL;
    }

    public DataTool() {
        this(ToolsRes.getString("DataTool.Frame.Title"), "DataTool");
    }

    public DataTool(String string) {
        this();
        this.open(string);
    }

    public DataTool(XMLControl xMLControl) {
        this();
        this.addTab(xMLControl);
    }

    public DataTool(Data data) {
        this();
        this.addTab(data);
    }

    public DataTool(Data data, String string) {
        this();
        this.addTab(data, string);
    }

    public DataToolTab addTab(XMLControl xMLControl) {
        if (DataToolTab.class.isAssignableFrom(xMLControl.getObjectClass())) {
            DataToolTab dataToolTab = (DataToolTab)xMLControl.loadObject(null);
            dataToolTab.dataTool = this;
            this.addTab(dataToolTab);
            return dataToolTab;
        }
        return this.loadData(null, xMLControl, this.useChooser);
    }

    public DataToolTab addTab(Data data) {
        String string = "";
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        return this.addTab(data, string);
    }

    public DataToolTab addTab(Data data, String string) {
        DataToolTab dataToolTab = new DataToolTab(data, this);
        dataToolTab.setName(string);
        this.addTab(dataToolTab);
        return dataToolTab;
    }

    public DataToolTab removeTab(Data data) {
        DataToolTab dataToolTab = this.getTab(data);
        if (dataToolTab != null) {
            this.removeTab(this.getTabIndex(data));
            return dataToolTab;
        }
        return null;
    }

    public void removeTab(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            this.refreshTabTitles();
            this.refreshMenubar();
        }
    }

    public void update(Data data) {
        DataToolTab dataToolTab = this.getTab(data);
        if (dataToolTab != null) {
            dataToolTab.reloadData(data);
        }
    }

    public DataToolTab getTab(Data data) {
        int n = this.getTabIndex(data);
        return n > -1 ? (DataToolTab)this.tabbedPane.getComponentAt(n) : null;
    }

    public DataToolTab getTab(int n) {
        return n > -1 && n < this.tabbedPane.getTabCount() ? (DataToolTab)this.tabbedPane.getComponentAt(n) : null;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public String open(String string) {
        OSPLog.fine("opening " + string);
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            DatasetManager datasetManager;
            BufferedReader bufferedReader = resource.openReader();
            String string2 = this.readFirstLine(bufferedReader);
            if (string2.startsWith("<?xml")) {
                XMLControlElement xMLControlElement = new XMLControlElement(string);
                if (this.addTab(xMLControlElement) != null) {
                    this.refreshFunctionTool();
                    return string;
                }
            } else if (resource.getString() != null && (datasetManager = this.importCharDelimitedData(resource.getString(), string)) != null && this.addTab(datasetManager) != null) {
                this.refreshFunctionTool();
                return string;
            }
        }
        OSPLog.finest("no data found");
        return null;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, tool);
        if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            Data data = (Data)xMLControlElement.loadObject(null, true, true);
            DataToolTab dataToolTab = this.getTab(data);
            this.loadData(data, dataToolTab);
            this.refreshTabTitles();
        } else {
            this.addTab(xMLControlElement);
        }
    }

    public void setUseChooser(boolean bl) {
        this.useChooser = bl;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DataToolTab dataToolTab;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function") && (dataToolTab = this.getSelectedTab()) != null) {
            String string2;
            dataToolTab.dataTable.refreshTable();
            dataToolTab.statsTable.refreshStatistics();
            dataToolTab.statsTable.refreshTable();
            if (propertyChangeEvent.getNewValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getNewValue().toString();
                dataToolTab.dataTable.getWorkingData(string2);
            }
            if (propertyChangeEvent.getOldValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getOldValue().toString();
                dataToolTab.dataTable.removeWorkingData(string2);
            }
            if (propertyChangeEvent.getNewValue() instanceof String && propertyChangeEvent.getOldValue() instanceof String) {
                string2 = propertyChangeEvent.getOldValue().toString();
                String string3 = dataToolTab.dataTable.getFormatPattern(string2);
                dataToolTab.dataTable.removeWorkingData(string2);
                String string4 = propertyChangeEvent.getNewValue().toString();
                dataToolTab.dataTable.getWorkingData(string4);
                dataToolTab.dataTable.setFormatPattern(string4, string3);
                if (dataToolTab.propsTable.styleDialog != null && dataToolTab.propsTable.styleDialog.isVisible() && dataToolTab.propsTable.styleDialog.getName().equals(string2)) {
                    dataToolTab.propsTable.styleDialog.setName(string4);
                    String string5 = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
                    dataToolTab.propsTable.styleDialog.setTitle(String.valueOf(string5) + " \"" + string4 + "\"");
                }
            }
            dataToolTab.refresh();
        }
    }

    public static String[] parseStrings(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = string;
        int n = string.indexOf(string2);
        if (n != -1) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            string = "";
        }
        while (string3.length() > 0) {
            arrayList.add(string3);
            n = string.indexOf(string2);
            if (n == -1) {
                string3 = string.trim();
                string = "";
                continue;
            }
            string3 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
        }
        return arrayList.toArray(new String[0]);
    }

    public static double[] parseDoubles(String string, String string2) {
        String[] stringArray = DataTool.parseStrings(string, string2);
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                dArray[n] = Double.parseDouble(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                dArray[n] = Double.NaN;
            }
            ++n;
        }
        return dArray;
    }

    public static String[][] parseStrings(String string, String string2, String string3) {
        String[] stringArray = DataTool.parseStrings(string, string2);
        String[][] stringArray2 = new String[stringArray.length][0];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = DataTool.parseStrings(stringArray[n], string3);
            ++n;
        }
        return stringArray2;
    }

    public static double[][] parseDoubles(String string, String string2, String string3) {
        String[][] stringArray = DataTool.parseStrings(string, string2, string3);
        double[][] dArray = new double[stringArray.length][0];
        int n = 0;
        while (n < stringArray.length) {
            double[] dArray2 = new double[stringArray[n].length];
            int n2 = 0;
            while (n2 < dArray2.length) {
                try {
                    dArray2[n2] = Double.parseDouble(stringArray[n][n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray2[n2] = Double.NaN;
                }
                ++n2;
            }
            dArray[n] = dArray2;
            ++n;
        }
        return dArray;
    }

    protected String readFirstLine(Reader reader) {
        String string;
        BufferedReader bufferedReader = null;
        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            string = bufferedReader.readLine();
            while (string == null || string.equals("")) {
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    protected DatasetManager importCharDelimitedData(String string, String string2) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String[] stringArray = new String[]{" ", "\t", ",", ";"};
        try {
            String string3 = bufferedReader.readLine();
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                ArrayList<double[]> arrayList = new ArrayList<double[]>();
                int n2 = Integer.MAX_VALUE;
                String[] stringArray2 = null;
                String string4 = null;
                int n3 = 0;
                while (string3 != null) {
                    ++n3;
                    object = DataTool.parseDoubles(string3, stringArray[n]);
                    if (!(((double[])object).length < 2 || Double.isNaN(object[0]) || arrayList.size() <= 0 && Double.isNaN(object[1]))) {
                        arrayList.add((double[])object);
                        n2 = Math.min(((double[])object).length, n2);
                    } else if (((double[])object).length >= 2 && stringArray2 == null) {
                        stringArray2 = DataTool.parseStrings(string3, stringArray[n]);
                    } else if (((double[])object).length == 1 && string4 == null && Double.isNaN(object[0])) {
                        string4 = DataTool.parseStrings(string3, stringArray[n])[0];
                    }
                    if (arrayList.isEmpty() && n3 > 5) break;
                    string3 = bufferedReader.readLine();
                }
                if (!arrayList.isEmpty() && n2 > 1) {
                    object = new double[n2][arrayList.size()];
                    int n4 = 0;
                    while (n4 < arrayList.size()) {
                        double[] dArray = (double[])arrayList.get(n4);
                        int n5 = 0;
                        while (n5 < n2) {
                            object[n5][n4] = dArray[n5];
                            ++n5;
                        }
                        ++n4;
                    }
                    DatasetManager datasetManager = new DatasetManager();
                    datasetManager.setName(string4 == null ? XML.getName(string2) : string4);
                    int n6 = 1;
                    while (n6 < n2) {
                        Dataset dataset = datasetManager.getDataset(n6 - 1);
                        if (stringArray2 != null) {
                            String string5 = stringArray2[0];
                            String string6 = stringArray2.length > n6 ? stringArray2[n6] : "?";
                            dataset.setXYColumnNames(string5, string6);
                        }
                        dataset.append((double[])object[0], (double[])object[n6]);
                        ++n6;
                    }
                    return datasetManager;
                }
                bufferedReader.close();
                bufferedReader = new BufferedReader(new StringReader(string));
                string3 = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        OSPLog.finest("no data found");
        return null;
    }

    protected String getUniqueName(String string) {
        Object object;
        if (string == null || string.equals("")) {
            string = ToolsRes.getString("DataToolTab.DefaultName");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.getTabCount()) {
            object = this.getTab(n);
            arrayList.add(((Component)object).getName());
            ++n;
        }
        if (!arrayList.contains(string)) {
            return string;
        }
        n = string.lastIndexOf("_");
        if (n > -1) {
            object = string.substring(n + 1);
            try {
                Integer.parseInt((String)object);
                string = string.substring(0, n);
            }
            catch (Exception exception) {}
        }
        string = String.valueOf(string) + "_";
        int n2 = 1;
        String string2 = String.valueOf(string) + n2;
        while (arrayList.contains(string2)) {
            string2 = String.valueOf(string) + ++n2;
        }
        return string2;
    }

    protected DataToolTab loadData(DataToolTab dataToolTab, XMLControl xMLControl, boolean bl) {
        List list;
        Iterator iterator;
        if (bl) {
            iterator = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), this);
            list = ((XMLTreeChooser)((Object)iterator)).choose(xMLControl, Data.class);
        } else {
            iterator = new XMLTree(xMLControl);
            ((XMLTree)((Object)iterator)).setHighlightedClass(Data.class);
            ((XMLTree)((Object)iterator)).selectHighlightedProperties();
            list = ((XMLTree)((Object)iterator)).getSelectedProperties();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        if (!list.isEmpty()) {
            for (XMLControl xMLControl2 : list) {
                Data data = null;
                if (xMLControl2 instanceof XMLControlElement) {
                    XMLControlElement xMLControlElement = (XMLControlElement)xMLControl2;
                    data = (Data)xMLControlElement.loadObject(null, true, true);
                } else {
                    data = (Data)xMLControl2.loadObject(null);
                }
                if (data == null) continue;
                dataToolTab = this.loadData(data, dataToolTab);
            }
        }
        return dataToolTab;
    }

    protected DataToolTab loadData(Data data, DataToolTab dataToolTab) {
        String string = "";
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        if (dataToolTab == null) {
            dataToolTab = this.addTab(data, string);
        } else {
            dataToolTab.reloadData(data);
        }
        return dataToolTab;
    }

    protected void addTab(final DataToolTab dataToolTab) {
        dataToolTab.setName(this.getUniqueName(dataToolTab.getName()));
        dataToolTab.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (dataToolTab.fitCheckbox != null && !dataToolTab.fitCheckbox.isSelected()) {
                    dataToolTab.splitPanes[1].setDividerLocation(1.0);
                }
            }
        });
        OSPLog.finer("adding tab " + dataToolTab.getName());
        this.tabbedPane.addTab("", dataToolTab);
        this.tabbedPane.setSelectedComponent(dataToolTab);
        this.validate();
        dataToolTab.init();
        dataToolTab.refresh();
        this.refreshTabTitles();
        this.refreshMenubar();
    }

    protected DataToolTab getSelectedTab() {
        return (DataToolTab)this.tabbedPane.getSelectedComponent();
    }

    protected void setSelectedTab(DataToolTab dataToolTab) {
        this.tabbedPane.setSelectedComponent(dataToolTab);
    }

    protected String open() {
        int n = OSPRuntime.getChooser().showOpenDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.open(string);
        }
        return null;
    }

    public String write(String string) {
        String string2 = this.getSelectedTab().getName();
        OSPRuntime.getChooser().setSelectedFile(new File(String.valueOf(string2) + ".txt"));
        int n = OSPRuntime.getChooser().showSaveDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string3 = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string3 = XML.getRelativePath(string3);
            return this.write(string, string3);
        }
        return null;
    }

    public String write(String string, String string2) {
        Object object;
        block7: {
            block8: {
                File file;
                int n = string2.lastIndexOf("/");
                if (n < 0) {
                    n = string2.lastIndexOf("\\");
                }
                if (n > 0 && !(file = new File((String)(object = string2.substring(0, n + 1)))).exists() && !file.mkdir()) {
                    return null;
                }
                object = new File(string2);
                if (!((File)object).exists()) break block7;
                if (((File)object).canWrite()) break block8;
                JOptionPane.showMessageDialog(null, "File is read-only.");
                return null;
            }
            int n = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + ((File)object).getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1);
            if (n == 0) break block7;
            return null;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            Charset charset = Charset.forName("UTF-8");
            this.write(string, new OutputStreamWriter((OutputStream)fileOutputStream, charset));
            if (((File)object).exists()) {
                return ((File)object).getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void write(String string, Writer writer) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected String save(String string) {
        DataToolTab dataToolTab = this.getSelectedTab();
        if (string == null || string.equals("")) {
            return this.saveAs();
        }
        XMLControlElement xMLControlElement = new XMLControlElement(dataToolTab);
        if (xMLControlElement.write(string) == null) {
            return null;
        }
        dataToolTab.fileName = string;
        return string;
    }

    protected String saveAs() {
        int n = OSPRuntime.getChooser().showSaveDialog(this);
        if (n == 0) {
            int n2;
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            File file = OSPRuntime.getChooser().getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String string = file.getAbsolutePath();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            return this.save(XML.getRelativePath(string));
        }
        return null;
    }

    protected int getTabIndex(Data data) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n);
            if (dataToolTab.isOwnedBy(data)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected DataTool(String string, String string2) {
        super(string);
        this.setName(string2);
        this.createGUI();
        Toolbox.addTool(string2, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataTool.this.refreshGUI();
            }
        });
    }

    protected void removeAllButTab(int n) {
        int n2 = this.tabbedPane.getTabCount() - 1;
        while (n2 >= 0) {
            if (n2 != n) {
                String string = this.tabbedPane.getTitleAt(n2);
                OSPLog.finer("removing tab " + string);
                this.tabbedPane.removeTabAt(n2);
            }
            --n2;
        }
        this.refreshTabTitles();
    }

    protected void removeAllTabs() {
        int n = this.tabbedPane.getTabCount() - 1;
        while (n >= 0) {
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            --n;
        }
        this.refreshMenubar();
    }

    protected void refreshTabTitles() {
        String[] stringArray = new String[this.tabbedPane.getTabCount()];
        int n = 0;
        while (n < stringArray.length) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n);
            String string = dataToolTab.getName();
            DataToolTable.WorkingDataset workingDataset = dataToolTab.getWorkingData();
            String string2 = GUIUtils.removeSubscripting(workingDataset.getColumnName(0));
            String string3 = GUIUtils.removeSubscripting(workingDataset.getColumnName(1));
            String string4 = " (" + string2 + ", " + string3 + ")";
            stringArray[n] = String.valueOf(string) + string4;
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            this.tabbedPane.setTitleAt(n, stringArray[n]);
            ++n;
        }
    }

    protected void refreshMenubar() {
        if (this.getTabCount() == 0) {
            this.emptyMenubar.add(this.helpMenu);
            this.setJMenuBar(this.emptyMenubar);
        } else {
            this.menubar.add(this.helpMenu);
            this.setJMenuBar(this.menubar);
        }
    }

    protected FunctionTool getDataFunctionTool() {
        if (this.dataFunctionTool == null) {
            this.dataFunctionTool = new FunctionTool((Component)this);
            this.dataFunctionTool.setHelpPath("data_builder_help.html");
            this.dataFunctionTool.addPropertyChangeListener("function", this);
            this.dataFunctionTool.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
        }
        this.refreshFunctionTool();
        return this.dataFunctionTool;
    }

    protected void refreshFunctionTool() {
        Object object;
        Iterator iterator;
        if (this.dataFunctionTool == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            iterator = this.getTab(n);
            arrayList.add(((Component)((Object)iterator)).getName());
            if (this.dataFunctionTool.getPanel(((Component)((Object)iterator)).getName()) == null) {
                object = new DataFunctionPanel(((DataToolTab)((Object)iterator)).dataManager);
                this.dataFunctionTool.addPanel(((Component)((Object)iterator)).getName(), (FunctionPanel)object);
            }
            ++n;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        iterator = this.dataFunctionTool.panels.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().toString();
            if (arrayList.contains(object)) continue;
            arrayList2.add(object);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next().toString();
            this.dataFunctionTool.removePanel((String)object);
        }
    }

    protected StringBuffer getSelectedTableData(String string, DataTable dataTable) {
        int n;
        int[] nArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(String.valueOf(string) + "\n");
        }
        if ((nArray = dataTable.getSelectedRows()).length == 0) {
            dataTable.selectAll();
            nArray = dataTable.getSelectedRows();
        }
        int n2 = 0;
        while (n2 < dataTable.getColumnCount()) {
            n = dataTable.convertColumnIndexToModel(n2);
            if (!dataTable.isRowNumberVisible() || n != 0) {
                stringBuffer.append(dataTable.getColumnName(n2));
                if (n2 < dataTable.getColumnCount() - 1) {
                    stringBuffer.append("\t");
                }
            }
            ++n2;
        }
        stringBuffer.append("\n");
        DateFormat dateFormat = DateFormat.getInstance();
        n = 0;
        while (n < nArray.length) {
            int n3 = 0;
            while (n3 < dataTable.getColumnCount()) {
                int n4 = dataTable.convertColumnIndexToModel(n3);
                if (!dataTable.isRowNumberVisible() || n4 != 0) {
                    Object object = dataTable.getValueAt(nArray[n], n3);
                    if (object != null) {
                        if (object instanceof Date) {
                            object = dateFormat.format(object);
                        }
                        stringBuffer.append(object);
                    }
                    if (n3 < dataTable.getColumnCount() - 1) {
                        stringBuffer.append("\t");
                    }
                }
                ++n3;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer;
    }

    protected void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)jPanel, "Center");
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab == null) {
                    return;
                }
                if (!dataToolTab.propsCheckbox.isSelected() && !dataToolTab.statsCheckbox.isSelected()) {
                    dataToolTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        jPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab != null) {
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.statsTable.refreshStatistics();
                    dataToolTab.statsTable.refreshTable();
                    dataToolTab.refresh();
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    final int n = DataTool.this.tabbedPane.getSelectedIndex();
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Name"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataToolTab dataToolTab = DataTool.this.getTab(n);
                            String string = dataToolTab.getName();
                            Object object = JOptionPane.showInputDialog(DataTool.this, ToolsRes.getString("DataTool.Dialog.Name.Message"), ToolsRes.getString("DataTool.Dialog.Name.Title"), 3, null, null, string);
                            if (object == null) {
                                return;
                            }
                            dataToolTab.setName("");
                            dataToolTab.setName(DataTool.this.getUniqueName(object.toString()));
                            DataTool.this.refreshTabTitles();
                            DataTool.this.refreshFunctionTool();
                        }
                    });
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeAllButTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeAllTabs();
                        }
                    });
                    jPopupMenu.show(DataTool.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.menubar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.open();
            }
        });
        this.fileMenu.add(this.openItem);
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataTool.this.tabbedPane.getSelectedIndex();
                DataTool.this.removeTab(n);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        this.exportItem = new JMenuItem();
        this.exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DataTool.this.getSelectedTab().getName();
                String string2 = DataTool.this.getSelectedTableData(string, DataTool.this.getSelectedTab().dataTable).toString();
                DataTool.this.write(string2);
            }
        });
        this.fileMenu.add(this.exportItem);
        this.fileMenu.addSeparator();
        this.saveItem = new JMenuItem();
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                DataTool.this.save(dataToolTab.fileName);
            }
        });
        this.fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem();
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.saveAs();
            }
        });
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.addSeparator();
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().printImage(DataTool.this);
            }
        });
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.removeAllTabs();
                System.exit(0);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!DataTool.this.editMenu.isPopupMenuVisible() && !DataTool.this.emptyEditMenu.isPopupMenuVisible()) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                boolean bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
                DataTool.this.emptyPasteItem.setEnabled(bl);
                DataTool.this.pasteMenu.setEnabled(bl);
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab != null) {
                    DataToolTable.WorkingDataset workingDataset = dataToolTab.getWorkingData();
                    String string = GUIUtils.removeSubscripting(workingDataset.getColumnName(0));
                    String string2 = GUIUtils.removeSubscripting(workingDataset.getColumnName(1));
                    String string3 = " (" + string + ", " + string2 + ")";
                    DataTool.this.copyDatasetItem.setText(String.valueOf(ToolsRes.getString("DataTool.MenuItem.CopyDatasets")) + string3);
                    string3 = " \"" + dataToolTab.getName() + "\"";
                    DataTool.this.copyTabItem.setText(String.valueOf(ToolsRes.getString("DataTool.MenuItem.CopyTab")) + string3);
                    string3 = ToolsRes.getString("DataTool.MenuItem.CopyData");
                    if (DataTool.this.getSelectedTab().dataTable.getSelectedRows().length > 0) {
                        string3 = ToolsRes.getString("DataTool.MenuItem.CopySelectedData");
                    }
                    DataTool.this.copyDataRowsItem.setText(string3);
                }
            }
        };
        this.editMenu.addMouseListener(mouseAdapter);
        this.menubar.add(this.editMenu);
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyTabItem = new JMenuItem();
        this.copyTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataTool.this.tabbedPane.getSelectedIndex();
                String string = DataTool.this.tabbedPane.getTitleAt(n);
                OSPLog.finest("copying tab " + string);
                XMLControlElement xMLControlElement = new XMLControlElement(DataTool.this.getSelectedTab());
                StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        this.copyMenu.add(this.copyTabItem);
        this.copyDatasetItem = new JMenuItem();
        this.copyDatasetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTable.WorkingDataset workingDataset = DataTool.this.getSelectedTab().getWorkingData();
                if (workingDataset == null) {
                    return;
                }
                DatasetManager datasetManager = new DatasetManager();
                Dataset dataset = workingDataset.getXSource();
                Dataset dataset2 = new Dataset();
                Dataset dataset3 = workingDataset.getYSource();
                Dataset dataset4 = new Dataset();
                dataset2.append(dataset.getYPoints(), dataset.getYPoints());
                dataset2.setMarkerColor(dataset.getEdgeColor());
                dataset2.setLineColor(dataset.getLineColor());
                dataset2.setMarkerSize(dataset.getMarkerSize());
                dataset2.setMarkerShape(dataset.getMarkerShape());
                dataset2.setConnected(dataset.isConnected());
                dataset2.setXYColumnNames(dataset.getYColumnName(), dataset.getYColumnName());
                dataset4.append(dataset.getYPoints(), dataset3.getYPoints());
                dataset4.setMarkerColor(dataset3.getEdgeColor());
                dataset4.setLineColor(dataset3.getLineColor());
                dataset4.setMarkerSize(dataset3.getMarkerSize());
                dataset4.setMarkerShape(dataset3.getMarkerShape());
                dataset4.setConnected(dataset3.isConnected());
                dataset4.setXYColumnNames(dataset.getYColumnName(), dataset3.getYColumnName());
                datasetManager.addDataset(dataset2);
                datasetManager.addDataset(dataset4);
                DataTool.this.control = new XMLControlElement(datasetManager);
                DataTool.this.control.setValue("data_tool_transfer", true);
                DataTool.this.control.setValue("data_tool_tab", DataTool.this.getSelectedTab().getName());
                StringSelection stringSelection = new StringSelection(DataTool.this.control.toXML());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        this.copyMenu.add(this.copyDatasetItem);
        this.copyDataRowsItem = new JMenuItem();
        this.copyDataRowsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DataTool.this.getSelectedTab().getName();
                String string2 = DataTool.this.getSelectedTableData(string, DataTool.this.getSelectedTab().dataTable).toString();
                StringSelection stringSelection = new StringSelection(string2);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        this.copyMenu.add(this.copyDataRowsItem);
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().copyImage(DataTool.this);
            }
        });
        this.copyImageItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        this.copyMenu.add(this.copyImageItem);
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!DataTool.this.pasteMenu.isEnabled() || DataTool.this.pasteMenu.isPopupMenuVisible()) {
                    return;
                }
                String string = "";
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    String string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string2 != null) {
                        if (!string2.startsWith("<?xml")) {
                            DataTool.this.addableData = DataTool.this.importCharDelimitedData(string2, null);
                        } else {
                            XMLControlElement xMLControlElement = new XMLControlElement();
                            xMLControlElement.readXML(string2);
                            if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
                                DataTool.this.addableData = (Data)xMLControlElement.loadObject(null);
                            }
                        }
                        if (DataTool.this.addableData != null) {
                            for (Dataset dataset : DataTool.this.addableData.getDatasets()) {
                                if (!dataToolTab.isDuplicateColumn(dataset.getXColumnName(), dataset.getXPoints()) || dataToolTab.isDuplicateColumn(dataset.getYColumnName(), dataset.getYPoints())) continue;
                                String string3 = dataToolTab.getUniqueYColumnName(dataset, dataset.getYColumnName(), false);
                                if (!string.equals("")) {
                                    string = String.valueOf(string) + ",";
                                }
                                string = String.valueOf(string) + " \"" + string3 + "\"";
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (string.equals("")) {
                    DataTool.this.addableData = null;
                }
                DataTool.this.pasteColumnsItem.setText(String.valueOf(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns")) + string);
                DataTool.this.pasteColumnsItem.setEnabled(DataTool.this.addableData != null);
            }
        };
        this.pasteMenu = new JMenu();
        this.pasteMenu.addMouseListener(mouseAdapter2);
        this.editMenu.add(this.pasteMenu);
        this.pasteNewTabItem = new JMenuItem();
        this.pasteNewTabItem.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string != null) {
                        Object object;
                        if (!string.startsWith("<?xml") && (object = DataTool.this.importCharDelimitedData(string, null)) != null && DataTool.this.addTab((Data)object) != null) {
                            OSPLog.finest("pasting imported data into new tab");
                            DataTool.this.refreshFunctionTool();
                            return;
                        }
                        object = new XMLControlElement();
                        object.readXML(string);
                        if (object.failedToRead()) {
                            return;
                        }
                        OSPLog.finest("pasting XML into new tab");
                        if (Dataset.class.isAssignableFrom(object.getObjectClass()) || object.getBoolean("data_tool_transfer")) {
                            if (DataTool.this.loadData(null, (XMLControl)object, false) != null) {
                                int n = DataTool.this.getTabCount() - 1;
                                DataTool.this.tabbedPane.setSelectedIndex(n);
                            }
                        } else if (DataTool.this.addTab((XMLControl)object) == null) {
                            OSPLog.finest("no data found");
                        }
                        DataTool.this.refreshFunctionTool();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.pasteMenu.add(this.pasteNewTabItem);
        this.pasteColumnsItem = new JMenuItem();
        this.pasteColumnsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataTool.this.addableData != null) {
                    DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                    for (Dataset dataset : DataTool.this.addableData.getDatasets()) {
                        if (!dataToolTab.addData(dataset)) continue;
                        OSPLog.finest("pasted column " + dataset.getYColumnName() + " into tab " + dataToolTab.getName());
                    }
                }
            }
        });
        this.pasteMenu.add(this.pasteColumnsItem);
        this.helpMenu = new JMenu();
        this.menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, n));
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataTool.this.helpFrame == null) {
                    Object object;
                    String string = XML.getResolvedPath(DataTool.this.helpPath, DataTool.this.helpBase);
                    if (ResourceLoader.getResource(string) != null) {
                        DataTool.this.helpFrame = new TextFrame(string);
                    } else {
                        object = "/org/opensourcephysics/resources/tools/html/";
                        string = XML.getResolvedPath(DataTool.this.helpPath, (String)object);
                        DataTool.this.helpFrame = new TextFrame(string);
                    }
                    DataTool.this.helpFrame.setSize(760, 560);
                    object = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (((Dimension)object).width - DataTool.this.helpFrame.getBounds().width) / 2;
                    int n2 = (((Dimension)object).height - DataTool.this.helpFrame.getBounds().height) / 2;
                    DataTool.this.helpFrame.setLocation(n, n2);
                }
                DataTool.this.helpFrame.setVisible(true);
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = OSPLog.showLog();
                if (jFrame != null & jFrame.getLocation().x == 0 && jFrame.getLocation().y == 0) {
                    Point point = DataTool.this.getLocation();
                    jFrame.setLocation(point.x + 28, point.y + 28);
                }
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(this.menubar);
        this.emptyMenubar = new JMenuBar();
        this.emptyFileMenu = new JMenu();
        this.emptyMenubar.add(this.emptyFileMenu);
        this.emptyOpenItem = new JMenuItem();
        this.emptyOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.emptyOpenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.open();
            }
        });
        this.emptyFileMenu.add(this.emptyOpenItem);
        this.emptyFileMenu.addSeparator();
        this.emptyExitItem = new JMenuItem();
        this.emptyExitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.emptyExitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.emptyFileMenu.add(this.emptyExitItem);
        this.emptyEditMenu = new JMenu();
        this.emptyEditMenu.addMouseListener(mouseAdapter);
        this.emptyMenubar.add(this.emptyEditMenu);
        this.emptyPasteItem = new JMenuItem();
        this.emptyPasteItem.addActionListener(this.pasteNewTabItem.getAction());
        this.emptyEditMenu.add(this.emptyPasteItem);
        this.helpLabel = new JLabel("", 10);
        this.helpLabel.setFont(new JTextField().getFont());
        this.helpLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        jPanel.add((Component)this.helpLabel, "South");
        this.refreshGUI();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension.width - this.getBounds().width) / 2;
        int n3 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n2, n3);
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("DataTool.Frame.Title"));
        this.emptyFileMenu.setText(ToolsRes.getString("Menu.File"));
        this.emptyOpenItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.emptyExitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.emptyEditMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.emptyPasteItem.setText(ToolsRes.getString("MenuItem.Paste"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.Export"));
        this.saveItem.setText(ToolsRes.getString("DataTool.MenuItem.Save"));
        this.saveAsItem.setText(ToolsRes.getString("DataTool.MenuItem.SaveAs"));
        this.printItem.setText(ToolsRes.getString("DataTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.copyMenu.setText(ToolsRes.getString("DataTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyImage"));
        this.pasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.pasteNewTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.pasteColumnsItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns"));
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.helpItem.setText(ToolsRes.getString("DataTool.MenuItem.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        this.helpLabel.setText(ToolsRes.getString("DataTool.StatusBar.Help.DragColumns"));
        int n = this.tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n2);
            dataToolTab.refreshGUI();
            ++n2;
        }
    }

    protected void showAboutDialog() {
        String string = String.valueOf(this.getName()) + " 1.3  July 2008\n" + "Douglas Brown, Author\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, string, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + " " + this.getName(), 1);
    }

    protected static JButton createButton(String string) {
        JButton jButton = new JButton(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = buttonHeight;
                return dimension;
            }
        };
        return jButton;
    }
}

