/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolTable
extends DataTable {
    protected static Color xAxisColor = new Color(255, 255, 153);
    protected static Color yAxisColor = new Color(204, 255, 204);
    DataToolTab dataToolTab;
    DatasetManager dataManager;
    WorkingDataset workingData;
    HighlightableDataset selectedData = new HighlightableDataset();
    HeaderRenderer sortRenderer;
    LabelRenderer labelRenderer = new LabelRenderer();
    int[] selectedModelRows = new int[0];
    boolean ignoreRefresh = false;
    HashMap workingMap = new HashMap();

    public DataToolTable(DataToolTab dataToolTab) {
        this.dataToolTab = dataToolTab;
        this.dataManager = dataToolTab.dataManager;
        this.add(this.dataManager);
        this.setRowNumberVisible(true);
        this.setSelectionMode(2);
        this.sortRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(this.sortRenderer);
        this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Tooltip"));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = DataToolTable.this.getColumnModel();
                final int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    int n2;
                    int n3 = DataToolTable.this.convertColumnIndexToView(0);
                    int n4 = n2 = n3 < 2 ? 2 : 1;
                    if (n == n3 || n <= n2) {
                        return;
                    }
                    String string = ToolsRes.getString("DataToolTable.Popup.MenuItem.DeleteColumn");
                    String string2 = DataToolTable.this.getColumnName(n);
                    string = String.valueOf(string) + " \"" + string2 + "\"";
                    JMenuItem jMenuItem = new JMenuItem(string);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = DataToolTable.this.getColumnName(n);
                            Dataset dataset = DataToolTable.this.getDataset(string);
                            if (dataset == null) {
                                return;
                            }
                            int n2 = (this).DataToolTable.this.dataManager.getDatasetIndex(dataset.getYColumnName());
                            if (dataset instanceof DataFunction) {
                                FunctionTool functionTool = (this).DataToolTable.this.dataToolTab.dataTool.getDataFunctionTool();
                                FunctionPanel functionPanel = functionTool.getPanel((this).DataToolTable.this.dataToolTab.getName());
                                functionPanel.functionEditor.removeObject(dataset, true);
                            } else {
                                (this).DataToolTable.this.dataManager.removeDataset(n2);
                                (this).DataToolTable.this.workingMap.remove(string);
                            }
                            DataToolTable.this.refreshTable();
                        }
                    });
                    jPopupMenu.show(DataToolTable.this.getTableHeader(), mouseEvent.getX(), mouseEvent.getY() + 8);
                } else {
                    DataToolTable.this.sortRenderer.sortedColumn = DataToolTable.this.convertColumnIndexToModel(n);
                    DataToolTable.this.ignoreRefresh = true;
                    DataToolTable.this.clearSelection();
                    int n5 = 0;
                    while (n5 < DataToolTable.this.selectedModelRows.length) {
                        int n6 = 0;
                        while (n6 < DataToolTable.this.getRowCount()) {
                            Integer n7 = (Integer)DataToolTable.this.getModel().getValueAt(n6, 0);
                            if (n7 == DataToolTable.this.selectedModelRows[n5]) {
                                DataToolTable.this.addRowSelectionInterval(n6, n6);
                                break;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    DataToolTable.this.ignoreRefresh = false;
                    DataToolTable.this.getSelectedData();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DataToolTable.this.ignoreRefresh) {
                    return;
                }
                int[] nArray = DataToolTable.this.getSelectedRows();
                DataToolTable.this.selectedModelRows = new int[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    int n2 = nArray[n];
                    Integer n3 = (Integer)DataToolTable.this.getModel().getValueAt(n2, 0);
                    DataToolTable.this.selectedModelRows[n] = n3;
                    ++n;
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DataToolTable.this.convertColumnIndexToModel(DataToolTable.this.getSelectedColumn()) == 0) {
                    DataToolTable.this.removeRowSelectionInterval(0, DataToolTable.this.getRowCount() - 1);
                    DataToolTable.this.selectedData.clearHighlights();
                }
            }
        });
    }

    protected WorkingDataset getWorkingData(String string) {
        int n;
        String string2;
        Dataset dataset;
        if (string == null) {
            return null;
        }
        WorkingDataset workingDataset = (WorkingDataset)this.workingMap.get(string);
        if (workingDataset == null) {
            Dataset dataset2 = this.getDataset(string);
            if (dataset2 == null) {
                return null;
            }
            workingDataset = new WorkingDataset(dataset2);
            this.workingMap.put(string, workingDataset);
        }
        if ((dataset = this.getDataset(string2 = this.getColumnName((n = this.convertColumnIndexToView(0)) == 0 ? 1 : 0))) == null) {
            return null;
        }
        workingDataset.setXSource(dataset);
        return workingDataset;
    }

    protected WorkingDataset getWorkingData() {
        int n = this.convertColumnIndexToView(0);
        int n2 = n < 2 ? 2 : 1;
        String string = this.getColumnName(n2);
        this.workingData = this.getWorkingData(string);
        return this.workingData;
    }

    protected void removeWorkingData(String string) {
        if (string == null) {
            return;
        }
        this.workingMap.remove(string);
        this.setFormatPattern(string, null);
        this.refreshTable();
    }

    protected Dataset getDataset(String string) {
        int n = this.dataManager.getDatasetIndex(string);
        if (n > -1) {
            return this.dataManager.getDataset(n);
        }
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (!GUIUtils.removeSubscripting(dataset.getYColumnName()).equals(string)) continue;
            return dataset;
        }
        return null;
    }

    protected HighlightableDataset getSelectedData() {
        double[] dArray;
        double[] dArray2;
        if (this.getWorkingData() == null) {
            return null;
        }
        double[] dArray3 = this.workingData.getXPoints();
        double[] dArray4 = this.workingData.getYPoints();
        this.workingData.clearHighlights();
        if (this.getSelectedRowCount() == 0) {
            dArray2 = dArray3;
            dArray = dArray4;
        } else {
            int[] nArray = this.selectedModelRows;
            dArray2 = new double[nArray.length];
            dArray = new double[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] >= dArray3.length) {
                    dArray2[n] = Double.NaN;
                } else {
                    dArray2[n] = dArray3[nArray[n]];
                    dArray[n] = dArray4[nArray[n]];
                    this.workingData.setHighlighted(nArray[n], true);
                }
                ++n;
            }
        }
        this.selectedData.clear();
        this.selectedData.append(dArray2, dArray);
        this.selectedData.setXYColumnNames(this.workingData.getColumnName(0), this.workingData.getColumnName(1));
        this.selectedData.setMarkerShape(this.workingData.getMarkerShape());
        this.selectedData.setMarkerSize(this.workingData.getMarkerSize());
        this.selectedData.setConnected(this.workingData.isConnected());
        this.selectedData.setLineColor(this.workingData.getLineColor());
        this.selectedData.setName(this.workingData.getName());
        this.selectedData.setMarkerColor(this.workingData.getFillColor(), this.workingData.getEdgeColor());
        return this.selectedData;
    }

    public void clearSelection() {
        if (this.workingData != null) {
            this.workingData.clearHighlights();
            this.selectedData.clearHighlights();
        }
        super.clearSelection();
    }

    public void refreshTable() {
        TableModel tableModel = this.getModel();
        boolean bl = this.convertColumnIndexToView(0) == -1;
        int[] nArray = new int[tableModel.getColumnCount()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.convertColumnIndexToModel(n);
            ++n;
        }
        int[] nArray2 = this.getSelectedRows();
        super.refreshTable();
        if (bl) {
            return;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2;
            while (n3 < nArray.length) {
                if (this.convertColumnIndexToModel(n3) == nArray[n2]) {
                    this.moveColumn(n3, n2);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray2.length) {
            this.addRowSelectionInterval(nArray2[n2], nArray2[n2]);
            ++n2;
        }
    }

    public void setWorkingColumns(String string, String string2) {
        int n = this.convertColumnIndexToView(0);
        this.getColumnModel().moveColumn(n, 0);
        string = GUIUtils.removeSubscripting(string);
        string2 = GUIUtils.removeSubscripting(string2);
        int n2 = 1;
        while (n2 < this.getColumnCount()) {
            if (string.equals(this.getColumnName(n2))) {
                this.getColumnModel().moveColumn(n2, 1);
                break;
            }
            ++n2;
        }
        n2 = 2;
        while (n2 < this.getColumnCount()) {
            if (string2.equals(this.getColumnName(n2))) {
                this.getColumnModel().moveColumn(n2, 2);
                break;
            }
            ++n2;
        }
    }

    protected void setLabelColumnWidth(int n) {
        this.labelColumnWidth = n;
    }

    class HeaderRenderer
    implements TableCellRenderer {
        int sortedColumn;
        TableCellRenderer renderer;

        public HeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                int n3;
                JLabel jLabel = (JLabel)component;
                int n4 = DataToolTable.this.convertColumnIndexToView(0);
                int n5 = n4 == 0 ? 1 : 0;
                int n6 = n3 = n4 < 2 ? 2 : 1;
                if (n2 == n5) {
                    jLabel.setBackground(xAxisColor);
                } else if (n2 == n3) {
                    jLabel.setBackground(yAxisColor);
                }
                n2 = DataToolTable.this.convertColumnIndexToModel(n2);
                if (n2 == this.sortedColumn) {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                }
            }
            return component;
        }
    }

    class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.setForeground(Color.black);
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            return this;
        }
    }

    class WorkingDataset
    extends HighlightableDataset {
        private Dataset yData;
        private Dataset xData;
        boolean markersVisible;
        int markerType;

        public WorkingDataset(Dataset dataset) {
            this.yData = dataset;
            this.setColor(this.yData.getFillColor(), this.yData.getLineColor());
            this.markerType = this.yData.getMarkerShape();
            this.setMarkerShape(this.markerType);
            boolean bl = this.markersVisible = this.markerType != 0;
            if (this.markerType == 0) {
                this.markerType = 1;
            }
            this.setMarkerSize(this.yData.getMarkerSize());
            this.setConnected(this.yData.isConnected());
        }

        public boolean isMarkersVisible() {
            return this.markersVisible;
        }

        public void setMarkersVisible(boolean bl) {
            if (!bl && this.markersVisible) {
                this.markerType = this.getMarkerShape();
                this.setMarkerShape(0);
            } else if (bl) {
                this.setMarkerShape(this.markerType);
            }
            this.markersVisible = bl;
        }

        public void setColor(Color color, Color color2) {
            Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
            this.setMarkerColor(color3, color);
            this.setLineColor(color2);
            this.yData.setMarkerColor(color3, color);
            this.yData.setLineColor(color2);
        }

        public void setConnected(boolean bl) {
            super.setConnected(bl);
            this.yData.setConnected(bl);
        }

        public void setMarkerSize(int n) {
            super.setMarkerSize(n);
            this.yData.setMarkerSize(n);
        }

        public void setMarkerShape(int n) {
            super.setMarkerShape(n);
            if (n != 0) {
                this.yData.setMarkerShape(n);
                this.markerType = n;
            }
        }

        Dataset getYSource() {
            return this.yData;
        }

        Dataset getXSource() {
            return this.xData;
        }

        void setXSource(Dataset dataset) {
            this.xData = dataset;
            this.clear();
            double[] dArray = this.xData.getYPoints();
            double[] dArray2 = this.yData.getYPoints();
            if (dArray.length != dArray2.length) {
                int n = Math.min(dArray.length, dArray2.length);
                double[] dArray3 = new double[n];
                System.arraycopy(dArray, 0, dArray3, 0, n);
                double[] dArray4 = new double[n];
                System.arraycopy(dArray2, 0, dArray4, 0, n);
                this.append(dArray3, dArray4);
            } else {
                this.append(dArray, dArray2);
            }
            this.setXYColumnNames(this.xData.getYColumnName(), this.yData.getYColumnName());
        }
    }
}

