/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LevenbergMarquardt;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DatasetCurveFitter
extends JPanel {
    FunctionTool fitBuilder;
    Dataset dataset;
    KnownFunction fit;
    HessianMinimize hessian = new HessianMinimize();
    LevenbergMarquardt levmar = new LevenbergMarquardt();
    FunctionDrawer drawer;
    Color color = Color.MAGENTA;
    JButton colorButton;
    JButton closeButton;
    JCheckBox autofitCheckBox;
    String[] fitNames;
    JLabel fitLabel;
    JLabel eqnLabel;
    JLabel rmsLabel;
    JComboBox fitDropDown;
    JTextField eqnField;
    NumberField rmsField;
    ParamTableModel paramModel;
    JTable paramTable;
    TableCellRenderer cellRenderer;
    SpinCellEditor spinCellEditor;
    Map namedFits = new HashMap();
    int fitNumber = 1;
    JButton fitBuilderButton;
    JButton newFitButton;
    JButton deleteFitButton;
    boolean refreshing = false;
    JSplitPane splitPane;
    JDialog colorDialog;

    public DatasetCurveFitter(Dataset dataset) {
        this.dataset = dataset;
        this.createGUI();
        this.fit(this.fit);
    }

    public Drawable getDrawer() {
        return this.drawer;
    }

    public Dataset getData() {
        return this.dataset;
    }

    public void setData(Dataset dataset) {
        this.dataset = dataset;
        this.fit(this.fit);
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.drawer != null) {
            boolean bl;
            this.drawer.setColor(color);
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            boolean bl2 = bl = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1;
            if (bl) {
                this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
            } else {
                this.colorButton.setBackground(this.color);
            }
        }
    }

    public void fit(Function function) {
        if (this.drawer == null) {
            this.selectFit((String)this.fitDropDown.getSelectedItem());
        }
        if (function == null || this.dataset == null) {
            return;
        }
        double[] dArray = this.dataset.getValidXPoints();
        double[] dArray2 = this.dataset.getValidYPoints();
        double d = 0.0;
        double[] dArray3 = null;
        double d2 = this.getDevSquared(function, dArray, dArray2);
        if (this.autofitCheckBox.isSelected()) {
            UserFunction userFunction;
            double[] dArray4;
            if (function instanceof KnownPolynomial) {
                KnownPolynomial knownPolynomial = (KnownPolynomial)function;
                knownPolynomial.fitData(dArray, dArray2);
            } else if (function instanceof UserFunction && (dArray4 = new double[(userFunction = (UserFunction)function).getParameterCount()]).length > 0) {
                int n;
                MinimizeUserFunction minimizeUserFunction = new MinimizeUserFunction(userFunction, dArray, dArray2);
                dArray3 = new double[dArray4.length];
                int n2 = 0;
                while (n2 < dArray4.length) {
                    dArray4[n2] = dArray3[n2] = userFunction.getParameterValue(n2);
                    ++n2;
                }
                double d3 = 1.0E-6;
                int n3 = 20;
                this.hessian.minimize(minimizeUserFunction, dArray4, n3, d3);
                d = this.getDevSquared(function, dArray, dArray2);
                if (d > d2) {
                    n = 0;
                    while (n < dArray3.length) {
                        userFunction.setParameterValue(n, dArray3[n]);
                        ++n;
                    }
                    this.levmar.minimize(minimizeUserFunction, dArray4, n3, d3);
                    d = this.getDevSquared(function, dArray, dArray2);
                }
                if (d > d2) {
                    n = 0;
                    while (n < dArray3.length) {
                        userFunction.setParameterValue(n, dArray3[n]);
                        ++n;
                    }
                    d = d2;
                    this.autofitCheckBox.setSelected(false);
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            this.drawer.functionChanged = true;
            this.paramTable.repaint();
        }
        if (d == 0.0) {
            d = this.getDevSquared(function, dArray, dArray2);
        }
        this.rmsField.setValue(Math.sqrt(d / (double)dArray.length));
        this.firePropertyChange("fit", null, null);
    }

    public void addUserFit(FitFunctionPanel fitFunctionPanel) {
        String string = fitFunctionPanel.getName();
        UserFunction userFunction = fitFunctionPanel.getFitFunction();
        this.namedFits.put(string, userFunction);
        this.fitDropDown.insertItemAt(string, 0);
        this.getFitBuilder().addPanel(string, fitFunctionPanel);
        this.fitBuilder.setSelectedPanel(string);
        this.fitDropDown.setSelectedItem(string);
    }

    public String getSelectedFitName() {
        Iterator iterator = this.namedFits.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (this.namedFits.get(string) != this.fit) continue;
            return string;
        }
        return null;
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerSize(4);
        this.autofitCheckBox = new JCheckBox("", true);
        this.autofitCheckBox.setSelected(false);
        this.autofitCheckBox.setOpaque(false);
        this.autofitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetCurveFitter.this.spinCellEditor.stopCellEditing();
                DatasetCurveFitter.this.paramTable.clearSelection();
                DatasetCurveFitter.this.fit(DatasetCurveFitter.this.fit);
            }
        });
        this.fitNames = new String[]{ToolsRes.getString("Function.Poly1.Name"), ToolsRes.getString("Function.Poly2.Name"), ToolsRes.getString("Function.Poly3.Name")};
        this.fitLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.FitName"));
        this.fitLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.eqnLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.Equation"));
        this.eqnLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.rmsLabel = new JLabel();
        this.rmsLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.fitDropDown = new JComboBox(this.fitNames){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = DataTool.buttonHeight - 2;
                return dimension;
            }
        };
        this.fitDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetCurveFitter.this.selectFit((String)DatasetCurveFitter.this.fitDropDown.getSelectedItem());
            }
        });
        this.eqnField = new JTextField(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = DataTool.buttonHeight - 2;
                return dimension;
            }
        };
        this.eqnField.setEditable(false);
        this.eqnField.setEnabled(true);
        this.eqnField.setBackground(Color.white);
        this.colorButton = DataTool.createButton("");
        this.colorButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Color.Tooltip"));
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = DatasetCurveFitter.this.getColorDialog();
                DatasetCurveFitter.this.closeButton.setText(ToolsRes.getString("Button.OK"));
                jDialog.setTitle(ToolsRes.getString("DatasetCurveFitter.Dialog.Color.Title"));
                jDialog.setVisible(true);
            }
        });
        this.rmsField = new NumberField(6){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = DataTool.buttonHeight - 2;
                return dimension;
            }
        };
        this.rmsField.setEditable(false);
        this.rmsField.setEnabled(true);
        this.rmsField.setBackground(Color.white);
        this.cellRenderer = new ParamCellRenderer();
        this.spinCellEditor = new SpinCellEditor();
        this.paramModel = new ParamTableModel();
        this.paramTable = new ParamTable(this.paramModel);
        this.paramTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DatasetCurveFitter.this.paramTable.getSelectedColumn() == 0) {
                    DatasetCurveFitter.this.paramTable.clearSelection();
                }
            }
        });
        this.splitPane.setRightComponent(new JScrollPane(this.paramTable));
        this.add((Component)this.splitPane, "Center");
        this.fitBuilderButton = DataTool.createButton(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                if (DatasetCurveFitter.this.fitBuilder == null) {
                    DatasetCurveFitter.this.fitBuilder = DatasetCurveFitter.this.getFitBuilder();
                    DatasetCurveFitter.this.fitBuilder.setTitle(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Title"));
                    DatasetCurveFitter.this.fitBuilder.customButtons[0].doClick();
                } else if (DatasetCurveFitter.this.fit instanceof UserFunction) {
                    DatasetCurveFitter.this.fitBuilder.setSelectedPanel(DatasetCurveFitter.this.getFitName());
                } else if (DatasetCurveFitter.this.fitBuilder.getSelectedName() != null) {
                    DatasetCurveFitter.this.fitDropDown.setSelectedItem(DatasetCurveFitter.this.fitBuilder.getSelectedName());
                } else {
                    DatasetCurveFitter.this.fitBuilder.customButtons[0].doClick();
                }
                DatasetCurveFitter.this.fitBuilder.setVisible(true);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        this.splitPane.setLeftComponent(jPanel);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorder(BorderFactory.createEtchedBorder());
        jToolBar.add(this.fitLabel);
        jToolBar.add(this.fitDropDown);
        jToolBar.addSeparator();
        jToolBar.add(this.fitBuilderButton);
        jPanel.add((Component)jToolBar, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.setBorder(BorderFactory.createEtchedBorder());
        jToolBar2.add(this.eqnLabel);
        jToolBar2.add(this.eqnField);
        jToolBar2.add(this.colorButton);
        jPanel2.add((Component)jToolBar2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, "Center");
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setFloatable(false);
        jToolBar3.setBorder(BorderFactory.createEtchedBorder());
        jToolBar3.add(this.autofitCheckBox);
        jToolBar3.addSeparator();
        jToolBar3.add(this.rmsLabel);
        jToolBar3.add(this.rmsField);
        jPanel3.add((Component)jToolBar3, "North");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        boolean bl;
        this.autofitCheckBox.setText(ToolsRes.getString("Checkbox.Autofit.Label"));
        this.rmsLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.RMSDeviation"));
        this.fitBuilderButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Tooltip"));
        if (this.fitBuilder != null) {
            this.newFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
            this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
            this.deleteFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
            this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
        }
        this.paramTable.tableChanged(null);
        int n = this.fitDropDown.getItemCount();
        Object[] objectArray = new Object[n];
        this.fitNames = new String[]{ToolsRes.getString("Function.Poly1.Name"), ToolsRes.getString("Function.Poly2.Name"), ToolsRes.getString("Function.Poly3.Name")};
        int n2 = n - this.fitNames.length;
        int n3 = 0;
        while (n3 < n) {
            objectArray[n3] = n3 < n2 ? this.fitDropDown.getItemAt(n3) : this.fitNames[n3 - n2];
            ++n3;
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        int n4 = this.fitDropDown.getSelectedIndex();
        this.fitDropDown.setModel(defaultComboBoxModel);
        this.fitDropDown.setSelectedIndex(n4);
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl2 = bl = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1;
        if (bl) {
            this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
        } else {
            this.colorButton.setBackground(this.color);
        }
    }

    protected void selectFit(String string) {
        this.fit = (KnownFunction)this.namedFits.get(string);
        if (this.fit == null) {
            if (string.equals(ToolsRes.getString("Function.Poly1.Name"))) {
                this.fit = new KnownPolynomial(new double[]{0.0, 0.0});
            } else if (string.equals(ToolsRes.getString("Function.Poly2.Name"))) {
                this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0});
            } else if (string.equals(ToolsRes.getString("Function.Poly3.Name"))) {
                this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0, 0.0});
            }
            if (this.fit != null) {
                this.namedFits.put(string, this.fit);
            }
        }
        if (this.fit != null) {
            FunctionDrawer functionDrawer = this.drawer;
            this.drawer = new FunctionDrawer(this.fit);
            this.drawer.setColor(this.color);
            this.paramTable.tableChanged(null);
            String string2 = GUIUtils.removeSubscripting(this.dataset.getColumnName(1));
            String string3 = GUIUtils.removeSubscripting(this.dataset.getColumnName(0));
            this.eqnField.setText(String.valueOf(string2) + " = " + this.fit.getExpression(string3));
            this.firePropertyChange("drawer", functionDrawer, this.drawer);
            this.fit(this.fit);
            if (this.fit instanceof UserFunction && this.fitBuilder != null && this.fitBuilder.isVisible()) {
                UserFunction userFunction = (UserFunction)this.fit;
                this.fitBuilder.setSelectedPanel(userFunction.getName());
            }
            this.revalidate();
        }
    }

    protected FunctionTool getFitBuilder() {
        if (this.fitBuilder == null) {
            this.newFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
            this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
            this.newFitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = DatasetCurveFitter.this.fitBuilder.getUniqueName(ToolsRes.getString("DatasetCurveFitter.NewFit.Name"));
                    UserFunction userFunction = new UserFunction(string);
                    String string2 = GUIUtils.removeSubscripting(DatasetCurveFitter.this.dataset.getColumnName(0));
                    userFunction.setExpression("0", new String[]{string2});
                    DatasetCurveFitter.this.namedFits.put(string, userFunction);
                    DatasetCurveFitter.this.fitDropDown.insertItemAt(string, 0);
                    UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
                    userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
                    FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
                    DatasetCurveFitter.this.fitBuilder.addPanel(userFunction.getName(), fitFunctionPanel);
                    DatasetCurveFitter.this.fitBuilder.setSelectedPanel(string);
                    DatasetCurveFitter.this.fitDropDown.setSelectedItem(string);
                }
            });
            this.deleteFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
            this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
            this.deleteFitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = DatasetCurveFitter.this.fitBuilder.getSelectedName();
                    DatasetCurveFitter.this.namedFits.remove(string);
                    DatasetCurveFitter.this.fitDropDown.removeItem(string);
                    DatasetCurveFitter.this.fitBuilder.removePanel(string);
                }
            });
            this.fitBuilder = new FunctionTool(this, new JButton[]{this.newFitButton, this.deleteFitButton});
            this.fitBuilder.addForbiddenNames(this.fitNames);
            this.fitBuilder.setHelpPath("fit_builder_help.html");
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.fitBuilder.spinner.getEditor();
            final JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        String string = jFormattedTextField.getText();
                        FunctionEditor functionEditor = DatasetCurveFitter.this.fitBuilder.selectedPanel.functionEditor;
                        functionEditor.tableModel.setValueAt(string, 0, 0);
                        jFormattedTextField.setBackground(Color.white);
                    } else {
                        jFormattedTextField.setBackground(Color.yellow);
                    }
                }
            });
            this.fitBuilder.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (DatasetCurveFitter.this.refreshing) {
                        return;
                    }
                    String string = propertyChangeEvent.getPropertyName();
                    if (!string.equals("function") && !string.equals("panel")) {
                        return;
                    }
                    FunctionPanel functionPanel = DatasetCurveFitter.this.fitBuilder.getPanel(DatasetCurveFitter.this.fitBuilder.getSelectedName());
                    DatasetCurveFitter.this.deleteFitButton.setEnabled(functionPanel != null);
                    if (functionPanel instanceof FitFunctionPanel) {
                        String string2;
                        UserFunction userFunction = ((FitFunctionPanel)functionPanel).getFitFunction();
                        String string3 = userFunction.getName();
                        if (string.equals("function") && (string2 = (String)propertyChangeEvent.getOldValue()) != null) {
                            DatasetCurveFitter.this.namedFits.remove(string2);
                            DatasetCurveFitter.this.namedFits.put(string3, userFunction);
                            int n = 0;
                            while (n < DatasetCurveFitter.this.fitDropDown.getItemCount()) {
                                Object e = DatasetCurveFitter.this.fitDropDown.getItemAt(n);
                                if (e.equals(string2)) {
                                    DatasetCurveFitter.this.fitDropDown.insertItemAt(string3, n);
                                    DatasetCurveFitter.this.fitDropDown.removeItem(string2);
                                    break;
                                }
                                ++n;
                            }
                        }
                        if (!DatasetCurveFitter.this.fitDropDown.getSelectedItem().equals(string3)) {
                            DatasetCurveFitter.this.fitDropDown.setSelectedItem(string3);
                        }
                        DatasetCurveFitter.this.refreshGUI();
                    }
                }
            });
        }
        return this.fitBuilder;
    }

    private double getDevSquared(Function function, double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            double d2 = function.evaluate(dArray[n]);
            double d3 = d2 - dArray2[n];
            d += d3 * d3;
            ++n;
        }
        return d;
    }

    private String getFitName() {
        for (Object k : this.namedFits.keySet()) {
            if (this.fit != this.namedFits.get(k)) continue;
            return k.toString();
        }
        return null;
    }

    protected JDialog getColorDialog() {
        if (this.colorDialog == null) {
            final Frame frame = JOptionPane.getFrameForComponent(this);
            final JColorChooser jColorChooser = new JColorChooser();
            jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    DatasetCurveFitter.this.color = jColorChooser.getColor();
                    DatasetCurveFitter.this.setColor(DatasetCurveFitter.this.color);
                    frame.repaint();
                }
            });
            this.colorDialog = new JDialog(frame, false);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DatasetCurveFitter.this.colorDialog.setVisible(false);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.closeButton);
            AbstractColorChooserPanel abstractColorChooserPanel = jColorChooser.getChooserPanels()[0];
            abstractColorChooserPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 12, 2));
            jPanel.add((Component)abstractColorChooserPanel, "Center");
            jPanel.add((Component)jPanel2, "South");
            this.colorDialog.setContentPane(jPanel);
            this.colorDialog.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.colorDialog.getWidth()) / 2;
            Point point = this.getLocationOnScreen();
            int n2 = Math.max(0, point.y - this.colorDialog.getHeight());
            this.colorDialog.setLocation(n, n2);
        }
        return this.colorDialog;
    }

    class KnownPolynomial
    extends PolynomialLeastSquareFit
    implements KnownFunction {
        String[] names;

        KnownPolynomial(double[] dArray, double[] dArray2, int n) {
            super(dArray, dArray2, n);
            this.names = new String[]{"a", "b", "c", "d", "e", "f"};
        }

        KnownPolynomial(double[] dArray) {
            super(dArray);
            this.names = new String[]{"a", "b", "c", "d", "e", "f"};
        }

        public int getParameterCount() {
            return this.coefficients.length;
        }

        public String getParameterName(int n) {
            return this.names[n];
        }

        public double getParameterValue(int n) {
            return this.coefficients[this.coefficients.length - n - 1];
        }

        public void setParameterValue(int n, double d) {
            this.coefficients[this.coefficients.length - n - 1] = d;
        }

        public String getExpression(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.coefficients.length - 1;
            int n2 = 0;
            while (n2 <= n) {
                stringBuffer.append(this.getParameterName(n2));
                if (n - n2 > 0) {
                    stringBuffer.append("*");
                    stringBuffer.append(string);
                    if (n - n2 > 1) {
                        stringBuffer.append("^");
                        stringBuffer.append(n - n2);
                    }
                    stringBuffer.append(" + ");
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
    }

    public class MinimizeMultiVarFunction
    implements MultiVarFunction {
        MultiVarFunction f;
        double[] x;
        double[] y;
        double[] vars = new double[5];

        MinimizeMultiVarFunction(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2) {
            this.f = multiVarFunction;
            this.x = dArray;
            this.y = dArray2;
        }

        public double evaluate(double[] dArray) {
            System.arraycopy(dArray, 0, this.vars, 1, 4);
            double d = 0.0;
            int n = 0;
            int n2 = this.x.length;
            while (n < n2) {
                this.vars[0] = this.x[n];
                double d2 = this.y[n] - this.f.evaluate(this.vars);
                d += d2 * d2;
                ++n;
            }
            return d;
        }
    }

    public class MinimizeUserFunction
    implements MultiVarFunction {
        UserFunction f;
        double[] x;
        double[] y;

        MinimizeUserFunction(UserFunction userFunction, double[] dArray, double[] dArray2) {
            this.f = userFunction;
            this.x = dArray;
            this.y = dArray2;
        }

        public double evaluate(double[] dArray) {
            int n = 0;
            while (n < dArray.length) {
                this.f.setParameterValue(n, dArray[n]);
                ++n;
            }
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.x.length) {
                double d2 = this.y[n2] - this.f.evaluate(this.x[n2]);
                d += d2 * d2;
                ++n2;
            }
            return d;
        }
    }

    class NumberField
    extends JTextField {
        protected NumberFormat format;
        protected double prevValue;

        public NumberField(int n) {
            super(n);
            this.format = NumberFormat.getInstance();
            if (this.format instanceof DecimalFormat) {
                ((DecimalFormat)this.format).applyPattern("0.000E0");
            }
            this.setForeground(Color.black);
        }

        public double getValue() {
            double d;
            if (this.getText().equals(this.format.format(this.prevValue))) {
                return this.prevValue;
            }
            try {
                d = this.format.parse(this.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                Toolkit.getDefaultToolkit().beep();
                this.setValue(this.prevValue);
                return this.prevValue;
            }
            return d;
        }

        public void setValue(double d) {
            if (!this.isVisible()) {
                return;
            }
            this.setText(this.format.format(d));
            this.prevValue = d;
        }
    }

    class ParamCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color lightBlue = new Color(204, 204, 255);
        Color lightGray = UIManager.getColor("Panel.background");
        Font fieldFont = new JTextField().getFont();
        Font labelFont = this.getFont();

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(2);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            if (object instanceof String) {
                this.setFont(this.labelFont);
                this.setBackground(bl ? Color.LIGHT_GRAY : this.lightGray);
                this.setForeground(Color.black);
                this.setText(object.toString());
            } else {
                this.setFont(this.fieldFont);
                this.setBackground(bl ? this.lightBlue : Color.white);
                this.setForeground(bl ? Color.red : Color.black);
                NumberFormat numberFormat = DatasetCurveFitter.this.spinCellEditor.field.format;
                this.setText(numberFormat.format(object));
            }
            return this;
        }
    }

    class ParamTable
    extends JTable {
        public ParamTable(ParamTableModel paramTableModel) {
            super(paramTableModel);
            this.setPreferredScrollableViewportSize(new Dimension(60, 50));
            this.setGridColor(Color.blue);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setForeground(Color.blue);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return DatasetCurveFitter.this.cellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            DatasetCurveFitter.this.spinCellEditor.rowNumber = n;
            return DatasetCurveFitter.this.spinCellEditor;
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        public String getColumnName(int n) {
            return n == 0 ? ToolsRes.getString("Table.Heading.Parameter") : ToolsRes.getString("Table.Heading.Value");
        }

        public int getRowCount() {
            return DatasetCurveFitter.this.fit == null ? 0 : DatasetCurveFitter.this.fit.getParameterCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return DatasetCurveFitter.this.fit.getParameterName(n);
            }
            return new Double(DatasetCurveFitter.this.fit.getParameterValue(n));
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class SpinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        SpinnerNumberCrawlerModel crawlerModel;
        JSpinner spinner;
        NumberField field;
        int rowNumber;
        JLabel stepSizeLabel;

        SpinCellEditor() {
            this.crawlerModel = new SpinnerNumberCrawlerModel(1.0);
            this.stepSizeLabel = new JLabel("10%");
            this.panel.setOpaque(false);
            this.spinner = new JSpinner(this.crawlerModel);
            this.spinner.setToolTipText(ToolsRes.getString("Table.Spinner.ToolTip"));
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    UserFunction userFunction;
                    String string;
                    FitFunctionPanel fitFunctionPanel;
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                    double d = (Double)SpinCellEditor.this.spinner.getValue();
                    SpinCellEditor.this.field.setValue(d);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(SpinCellEditor.this.rowNumber, d);
                    if (((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fitBuilder != null && ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit instanceof UserFunction && (fitFunctionPanel = (FitFunctionPanel)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fitBuilder.getPanel(string = (userFunction = (UserFunction)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit).getName())) != null) {
                        string = ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.getParameterName(SpinCellEditor.this.rowNumber);
                        Parameter parameter = new Parameter(string, SpinCellEditor.this.field.getText());
                        block0: for (Parameter parameter2 : fitFunctionPanel.getParamEditor().evaluateDependents(parameter)) {
                            int n = 0;
                            while (n < ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.getParameterCount()) {
                                if (((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.getParameterName(n).equals(parameter2.getName())) {
                                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(n, parameter2.getValue());
                                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.paramModel.fireTableCellUpdated(n, 1);
                                    continue block0;
                                }
                                ++n;
                            }
                        }
                        fitFunctionPanel.getFitFunctionEditor().parametersValid = false;
                    }
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.drawer.functionChanged = true;
                    DatasetCurveFitter.this.fit(((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit);
                }
            });
            this.field = new NumberField(10);
            this.field.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
            this.spinner.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.spinner.setEditor(this.field);
            this.stepSizeLabel.addMouseListener(new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            double d = Double.parseDouble(actionEvent.getActionCommand());
                            (this).SpinCellEditor.this.crawlerModel.setPercentDelta(d);
                            (this).SpinCellEditor.this.crawlerModel.refreshDelta();
                            (this).SpinCellEditor.this.stepSizeLabel.setText(String.valueOf(actionEvent.getActionCommand()) + "%");
                        }
                    };
                    int n = 0;
                    while (n < 3) {
                        String string = n == 0 ? "10" : (n == 1 ? "1.0" : "0.1");
                        JMenuItem jMenuItem = new JMenuItem(String.valueOf(string) + "%");
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                        ++n;
                    }
                    jPopupMenu.show(SpinCellEditor.this.stepSizeLabel, 0, SpinCellEditor.this.stepSizeLabel.getHeight());
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    JComponent jComponent = (JComponent)keyEvent.getSource();
                    if (keyEvent.getKeyCode() == 10) {
                        SpinCellEditor.this.spinner.setValue(new Double(SpinCellEditor.this.field.getValue()));
                        jComponent.setBackground(Color.white);
                        SpinCellEditor.this.crawlerModel.refreshDelta();
                    } else {
                        jComponent.setBackground(Color.yellow);
                    }
                }
            });
            this.panel.add((Component)this.spinner, "Center");
            this.panel.add((Component)this.stepSizeLabel, "East");
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.spinner.setValue(object);
            this.crawlerModel.refreshDelta();
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return true;
            }
            return eventObject instanceof ActionEvent;
        }

        public Object getCellEditorValue() {
            if (this.field.getBackground() == Color.yellow) {
                DatasetCurveFitter.this.fit.setParameterValue(this.rowNumber, this.field.getValue());
                DatasetCurveFitter.this.drawer.functionChanged = true;
                DatasetCurveFitter.this.firePropertyChange("fit", null, null);
                this.field.setBackground(Color.white);
            }
            return null;
        }
    }

    class SpinnerNumberCrawlerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta;
        double percentDelta = 10.0;

        public SpinnerNumberCrawlerModel(double d) {
            this.delta = d;
        }

        public Object getValue() {
            return new Double(this.val);
        }

        public Object getNextValue() {
            return new Double(this.val + this.delta);
        }

        public Object getPreviousValue() {
            return new Double(this.val - this.delta);
        }

        public void setValue(Object object) {
            if (object != null) {
                this.val = (Double)object;
                this.fireStateChanged();
            }
        }

        public void setPercentDelta(double d) {
            this.percentDelta = d;
        }

        public double getPercentDelta() {
            return this.percentDelta;
        }

        public void refreshDelta() {
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            }
        }
    }
}

