/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FourierToolTab;
import org.opensourcephysics.tools.ToolsRes;

public class FourierTool
extends DataTool {
    static final FourierTool FOURIER_TOOL = new FourierTool();

    public static DataTool getTool() {
        return FOURIER_TOOL;
    }

    public FourierTool() {
        super(ToolsRes.getString("FourierTool.Frame.Title"), "FourierTool");
    }

    public FourierTool(String string) {
        super(string);
    }

    public FourierTool(XMLControl xMLControl) {
        super(xMLControl);
    }

    public FourierTool(Data data) {
        super(data);
    }

    public DataToolTab addTab(Data data, String string) {
        FourierToolTab fourierToolTab = null;
        ArrayList arrayList = data.getDatasets();
        if (arrayList != null) {
            for (Dataset dataset : arrayList) {
                fourierToolTab = new FourierToolTab(dataset, this);
                fourierToolTab.setName(dataset.getName());
                this.addTab(fourierToolTab);
            }
        }
        return fourierToolTab;
    }

    protected void addTab(DataToolTab dataToolTab) {
        super.addTab(dataToolTab);
        if (dataToolTab instanceof FourierToolTab) {
            dataToolTab.fitCheckbox = null;
            final FourierToolTab fourierToolTab = (FourierToolTab)dataToolTab;
            dataToolTab.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    if (!fourierToolTab.sourceCheckbox.isSelected()) {
                        fourierToolTab.splitPanes[1].setDividerLocation(1.0);
                    }
                }
            });
        }
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.setTitle(ToolsRes.getString("FourierTool.Frame.Title"));
    }
}

