/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.opensourcephysics.analysis.FourierSinCosAnalysis;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FourierTool;

public class FourierToolTab
extends DataToolTab {
    protected Action sourceAction;
    protected JCheckBox sourceCheckbox;
    protected Dataset source;
    protected PlottingPanel sourcePlot;
    protected DataTable sourceTable;
    JSplitPane sourceSplitPane;

    public FourierToolTab(Dataset dataset, FourierTool fourierTool) {
        super(FourierToolTab.createFourierData(dataset), fourierTool);
        XMLControlElement xMLControlElement = new XMLControlElement(dataset);
        this.source = new Dataset();
        xMLControlElement.loadObject(this.source);
        this.source.setMarkerColor(Color.red.darker());
        this.source.setConnected(true);
    }

    protected static Data createFourierData(Dataset dataset) {
        Object object;
        Object object2 = dataset.getXPoints();
        double[] dArray = dataset.getYPoints();
        if (dArray.length % 2 == 1) {
            object = new double[dArray.length - 1];
            double[] dArray2 = new double[((Object)object).length];
            System.arraycopy(object2, 0, object, 0, ((Object)object).length);
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            dataset.clear();
            dataset.append((double[])object, dArray2);
            object2 = object;
            dArray = dArray2;
        }
        object = new FourierSinCosAnalysis();
        ((FourierSinCosAnalysis)object).doAnalysis((double[])object2, dArray, 0);
        return object;
    }

    protected void init() {
        super.init();
        this.setMarkersVisible("power", true);
        this.setMarkersVisible("sin", false);
        this.setMarkersVisible("cos", false);
    }

    protected void createGUI() {
        super.createGUI();
        this.sourceTable = new DataTable();
        this.sourceAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FourierToolTab.this.splitPanes[1].setDividerSize(FourierToolTab.this.splitPanes[2].getDividerSize());
                FourierToolTab.this.splitPanes[1].setDividerLocation(1.0);
                boolean bl = FourierToolTab.this.sourceCheckbox.isSelected();
                FourierToolTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    int n = FourierToolTab.this.splitPanes[1].getDividerLocation();
                    int n2 = 150;
                    FourierToolTab.this.splitPanes[1].setDividerSize(FourierToolTab.this.splitPanes[0].getDividerSize());
                    FourierToolTab.this.splitPanes[1].setDividerLocation(n - n2 - 10);
                    if (FourierToolTab.this.sourcePlot == null) {
                        FourierToolTab.this.sourcePlot = new PlottingPanel(FourierToolTab.this.source.getXColumnName(), FourierToolTab.this.source.getYColumnName(), "Source Data");
                        FourierToolTab.this.sourceSplitPane.setLeftComponent(FourierToolTab.this.sourcePlot);
                        FourierToolTab.this.sourceTable.add(FourierToolTab.this.source);
                        FourierToolTab.this.sourceSplitPane.setDividerLocation(0.7);
                    }
                    FourierToolTab.this.sourceTable.refreshTable();
                    FourierToolTab.this.sourcePlot.addDrawable(FourierToolTab.this.source);
                }
                FourierToolTab.this.refresh();
            }
        };
        this.sourceCheckbox = new JCheckBox("Source Data");
        this.sourceCheckbox.setSelected(false);
        this.sourceCheckbox.setOpaque(false);
        this.sourceCheckbox.addActionListener(this.sourceAction);
        int n = this.toolbar.getComponentIndex(this.fitCheckbox);
        this.toolbar.remove(this.fitCheckbox);
        this.toolbar.add((Component)this.sourceCheckbox, n);
        this.sourceSplitPane = new JSplitPane(1);
        this.sourceSplitPane.setResizeWeight(1.0);
        JScrollPane jScrollPane = new JScrollPane(this.sourceTable);
        this.sourceSplitPane.setRightComponent(jScrollPane);
        this.splitPanes[1].setBottomComponent(this.sourceSplitPane);
    }

    protected void refreshGUI() {
        super.refreshGUI();
    }
}

