/*
 * Decompiled with CFR 0.152.
 */
package users.davidson.wochristian.qm.SuperpositionDemo_1;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.specialfunctions.Factorials;
import org.opensourcephysics.numerics.specialfunctions.Hermite;
import org.opensourcephysics.tools.ResourceLoader;
import users.davidson.wochristian.qm.SuperpositionDemo_1.SuperpositionDemoSimulation;
import users.davidson.wochristian.qm.SuperpositionDemo_1.SuperpositionDemoView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperpositionDemo
extends AbstractModel {
    public SuperpositionDemoSimulation _simulation = null;
    public SuperpositionDemoView _view = null;
    public SuperpositionDemo _model = this;
    public boolean centered = false;
    public int displayMode = 2;
    public int n = 500;
    public double a = 1.5707963267948966;
    public double[] x;
    public double[] rePsi;
    public double[] imPsi;
    public double t = 0.0;
    public double dt = 0.01;
    public String options = "";
    public String selection = "null";
    public String[] scenarioNames;
    public String[] scenarioData;
    public String qm_system = "null";
    public int first = 1;
    public double m = 1.0;
    public double hbar = 1.0;
    public int states = 1;
    public double[][] outArray;
    public Object[] H;

    public static String _getEjsModel() {
        return "users/davidson/wochristian/qm/SuperpositionDemo.xml";
    }

    public static String _getModelDirectory() {
        return "users/davidson/wochristian/qm/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/SHO_Superposition_Ex.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/SuperpositionDemo.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/ISW_Superposition.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/expansion_table.jpg");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/isw.jpg");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/isw_eigen.jpg");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/isw_eigenfunctions.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/isw_eigenvalues.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/ISW_Superposition.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/ISW_Superposition_Ex.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/schroedinger_au.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/Shifted_SHO.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/sho.jpg");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/sho_eigen.jpg");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/sho_eigenfunctions.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/sho_eigenvalues.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/SHO_Superposition.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/SHO_Superposition_Ex.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/spring_constant.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/SuperpositionDemo.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/superposition_principle.gif");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionDemo/SHO_Superposition.html");
        hashSet.add("users/davidson/wochristian/qm/SuperpositionData.txt");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/davidson/wochristian/qm/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/ejs/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/ejs/EJS_4.1/bin/config/");
        }
        SuperpositionDemo superpositionDemo = new SuperpositionDemo(stringArray);
    }

    public SuperpositionDemo() {
        this(null, null, null, null, null, false);
    }

    public SuperpositionDemo(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public SuperpositionDemo(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new SuperpositionDemoSimulation(this, string, frame, uRL, bl);
        this._view = (SuperpositionDemoView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        double d = Math.sqrt(Math.PI);
        for (int i = 0; i < this.states; ++i) {
            double d2 = Math.sqrt(Math.pow(2.0, i) * Factorials.factorial(i) * d);
            this.H[i] = Hermite.getPolynomial(i).divide(d2);
        }
        this.readDataFromFile();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        if (this.qm_system.trim().equals("ISW")) {
            this.first = 1;
            this.ISW_Superpostion();
        } else {
            this.first = 0;
            this.SHO_Superpostion();
        }
    }

    public void ISW_Superpostion() {
        double d = -this.a;
        double d2 = 2.0 * this.a / (double)(this.x.length - 1);
        double d3 = Math.PI / this.a;
        double d4 = d3 * d3 / 2.0;
        double d5 = Math.sqrt(0.5 / this.a);
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            this.x[i] = d;
            this.rePsi[i] = 0.0;
            this.imPsi[i] = 0.0;
            int n2 = this.outArray.length;
            for (int j = 1; j <= n2; ++j) {
                if (Math.abs(d) >= this.a / 2.0) continue;
                double d6 = 0.0;
                double d7 = 0.0;
                if (j % 2 == 0) {
                    d6 = d5 * this.outArray[j - 1][1] * Math.sin((double)j * d3 * d);
                    d7 = d5 * this.outArray[j - 1][2] * Math.sin((double)j * d3 * d);
                } else {
                    d6 = d5 * this.outArray[j - 1][1] * Math.cos((double)j * d3 * d);
                    d7 = d5 * this.outArray[j - 1][2] * Math.cos((double)j * d3 * d);
                }
                int n3 = i;
                this.rePsi[n3] = this.rePsi[n3] + (d6 * Math.cos((double)(-j * j) * d4 * this.t) - d7 * Math.sin((double)(-j * j) * d4 * this.t));
                int n4 = i;
                this.imPsi[n4] = this.imPsi[n4] + (d6 * Math.sin((double)(-j * j) * d4 * this.t) + d7 * Math.cos((double)(-j * j) * d4 * this.t));
            }
            d += d2;
        }
    }

    public void SHO_Superpostion() {
        double d = -2.5 * this.a;
        double d2 = 5.0 * this.a / (double)(this.x.length - 1);
        double d3 = Math.pow(Math.PI, 0.25) / Math.sqrt(this.a);
        double d4 = Math.PI / this.a;
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            this.x[i] = d;
            double d5 = d * d4;
            this.rePsi[i] = 0.0;
            this.imPsi[i] = 0.0;
            int n2 = this.outArray.length;
            for (int j = 0; j < n2; ++j) {
                double d6 = ((double)j + 0.5) * Math.PI * Math.PI / this.a / this.a;
                if (this.H[j] == null) break;
                double d7 = d3 * this.outArray[j][1] * Math.exp(-d5 * d5 / 2.0) * ((Function)this.H[j]).evaluate(d5);
                double d8 = d3 * this.outArray[j][2] * Math.exp(-d5 * d5 / 2.0) * ((Function)this.H[j]).evaluate(d5);
                int n3 = i;
                this.rePsi[n3] = this.rePsi[n3] + (d7 * Math.cos(-d6 * this.t) - d8 * Math.sin(-d6 * this.t));
                int n4 = i;
                this.imPsi[n4] = this.imPsi[n4] + (d7 * Math.sin(-d6 * this.t) + d8 * Math.cos(-d6 * this.t));
            }
            d += d2;
        }
    }

    public void normalize() {
        int n;
        double d = 0.0;
        int n2 = this.outArray.length;
        for (n = 0; n < n2; ++n) {
            d += this.outArray[n][1] * this.outArray[n][1] + this.outArray[n][2] * this.outArray[n][2];
        }
        d = d == 0.0 ? 1.0 : Math.sqrt(d);
        n2 = this.outArray.length;
        for (n = 0; n < n2; ++n) {
            double[] dArray = this.outArray[n];
            dArray[1] = dArray[1] / d;
            double[] dArray2 = this.outArray[n];
            dArray2[2] = dArray2[2] / d;
        }
        this._view.coefficientArray.refreshTable();
    }

    public void compute_Eigenvalues() {
        this.t = 0.0;
        int n = this.outArray.length;
        for (int i = 0; i < n; ++i) {
            this.outArray[i][0] = this.qm_system.equals("ISW") ? this.iswEnergy(i) : this.shoEnergy(i);
        }
    }

    double iswEnergy(int n) {
        double d = (double)(++n) * Math.PI / this.a;
        return d * d / 2.0;
    }

    double shoEnergy(int n) {
        return ((double)n + 0.5) * Math.PI * Math.PI / this.a / this.a;
    }

    private void readDataFromFile() {
        String string = "SuperpositionData.txt";
        String string2 = ResourceLoader.getString(string);
        if (string2 == null) {
            System.out.println("Error reading " + string);
            return;
        }
        this.scenarioData = string2.split("#");
        this.options = "";
        this.scenarioNames = new String[this.scenarioData.length];
        int n = this.scenarioData.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = this.scenarioData[i].split("\n");
            this.scenarioNames[i] = "";
            if (stringArray == null || stringArray.length < 10) continue;
            this.scenarioNames[i] = stringArray[0].trim();
            this.options = this.options + stringArray[0].trim() + ';';
        }
        this.selection = this.scenarioNames[1];
        this.readScenario(this.scenarioData[1]);
    }

    public void selectScenario() {
        this._pause();
        int n = this.scenarioData.length;
        for (int i = 0; i < n; ++i) {
            if (!this.selection.equals(this.scenarioNames[i])) continue;
            this.readScenario(this.scenarioData[i]);
            break;
        }
    }

    private void readScenario(String string) {
        String[] stringArray = string.split("\n");
        if (stringArray == null || stringArray.length < 10) {
            return;
        }
        String string2 = stringArray[1].trim();
        int n = string2.indexOf("=");
        this.qm_system = string2.substring(n + 1).trim();
        string2 = stringArray[2].trim();
        this.centered = string2.substring(n + 1).trim().equals("true");
        string2 = stringArray[3].trim();
        n = string2.indexOf("=");
        this.displayMode = (int)Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[4].trim();
        n = string2.indexOf("=");
        this.n = (int)Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[5].trim();
        this.a = string2.indexOf("=");
        this.a = Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[6].trim();
        n = string2.indexOf("=");
        this.t = Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[7].trim();
        n = string2.indexOf("=");
        this.dt = Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[8].trim();
        n = string2.indexOf("=");
        this.states = (int)Double.parseDouble(string2.substring(n + 1).trim());
        this.allocateArrays();
        int n2 = stringArray.length;
        for (int i = 10; i < n2; ++i) {
            String[] stringArray2 = stringArray[i].trim().split("\\s");
            this.outArray[i - 10][1] = Double.parseDouble(stringArray2[0]);
            this.outArray[i - 10][2] = Double.parseDouble(stringArray2[1]);
        }
        this.compute_Eigenvalues();
        this._view.coefficientArray.refreshTable();
    }

    public void allocateArrays() {
        this.x = new double[this.n];
        this.rePsi = new double[this.n];
        this.imPsi = new double[this.n];
        this.outArray = new double[this.states][3];
        this.H = new Object[this.states];
        double d = Math.sqrt(Math.PI);
        for (int i = 0; i < this.states; ++i) {
            double d2 = Math.sqrt(Math.pow(2.0, i) * Factorials.factorial(i) * d);
            this.H[i] = Hermite.getPolynomial(i).divide(d2);
        }
        this.compute_Eigenvalues();
    }

    public double _method_for_wavefunctionPlottingPanel_minimumY() {
        return this.centered ? -2.0 : 0.0;
    }

    public double _method_for_leftWall_x() {
        return -this.a / 2.0;
    }

    public boolean _method_for_leftWall_visible() {
        return this.first == 1;
    }

    public double _method_for_rightWall_x() {
        return this.a / 2.0;
    }

    public boolean _method_for_rightWall_visible() {
        return this.first == 1;
    }

    public void _method_for_startStopButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startStopButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetTime_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_colorCheckBox_actionon() {
        this._simulation.disableLoop();
        this.displayMode = 2;
        this.centered = false;
        this._simulation.enableLoop();
    }

    public void _method_for_colorCheckBox_actionoff() {
        this._simulation.disableLoop();
        this.displayMode = 1;
        this.centered = true;
        this._simulation.enableLoop();
    }

    public boolean _method_for_comboBox_editable() {
        return this._isPaused();
    }

    public void _method_for_comboBox_action() {
        this._simulation.disableLoop();
        this.selectScenario();
        this._simulation.enableLoop();
    }

    public double _method_for_widthSlider_maximum() {
        return Math.PI;
    }

    public void _method_for_widthSlider_dragaction() {
        this._simulation.disableLoop();
        this.a = Math.max(this.a, 0.05);
        this.compute_Eigenvalues();
        this._simulation.enableLoop();
    }

    public void _method_for_normalizeButton_action() {
        this._simulation.disableLoop();
        this.normalize();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.centered = false;
        this.displayMode = 2;
        this.n = 500;
        this.a = 1.5707963267948966;
        this.x = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = 0.0;
        }
        this.rePsi = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.rePsi[n] = 0.0;
        }
        this.imPsi = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.imPsi[n] = 0.0;
        }
        this.t = 0.0;
        this.dt = 0.01;
        this.selection = "null";
        this.scenarioNames = new String[0];
        this.scenarioData = new String[0];
        this.qm_system = "null";
        this.first = 1;
        this.m = 1.0;
        this.hbar = 1.0;
        this.states = 1;
        this.outArray = new double[this.states][3];
        for (n = 0; n < this.states; ++n) {
            for (int i = 0; i < 3; ++i) {
                this.outArray[n][i] = 0.0;
            }
        }
        this.H = new Object[this.states];
        for (n = 0; n < this.states; ++n) {
            this.H[n] = null;
        }
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.rePsi = null;
        this.imPsi = null;
        this.scenarioNames = null;
        this.scenarioData = null;
        this.outArray = null;
        this.H = null;
        System.gc();
    }
}

