/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.opensourcephysics.controls.ControlFrame;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.DoubleArray;
import org.opensourcephysics.numerics.IntegerArray;
import org.opensourcephysics.tools.ToolsRes;

public class OSPControl
extends ControlFrame
implements PropertyChangeListener,
MainFrame {
    OSPControlTable table = new OSPControlTable(new XMLControlElement());
    JScrollPane controlScrollPane = new JScrollPane(this.table);
    JTextArea messageTextArea;
    JLabel clearLabel;
    JLabel messageLabel;
    JLabel inputLabel;
    JSplitPane splitPane;
    JMenuItem translateItem;
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");

    public OSPControl(Object object) {
        super(ControlsRes.getString("OSPControl.Default_Title"));
        Object object2;
        this.model = object;
        if (this.model != null) {
            if (OSPRuntime.translator != null) {
                OSPRuntime.translator.associate(this, this.model.getClass());
            }
            object2 = this.model.getClass().getName();
            this.setTitle(String.valueOf(((String)object2).substring(1 + ((String)object2).lastIndexOf("."))) + ControlsRes.getString("OSPControl.Controller"));
        }
        ToolsRes.addPropertyChangeListener("locale", this);
        object2 = new Font("Dialog", 1, 12);
        this.inputLabel = new JLabel(ControlsRes.getString("OSPControl.Input_Parameters"), 0);
        this.inputLabel.setFont((Font)object2);
        this.messageTextArea = new JTextArea(5, 5);
        JScrollPane jScrollPane = new JScrollPane(this.messageTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.inputLabel, "North");
        jPanel.add((Component)this.controlScrollPane, "Center");
        this.buttonPanel.setVisible(true);
        jPanel.add((Component)this.buttonPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.addMouseListener(new ClearMouseAdapter());
        this.clearLabel = new JLabel(ControlsRes.getString("OSPControl.Clear"));
        this.clearLabel.setFont(new Font(this.clearLabel.getFont().getFamily(), 0, 9));
        this.clearLabel.setForeground(Color.black);
        jPanel2.add((Component)this.clearLabel, "West");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.messageLabel = new JLabel(ControlsRes.getString("OSPControl.Messages"), 0);
        this.messageLabel.setFont((Font)object2);
        jPanel3.add((Component)this.messageLabel, "North");
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        Container container = this.getContentPane();
        this.splitPane = new JSplitPane(0, jPanel, jPanel3);
        this.splitPane.setOneTouchExpandable(true);
        container.add((Component)this.splitPane, "Center");
        this.messageTextArea.setEditable(false);
        this.controlScrollPane.setPreferredSize(new Dimension(350, 200));
        this.controlScrollPane.setMinimumSize(new Dimension(0, 50));
        jScrollPane.setPreferredSize(new Dimension(350, 75));
        if (OSPRuntime.translator != null && this.model != null) {
            OSPRuntime.translator.associate(this.table, this.model.getClass());
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.init();
    }

    public OSPFrame getMainFrame() {
        return this;
    }

    protected JMenu loadDisplayMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = super.loadDisplayMenu();
        this.translateItem = new JMenuItem();
        this.translateItem.setText(ControlsRes.getString("OSPControl.Translate"));
        if (OSPRuntime.translator != null) {
            this.translateItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPRuntime.translator.showProperties(OSPControl.this.model.getClass());
                    if (OSPRuntime.translator instanceof Hidable) {
                        ((Hidable)((Object)OSPRuntime.translator)).setKeepHidden(false);
                    }
                    OSPRuntime.translator.setVisible(true);
                }
            });
            this.translateItem.setEnabled(OSPRuntime.isAuthorMode());
            this.languageMenu.add((Component)this.translateItem, 0);
        }
        if (this.languageMenu.getItemCount() > 1) {
            this.languageMenu.insertSeparator(1);
        }
        return jMenu;
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.messageLabel.setText(ControlsRes.getString("OSPControl.Messages"));
        this.clearLabel.setText(ControlsRes.getString("OSPControl.Clear"));
        this.inputLabel.setText(ControlsRes.getString("OSPControl.Input_Parameters"));
        this.table.refresh();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("translation") || string.equals("locale")) {
            this.refreshGUI();
        } else {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    protected void init() {
        this.splitPane.setDividerLocation(-1);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public Object getModel() {
        return this.model;
    }

    public void setDividerLocation(int n) {
        this.splitPane.setDividerLocation(n);
    }

    public void setEditable(String string, boolean bl) {
        this.table.setEditable(string, bl);
    }

    public void setLockValues(boolean bl) {
        this.table.setLockValues(true);
    }

    public String toString() {
        return this.table.toString();
    }

    public void setValue(String string, Object object) {
        this.table.setValue(string, object);
    }

    public void setValue(String string, boolean bl) {
        this.table.setValue(string, bl);
    }

    public void setValue(String string, double d) {
        this.table.setValue(string, Double.toString(d));
    }

    public void setValue(String string, int n) {
        this.table.setValue(string, Integer.toString(n));
    }

    public void removeParameter(String string) {
        this.table.setValue(string, null);
    }

    public double getDouble(String string) {
        return this.table.getDouble(string);
    }

    public int getInt(String string) {
        return this.table.getInt(string);
    }

    public Object getObject(String string) throws UnsupportedOperationException {
        return this.table.getObject(string);
    }

    public String getString(String string) {
        return this.table.getString(string);
    }

    public boolean getBoolean(String string) {
        return this.table.getBoolean(string);
    }

    public Collection getPropertyNames() {
        return this.table.getPropertyNames();
    }

    public JButton addButton(String string, String string2) {
        return this.addButton(string, string2, null, this.model);
    }

    public JButton addButton(String string, String string2, String string3) {
        return this.addButton(string, string2, string3, this.model);
    }

    public void addControlListener(String string) {
        this.addControlListener(string, this.model);
    }

    public void addControlListener(String string, final Object object) {
        Class[] classArray = new Class[]{String.class};
        try {
            final Method method = object.getClass().getMethod(string, classArray);
            this.table.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() != 0 || tableModelEvent.getColumn() != 1 || tableModelEvent.getFirstRow() < 0) {
                        return;
                    }
                    String string = OSPControl.this.table.getValueAt(tableModelEvent.getFirstRow(), 0).toString();
                    Object[] objectArray = new Object[]{string};
                    try {
                        method.invoke(object, objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("The method " + string + "() does not exist.");
        }
    }

    public void println(String string) {
        this.print(String.valueOf(string) + "\n");
    }

    public void println() {
        this.print("\n");
    }

    public void print(final String string) {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            this.messageTextArea.append(string);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                OSPControl.this.messageTextArea.append(string);
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void clearMessages() {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            this.messageTextArea.setText("");
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                OSPControl.this.messageTextArea.setText("");
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void clearValues() {
        this.table.clearValues();
    }

    public void calculationDone(String string) {
        if (string != null) {
            this.println(string);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPControlLoader();
    }

    public static OSPControl createApp(Object object) {
        OSPControl oSPControl = new OSPControl(object);
        oSPControl.setSize(300, 300);
        oSPControl.setVisible(true);
        return oSPControl;
    }

    class ClearMouseAdapter
    extends MouseAdapter {
        ClearMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            OSPControl.this.clearMessages();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            OSPControl.this.clearLabel.setFont(new Font(OSPControl.this.clearLabel.getFont().getFamily(), 1, 10));
            OSPControl.this.clearLabel.setText(ControlsRes.getString("OSPControl.Click_to_clear_message"));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            OSPControl.this.clearLabel.setFont(new Font(OSPControl.this.clearLabel.getFont().getFamily(), 0, 9));
            OSPControl.this.clearLabel.setText(ControlsRes.getString("OSPControl.Clear"));
        }
    }

    static class OSPControlLoader
    implements XML.ObjectLoader {
        OSPControlLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            OSPControl oSPControl = (OSPControl)object;
            this.saveControlProperites(xMLControl, oSPControl);
            if (xMLControl.getLevel() == 0) {
                xMLControl.setValue("model", oSPControl.model);
            }
        }

        protected void saveControlProperites(XMLControl xMLControl, OSPControl oSPControl) {
            for (String string : oSPControl.getPropertyNames()) {
                Object object = oSPControl.getObject(string);
                if (object.getClass() == DoubleArray.class) {
                    xMLControl.setValue(string, ((DoubleArray)object).getArray());
                    continue;
                }
                if (object.getClass() == IntegerArray.class) {
                    xMLControl.setValue(string, ((IntegerArray)object).getArray());
                    continue;
                }
                if (object.getClass() == Boolean.class) {
                    xMLControl.setValue(string, (Boolean)object);
                    continue;
                }
                if (object.getClass() == Double.class) {
                    xMLControl.setValue(string, (Double)object);
                    continue;
                }
                if (object.getClass() == Integer.class) {
                    xMLControl.setValue(string, (Integer)object);
                    continue;
                }
                if (object.getClass() == Character.class) {
                    xMLControl.setValue(string, ((Character)object).toString());
                    continue;
                }
                if (object.getClass().isArray()) {
                    xMLControl.setValue(string, object);
                    continue;
                }
                xMLControl.setValue(string, object);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new OSPControl((Object)null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            OSPControl oSPControl = (OSPControl)object;
            Iterator iterator = xMLControl.getPropertyNames().iterator();
            oSPControl.table.setLockValues(true);
            while (iterator.hasNext()) {
                Object object2;
                String string = (String)iterator.next();
                if (string.equals("model") && xMLControl.getPropertyType(string).equals("object")) {
                    object2 = xMLControl.getChildControl("model");
                    oSPControl.model = object2.loadObject(oSPControl.model);
                    continue;
                }
                if (oSPControl.getObject(string) instanceof OSPCombo && xMLControl.getPropertyType(string).equals("string")) {
                    object2 = (OSPCombo)oSPControl.getObject(string);
                    String string2 = xMLControl.getString(string);
                    String[] stringArray = ((OSPCombo)object2).items;
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        if (string2.equals(stringArray[n])) {
                            ((OSPCombo)object2).selected = n;
                            break;
                        }
                        ++n;
                    }
                    oSPControl.setValue(string, object2);
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("string")) {
                    oSPControl.setValue(string, xMLControl.getString(string));
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("int")) {
                    oSPControl.setValue(string, xMLControl.getInt(string));
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("double")) {
                    oSPControl.setValue(string, xMLControl.getDouble(string));
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("boolean")) {
                    oSPControl.setValue(string, xMLControl.getBoolean(string));
                    continue;
                }
                oSPControl.setValue(string, xMLControl.getObject(string));
            }
            oSPControl.table.setLockValues(false);
            return object;
        }
    }
}

