/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.twobody;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.numerics.ODE;

public class Helium
implements Drawable,
ODE {
    int pixRadius = 6;
    double[] state = new double[9];

    public double[] getState() {
        return this.state;
    }

    public void getRate(double[] dArray, double[] dArray2) {
        double d = dArray[4] - dArray[0];
        double d2 = dArray[6] - dArray[2];
        double d3 = d * d + d2 * d2;
        double d4 = Math.sqrt(d3) * d3;
        dArray2[0] = dArray[1];
        dArray2[2] = dArray[3];
        double d5 = dArray[0] * dArray[0] + dArray[2] * dArray[2];
        double d6 = d5 * Math.sqrt(d5);
        dArray2[1] = -2.0 * dArray[0] / d6 - d / d4;
        dArray2[3] = -2.0 * dArray[2] / d6 - d2 / d4;
        dArray2[4] = dArray[5];
        dArray2[6] = dArray[7];
        d5 = dArray[4] * dArray[4] + dArray[6] * dArray[6];
        d6 = d5 * Math.sqrt(d5);
        dArray2[5] = -2.0 * dArray[4] / d6 + d / d4;
        dArray2[7] = -2.0 * dArray[6] / d6 + d2 / d4;
        dArray2[8] = 1.0;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.xToPix(this.state[0]) - this.pixRadius;
        int n2 = drawingPanel.yToPix(this.state[2]) - this.pixRadius;
        graphics.setColor(Color.red);
        graphics.fillOval(n, n2, 2 * this.pixRadius, 2 * this.pixRadius);
        n = drawingPanel.xToPix(this.state[4]) - this.pixRadius;
        n2 = drawingPanel.yToPix(this.state[6]) - this.pixRadius;
        graphics.setColor(Color.green);
        graphics.fillOval(n, n2, 2 * this.pixRadius, 2 * this.pixRadius);
    }
}

