/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.twobody;

import java.awt.Color;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.AnimationControl;
import org.opensourcephysics.davidson.twobody.Helium;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Trail;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.ode.MultistepSolvers;

public class HeliumApp
extends AbstractSimulation {
    Thread animationThread;
    PlottingPanel plottingPanel = new PlottingPanel("X", "Y", null);
    DrawingFrame drawingFrame = new DrawingFrame("Classical Model of Helium", this.plottingPanel);
    ODEAdaptiveSolver ode_method;
    Helium system = new Helium();
    Trail trail_1;
    Trail trail_2;
    double x1 = 3.0;
    double y1 = 0.0;
    double vx1 = 0.0;
    double vy1 = 0.4;
    double x2 = 1.0;
    double y2 = 0.0;
    double vx2 = 0.0;
    double vy2 = -1.0;
    double[] state;

    public HeliumApp() {
        this.ode_method = MultistepSolvers.Dopri853(this.system);
        this.state = this.system.getState();
        this.plottingPanel.setPreferredMinMax(-4.0, 4.0, -4.0, 4.0);
        this.plottingPanel.addDrawable(this.system);
        this.drawingFrame.setAnimated(true);
        this.addChildFrame(this.drawingFrame);
    }

    public void reset() {
        this.enableStepsPerDisplay(true);
        this.setStepsPerDisplay(5);
        this.x1 = 3.0;
        this.y1 = 0.0;
        this.vx1 = 0.0;
        this.vy1 = 0.4;
        this.x2 = 1.0;
        this.y2 = 0.0;
        this.vx2 = 0.0;
        this.vy2 = -1.0;
        this.control.setValue("x1", this.x1);
        this.control.setValue("x2", this.x2);
        this.control.setValue("vy1", this.vy1);
        this.control.setValue("vy2", this.vy2);
        this.control.setValue("dt", 0.1);
        this.state[0] = 3.0;
        this.state[1] = 0.0;
        this.state[2] = 0.0;
        this.state[3] = 0.4;
        this.state[4] = 1.0;
        this.state[5] = 0.0;
        this.state[6] = 0.0;
        this.state[7] = -1.0;
        this.state[8] = 0.0;
    }

    public void initialize() {
        this.state[0] = this.control.getDouble("x1");
        this.state[1] = this.vx1;
        this.state[2] = this.y1;
        this.state[3] = this.control.getDouble("vy1");
        this.state[4] = this.control.getDouble("x2");
        this.state[5] = this.vx2;
        this.state[6] = this.y2;
        this.state[7] = this.control.getDouble("vy2");
        this.state[8] = 0.0;
        this.ode_method.setStepSize(this.control.getDouble("dt"));
        this.trail_1 = new Trail();
        this.trail_1.color = new Color(255, 192, 192);
        this.trail_1.addPoint(this.state[0], this.state[2]);
        this.trail_2 = new Trail();
        this.trail_2.color = new Color(192, 155, 192);
        this.trail_2.addPoint(this.state[4], this.state[6]);
        this.plottingPanel.clear();
        this.plottingPanel.addDrawable(this.trail_1);
        this.plottingPanel.addDrawable(this.trail_2);
        this.plottingPanel.addDrawable(this.system);
        this.plottingPanel.repaint();
    }

    public void stopRunning() {
        this.control.setValue("x1", this.state[0]);
        this.vx1 = this.state[1];
        this.y1 = this.state[2];
        this.control.setValue("vy1", this.state[3]);
        this.control.setValue("x2", this.state[4]);
        this.vx2 = this.state[5];
        this.y2 = this.state[6];
        this.control.setValue("vy2", this.state[7]);
        this.plottingPanel.repaint();
    }

    public void clear() {
        if (this.trail_1 == null || this.trail_2 == null) {
            return;
        }
        this.plottingPanel.clear();
        this.trail_1.clear();
        this.trail_1.addPoint(this.state[0], this.state[2]);
        this.trail_2.clear();
        this.trail_2.addPoint(this.state[4], this.state[6]);
        this.plottingPanel.addDrawable(this.trail_1);
        this.plottingPanel.addDrawable(this.trail_2);
        this.plottingPanel.addDrawable(this.system);
        this.plottingPanel.repaint();
    }

    protected void doStep() {
        this.ode_method.step();
        this.trail_1.addPoint(this.state[0], this.state[2]);
        this.trail_2.addPoint(this.state[4], this.state[6]);
    }

    public static void main(String[] stringArray) {
        HeliumApp heliumApp = new HeliumApp();
        AnimationControl animationControl = AnimationControl.createApp(heliumApp, stringArray);
        animationControl.addButton("clear", "Clear Trails");
    }
}

