/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.DataTableModel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.SortDecorator;

public class DataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    final SortDecorator decorator;
    Map renderersByColumnName = new HashMap();
    DataTableModel dataTableModel;
    RowNumberRenderer rowNumberRenderer;
    int maximumFractionDigits = 3;
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    protected int labelColumnWidth = 40;

    public DataTable() {
        this(new DefaultDataTableModel());
    }

    public DataTable(DataTableModel dataTableModel) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(dataTableModel);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setForeground(Color.blue);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.decorator = new SortDecorator(this.getModel());
        this.setModel(this.decorator);
        JTableHeader jTableHeader2 = this.getTableHeader();
        jTableHeader2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl;
                boolean bl2 = bl = mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                if (!bl) {
                    TableColumnModel tableColumnModel = DataTable.this.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = DataTable.this.convertColumnIndexToModel(n);
                    DataTable.this.decorator.sort(n2);
                }
            }
        });
    }

    public void setMaximumFractionDigits(String string, int n) {
        this.renderersByColumnName.put(string, new PrecisionRenderer(n));
    }

    public void sort(int n) {
        this.decorator.sort(n);
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = n;
        this.setDefaultRenderer(Double.class, new PrecisionRenderer(n));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setRowNumberVisible(boolean bl) {
        if (this.dataTableModel.isRowNumberVisible() != bl) {
            if (bl && this.rowNumberRenderer == null) {
                this.rowNumberRenderer = new RowNumberRenderer(this);
            }
            this.dataTableModel.setRowNumberVisible(bl);
        }
    }

    public void setModel(DataTableModel dataTableModel) {
        super.setModel(dataTableModel);
        this.dataTableModel = dataTableModel;
    }

    public void setStride(TableModel tableModel, int n) {
        this.dataTableModel.setStride(tableModel, n);
    }

    public void setColumnVisible(TableModel tableModel, int n, boolean bl) {
        this.dataTableModel.setColumnVisible(tableModel, n, bl);
    }

    public boolean isRowNumberVisible() {
        return this.dataTableModel.isRowNumberVisible();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0 && this.dataTableModel.isRowNumberVisible()) {
            return this.rowNumberRenderer;
        }
        try {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer != null) {
                return tableCellRenderer;
            }
            for (String string : this.renderersByColumnName.keySet()) {
                if (!tableColumn.getHeaderValue().equals(string)) continue;
                return (TableCellRenderer)this.renderersByColumnName.get(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDefaultRenderer(this.getColumnClass(n2));
    }

    public void setRefreshDelay(int n) {
        if (n > 0) {
            this.refreshTimer.setDelay(n);
            this.refreshTimer.setInitialDelay(n);
        } else if (n <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = n;
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    DataTable.this.tableChanged(new TableModelEvent(DataTable.this.dataTableModel, -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tableChanged(new TableModelEvent(this.dataTableModel, -1));
    }

    public void add(TableModel tableModel) {
        this.dataTableModel.add(tableModel);
    }

    public void remove(TableModel tableModel) {
        this.dataTableModel.remove(tableModel);
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        public TableColumn getColumn(int n) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(n);
            }
            catch (Exception exception) {
                return new TableColumn();
            }
            String string = (String)tableColumn.getHeaderValue();
            if (string == null) {
                return tableColumn;
            }
            if (string.equals("row")) {
                tableColumn.setMaxWidth(DataTable.this.labelColumnWidth);
                tableColumn.setMinWidth(DataTable.this.labelColumnWidth);
                tableColumn.setResizable(false);
            }
            return tableColumn;
        }
    }

    private static class DataTableElement {
        TableModel tableModel;
        boolean[] columnVisibilities;
        int stride = 1;

        public DataTableElement(TableModel tableModel) {
            this.tableModel = tableModel;
        }

        public void setStride(int n) {
            this.stride = n;
        }

        public void setColumnVisible(int n, boolean bl) {
            this.ensureCapacity(n + 1);
            this.columnVisibilities[n] = bl;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean[] getColumnVisibilities() {
            return this.columnVisibilities;
        }

        public int getColumnCount() {
            int n = 0;
            int n2 = this.tableModel.getColumnCount();
            this.ensureCapacity(n2);
            int n3 = 0;
            while (n3 < n2) {
                boolean bl = this.columnVisibilities[n3];
                if (bl) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            return this.tableModel.getValueAt(n, n2);
        }

        public String getColumnName(int n) {
            return this.tableModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.tableModel.getColumnClass(n);
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        private void ensureCapacity(int n) {
            if (this.columnVisibilities == null) {
                this.columnVisibilities = new boolean[n * 3 / 2 + 1];
                Arrays.fill(this.columnVisibilities, true);
            } else if (this.columnVisibilities.length < n) {
                boolean[] blArray = this.columnVisibilities;
                this.columnVisibilities = new boolean[n * 3 / 2 + 1];
                System.arraycopy(blArray, 0, this.columnVisibilities, 0, blArray.length);
                Arrays.fill(this.columnVisibilities, blArray.length, this.columnVisibilities.length, true);
            }
        }
    }

    private static class DefaultDataTableModel
    implements DataTableModel {
        ArrayList dataTableElements = new ArrayList();
        boolean rowNumberVisible = false;

        private DefaultDataTableModel() {
        }

        public void setColumnVisible(TableModel tableModel, int n, boolean bl) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            dataTableElement.setColumnVisible(n, bl);
        }

        public void setStride(TableModel tableModel, int n) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            dataTableElement.setStride(n);
        }

        public void setRowNumberVisible(boolean bl) {
            this.rowNumberVisible = bl;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public boolean isRowNumberVisible() {
            return this.rowNumberVisible;
        }

        public String getColumnName(int n) {
            if (this.dataTableElements.size() == 0 && !this.rowNumberVisible) {
                return null;
            }
            if (this.rowNumberVisible && n == 0) {
                return "row";
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            String string = dataTableElement.getColumnName(modelFilterResult.column);
            return GUIUtils.removeSubscripting(string);
        }

        public int getRowCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.dataTableElements.size()) {
                DataTableElement dataTableElement = (DataTableElement)this.dataTableElements.get(n2);
                int n3 = dataTableElement.getStride();
                n = Math.max(n, (dataTableElement.getRowCount() + n3 - 1) / n3);
                ++n2;
            }
            return n;
        }

        public int getColumnCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.dataTableElements.size()) {
                DataTableElement dataTableElement = (DataTableElement)this.dataTableElements.get(n2);
                n += dataTableElement.getColumnCount();
                ++n2;
            }
            if (this.rowNumberVisible) {
                ++n;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            if (this.dataTableElements.size() == 0) {
                return null;
            }
            if (this.rowNumberVisible && n2 == 0) {
                return new Integer(n);
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n2);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            int n3 = dataTableElement.getStride();
            if ((n *= n3) >= dataTableElement.getRowCount()) {
                return null;
            }
            return dataTableElement.getValueAt(n, modelFilterResult.column);
        }

        public Class getColumnClass(int n) {
            if (this.rowNumberVisible && n == 0) {
                return Integer.class;
            }
            if (n == 0 && this.rowNumberVisible) {
                --n;
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            return dataTableElement.getColumnClass(modelFilterResult.column);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void remove(TableModel tableModel) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            this.dataTableElements.remove(dataTableElement);
        }

        public void clear() {
            this.dataTableElements.clear();
        }

        public void add(TableModel tableModel) {
            this.dataTableElements.add(new DataTableElement(tableModel));
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        private DataTableElement findElementContaining(TableModel tableModel) {
            int n = 0;
            while (n < this.dataTableElements.size()) {
                DataTableElement dataTableElement = (DataTableElement)this.dataTableElements.get(n);
                if (dataTableElement.tableModel == tableModel) {
                    return dataTableElement;
                }
                ++n;
            }
            return null;
        }
    }

    private static class ModelFilterResult {
        DataTableElement tableElement;
        int column;

        public ModelFilterResult(DataTableElement dataTableElement, int n) {
            this.tableElement = dataTableElement;
            this.column = n;
        }

        public static ModelFilterResult find(boolean bl, ArrayList arrayList, int n) {
            if (bl) {
                --n;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < arrayList.size()) {
                DataTableElement dataTableElement = (DataTableElement)arrayList.get(n3);
                int n4 = dataTableElement.getColumnCount();
                if ((n2 += n4) > n) {
                    int n5 = n4 + n - n2;
                    boolean[] blArray = dataTableElement.getColumnVisibilities();
                    int n6 = 0;
                    while (n6 < n) {
                        if (!blArray[n6]) {
                            ++n5;
                        }
                        ++n6;
                    }
                    return new ModelFilterResult(dataTableElement, n5);
                }
                ++n3;
            }
            return null;
        }
    }

    private static class PrecisionRenderer
    extends DefaultTableCellRenderer {
        NumberFormat numberFormat = NumberFormat.getInstance();

        public PrecisionRenderer(int n) {
            this.numberFormat.setMaximumFractionDigits(n);
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object object) {
            this.setText(object == null ? "" : this.numberFormat.format(object));
        }

        public void setPrecision(int n) {
            this.numberFormat.setMaximumFractionDigits(n);
        }
    }

    private static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        public RowNumberRenderer(JTable jTable) {
            this.table = jTable;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(PANEL_BACKGROUND);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.isRowSelected(n)) {
                int[] nArray = jTable.getSelectedColumns();
                if (nArray.length == 1 && jTable.convertColumnIndexToModel(nArray[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(object.toString());
            return this;
        }
    }
}

