/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.AbstractTrail;
import org.opensourcephysics.display.DrawingPanel;

public class Trail
extends AbstractTrail {
    GeneralPath generalPath = new GeneralPath();
    boolean connected = true;

    public synchronized void addPoint(double d, double d2) {
        if (this.closed) {
            throw new IllegalStateException("Cannot add points to a closed trail.");
        }
        if (!this.connected || this.numpts == 0) {
            this.generalPath.moveTo((float)d, (float)d2);
        }
        this.generalPath.lineTo((float)d, (float)d2);
        this.xmin = Math.min(this.xmin, d);
        this.xmax = Math.max(this.xmax, d);
        this.ymin = Math.min(this.ymin, d2);
        this.ymax = Math.max(this.ymax, d2);
        ++this.numpts;
    }

    public synchronized void moveToPoint(double d, double d2) {
        this.generalPath.moveTo((float)d, (float)d2);
        this.xmin = Math.min(this.xmin, d);
        this.xmax = Math.max(this.xmax, d);
        this.ymin = Math.min(this.ymin, d2);
        this.ymax = Math.max(this.ymax, d2);
        ++this.numpts;
    }

    public void closeTrail() {
        this.closed = true;
        this.generalPath.closePath();
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void clear() {
        this.closed = false;
        this.numpts = 0;
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.generalPath.reset();
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.numpts == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
        Shape shape = this.generalPath.createTransformedShape(drawingPanel.getPixelTransform());
        if (this.drawingStroke != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.drawingStroke);
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.draw(shape);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Trail trail = (Trail)object;
            xMLControl.setValue("connected", trail.connected);
            xMLControl.setValue("color", trail.color);
            xMLControl.setValue("number of pts", trail.numpts);
            xMLControl.setValue("general path", trail.generalPath);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Trail();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Trail trail = (Trail)object;
            trail.connected = xMLControl.getBoolean("connected");
            trail.color = (Color)xMLControl.getObject("color");
            trail.numpts = xMLControl.getInt("number of pts");
            trail.generalPath = (GeneralPath)xMLControl.getObject("general path");
            return object;
        }
    }
}

