/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.Calculation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.ejs.EjsRes;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.ParsedEjsControl;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.VideoTool;

public class EjsControlFrame
extends ParsedEjsControl
implements RootPaneContainer,
MainFrame {
    static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Tool reply;
    protected JMenuItem[] languageItems;
    protected JMenuItem translateItem;
    protected JMenuItem snapshotItem;
    protected JMenuItem videoItem;
    protected JMenuItem clearItem;
    protected JMenu languageMenu;
    EjsFrame mainFrame = new EjsFrame();
    DrawingPanel defaultDrawingPanel;
    protected JFrame messageFrame = new JFrame(EjsRes.getString("EjsControlFrame.Messages_frame_title"));
    TextArea messageArea = new TextArea(20, 20);
    Object model;
    JMenuBar menuBar;
    protected volatile XMLControlElement xmlDefault = null;
    protected PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    protected OSPApplication app;

    public EjsControlFrame(Object object) {
        this(object, "name=controlFrame;title=Control Frame;location=400,0;layout=border;exit=false; visible=true");
    }

    public EjsControlFrame(Object object, String string) {
        super(object);
        this.mainFrame.addChildFrame(this.messageFrame);
        this.model = object;
        this.mainFrame.setName("controlFrame");
        this.addObject(this.mainFrame, "Frame", string);
        this.createMenuBar();
        if (OSPRuntime.appletMode) {
            this.mainFrame.setDefaultCloseOperation(1);
        }
        this.messageFrame.getContentPane().add(this.messageArea);
        this.messageFrame.setSize(300, 175);
        this.reply = new Tool(){

            public void send(Job job, Tool tool) throws RemoteException {
                if (EjsControlFrame.this.defaultDrawingPanel == null) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement();
                try {
                    xMLControlElement.readXML(job.getXML());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ArrayList arrayList = EjsControlFrame.this.defaultDrawingPanel.getObjectOfClass(Dataset.class);
                block2: for (Dataset dataset : xMLControlElement.getObjects(Dataset.class)) {
                    int n = dataset.getID();
                    int n2 = 0;
                    int n3 = arrayList.size();
                    while (n2 < n3) {
                        if (((Dataset)arrayList.get(n2)).getID() == n) {
                            XMLControlElement xMLControlElement2 = new XMLControlElement(dataset);
                            Dataset.getLoader().loadObject(xMLControlElement2, arrayList.get(n2));
                            continue block2;
                        }
                        ++n2;
                    }
                }
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        };
    }

    public void addChildFrame(JFrame jFrame) {
        if (this.mainFrame == null || jFrame == null) {
            return;
        }
        this.mainFrame.addChildFrame(jFrame);
    }

    public void clearChildFrames() {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.clearChildFrames();
    }

    public Collection getChildFrames() {
        return this.mainFrame.getChildFrames();
    }

    public OSPFrame getMainFrame() {
        return this.mainFrame;
    }

    public OSPFrame getFrame() {
        return this.mainFrame;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.mainFrame.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(EjsRes.getString("EjsControlFrame.File_menu"));
        if (OSPRuntime.applet == null) {
            this.menuBar.add(jMenu);
        }
        JMenuItem jMenuItem = new JMenuItem(EjsRes.getString("EjsControlFrame.Read_menu_item"));
        this.clearItem = new JMenuItem(EjsRes.getString("EjsControlFrame.Clear_menu_item"));
        this.clearItem.setEnabled(false);
        JMenuItem jMenuItem2 = new JMenuItem(EjsRes.getString("EjsControlFrame.SaveAs_menu_item"));
        JMenuItem jMenuItem3 = new JMenuItem(EjsRes.getString("EjsControlFrame.Inspect_menu_item"));
        JMenuItem jMenuItem4 = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
        JMenuItem jMenuItem5 = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
        JMenu jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(this.clearItem);
        jMenu.add(jMenu2);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.loadXML((String)null);
                EjsControlFrame.this.support.firePropertyChange("xmlDefault", null, EjsControlFrame.this.xmlDefault);
                EjsControlFrame.this.mainFrame.repaint();
            }
        });
        this.clearItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.clearDefaultXML();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.saveXML();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.inspectXML();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(EjsControlFrame.this.mainFrame);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PrintUtils.saveComponentAsEPS(EjsControlFrame.this.mainFrame);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.loadDisplayMenu();
        this.loadToolsMenu();
        JMenu jMenu3 = new JMenu(EjsRes.getString("EjsControlFrame.Help_menu"));
        this.menuBar.add(jMenu3);
        JMenuItem jMenuItem6 = new JMenuItem(EjsRes.getString("EjsControlFrame.About_menu_item"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPRuntime.showAboutDialog(EjsControlFrame.this.getMainFrame());
            }
        });
        jMenu3.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(EjsRes.getString("EjsControlFrame.System_menu_item"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlUtils.showSystemProperties(true);
            }
        });
        jMenu3.add(jMenuItem7);
        jMenu3.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.LogToFile_check_box"));
        jCheckBoxMenuItem.setSelected(false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                OSPLog.getOSPLog().setLogToFile(jCheckBoxMenuItem.isSelected());
            }
        });
        if (OSPRuntime.applet == null) {
            jMenu3.add(jCheckBoxMenuItem);
        }
        JMenuItem jMenuItem8 = new JMenuItem(EjsRes.getString("EjsControlFrame.MessageLog_menu_item"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog.getOSPLog().setVisible(true);
            }
        });
        jMenu3.add(jMenuItem8);
        this.menuBar.add(jMenu3);
    }

    protected JMenu loadToolsMenu() {
        JMenuBar jMenuBar = this.mainFrame.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DatasetTool_menu_item"));
        jMenu.add(jMenuItem);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.opensourcephysics.tools.DataTool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            jMenuItem.setEnabled(false);
        }
        final Class<?> clazz2 = clazz;
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = clazz2.getMethod("getTool", null);
                    Tool tool = (Tool)method.invoke(null, null);
                    tool.send(new LocalJob(EjsControlFrame.this.defaultDrawingPanel), EjsControlFrame.this.reply);
                    ((JFrame)((Object)tool)).setVisible(true);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        });
        this.snapshotItem = new JMenuItem("Snapshot");
        this.snapshotItem.setEnabled(false);
        if (OSPRuntime.applet == null) {
            jMenu.add(this.snapshotItem);
        }
        this.snapshotItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool snapshotTool = SnapshotTool.getTool();
                if (EjsControlFrame.this.defaultDrawingPanel != null) {
                    snapshotTool.saveImage(null, EjsControlFrame.this.defaultDrawingPanel);
                } else {
                    snapshotTool.saveImage(null, EjsControlFrame.this.getContentPane());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Video Capture");
        if (OSPRuntime.applet == null) {
            jMenu.add(jMenuItem2);
        }
        Class<?> clazz3 = null;
        try {
            clazz3 = Class.forName("org.opensourcephysics.tools.VideoCaptureTool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            jMenuItem2.setEnabled(false);
        }
        final Class<?> clazz4 = clazz3;
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EjsControlFrame.this.defaultDrawingPanel.getVideoTool() == null) {
                    try {
                        Method method = clazz4.getMethod("getTool", null);
                        Tool tool = (Tool)method.invoke(null, null);
                        EjsControlFrame.this.defaultDrawingPanel.setVideoTool((VideoTool)((Object)tool));
                        ((VideoTool)((Object)tool)).setVisible(true);
                        ((VideoTool)((Object)tool)).clear();
                    }
                    catch (Exception exception) {}
                } else {
                    EjsControlFrame.this.defaultDrawingPanel.getVideoTool().setVisible(true);
                }
            }
        });
        return jMenu;
    }

    protected void loadDisplayMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(EjsRes.getString("EjsControlFrame.Display_menu"));
        this.menuBar.add(jMenu);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EjsControlFrame.this.refreshGUI();
            }
        });
        this.languageMenu = new JMenu();
        this.languageMenu.setText(EjsRes.getString("EjsControlFrame.Language"));
        this.translateItem = new JMenuItem();
        this.translateItem.setText(EjsRes.getString("EjsControlFrame.Translate"));
        if (OSPRuntime.translator != null) {
            this.translateItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPRuntime.translator.showProperties(EjsControlFrame.this.model.getClass());
                    if (OSPRuntime.translator instanceof Hidable) {
                        ((Hidable)((Object)OSPRuntime.translator)).setKeepHidden(false);
                    }
                    OSPRuntime.translator.setVisible(true);
                }
            });
        }
        this.translateItem.setEnabled(OSPRuntime.translator != null);
        this.languageMenu.add((Component)this.translateItem, 0);
        final Locale[] localeArray = OSPRuntime.getInstalledLocales();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                OSPLog.finest("setting language to " + string);
                int n = 0;
                while (n < localeArray.length) {
                    if (string.equals(localeArray[n].getDisplayName())) {
                        ToolsRes.setLocale(localeArray[n]);
                        return;
                    }
                    ++n;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[localeArray.length];
        int n = 0;
        while (n < localeArray.length) {
            this.languageItems[n] = new JRadioButtonMenuItem(localeArray[n].getDisplayName(localeArray[n]));
            this.languageItems[n].setActionCommand(localeArray[n].getDisplayName());
            this.languageItems[n].addActionListener(abstractAction);
            this.languageMenu.add(this.languageItems[n]);
            buttonGroup.add(this.languageItems[n]);
            ++n;
        }
        n = 0;
        while (n < localeArray.length) {
            if (localeArray[n].getLanguage().equals(ToolsRes.getLanguage())) {
                this.languageItems[n].setSelected(true);
            }
            ++n;
        }
        jMenu.add(this.languageMenu);
        JMenu jMenu2 = new JMenu(EjsRes.getString("EjsControlFrame.Font_menu"));
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(EjsRes.getString("EjsControlFrame.IncreaseFontSize_menu_item"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelUp();
            }
        });
        jMenu2.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(EjsRes.getString("EjsControlFrame.DecreaseFontSize_menu_item"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelDown();
            }
        });
        jMenu2.add(jMenuItem2);
        JMenu jMenu3 = new JMenu(EjsRes.getString("EjsControlFrame.AntiAlias_menu"));
        jMenu.add(jMenu3);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.Text_check_box"), false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.defaultDrawingPanel.setAntialiasTextOn(jCheckBoxMenuItem.isSelected());
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        });
        jMenu3.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.Drawing_check_box"), false);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.defaultDrawingPanel.setAntialiasShapeOn(jCheckBoxMenuItem2.isSelected());
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        });
        jMenu2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jMenuItem2.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        jMenu3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (EjsControlFrame.this.defaultDrawingPanel == null) {
                    jCheckBoxMenuItem.setEnabled(false);
                    jCheckBoxMenuItem2.setEnabled(false);
                } else {
                    jCheckBoxMenuItem.setEnabled(true);
                    jCheckBoxMenuItem.setEnabled(true);
                    jCheckBoxMenuItem.setSelected(EjsControlFrame.this.defaultDrawingPanel.isAntialiasTextOn());
                    jCheckBoxMenuItem2.setSelected(EjsControlFrame.this.defaultDrawingPanel.isAntialiasShapeOn());
                }
            }
        });
        jMenu3.add(jCheckBoxMenuItem2);
        this.menuBar.add(jMenu);
    }

    public int printToGraphics(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        if (graphics == null) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.mainFrame.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.mainFrame.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.scale(d3, d3);
        this.mainFrame.paint(graphics);
        return 0;
    }

    protected void refreshGUI() {
        this.createMenuBar();
        this.mainFrame.pack();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void println(String string) {
        this.print(String.valueOf(string) + "\n");
    }

    public void println() {
        this.print("\n");
    }

    public void print(final String string) {
        if (string == null) {
            return;
        }
        this.messageFrame.setVisible(true);
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            this.messageArea.append(string);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                EjsControlFrame.this.messageArea.append(string);
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void clearMessages() {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            this.messageArea.setText("");
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                EjsControlFrame.this.messageArea.setText("");
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private void appendMessageX(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                EjsControlFrame.this.messageArea.append(string);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void calculationDone(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        super.calculationDone(string);
    }

    public void render() {
    }

    public ControlElement addObject(Object object, String string, String string2) {
        if (object instanceof DrawingPanel) {
            this.defaultDrawingPanel = (DrawingPanel)object;
            if (this.snapshotItem != null) {
                this.snapshotItem.setEnabled(true);
            }
            if (this.videoItem != null) {
                this.videoItem.setEnabled(true);
            }
        }
        return super.addObject(object, string, string2);
    }

    public void clearData() {
        if (this.defaultDrawingPanel != null) {
            ArrayList arrayList = this.defaultDrawingPanel.getDrawables(Dataset.class);
            for (AbstractTableModel abstractTableModel : arrayList) {
                ((Dataset)abstractTableModel).clear();
            }
            arrayList = this.defaultDrawingPanel.getDrawables(DatasetManager.class);
            for (AbstractTableModel abstractTableModel : arrayList) {
                ((DatasetManager)abstractTableModel).clear();
            }
            this.defaultDrawingPanel.invalidateImage();
        }
    }

    public void clearDataAndRepaint() {
        this.clearData();
        if (this.defaultDrawingPanel != null) {
            this.defaultDrawingPanel.repaint();
        }
    }

    public Container getTopLevelAncestor() {
        return this.mainFrame;
    }

    public JRootPane getRootPane() {
        return this.mainFrame.getRootPane();
    }

    public Container getContentPane() {
        return this.mainFrame.getContentPane();
    }

    public void setContentPane(Container container) {
        this.mainFrame.setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.mainFrame.getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.mainFrame.setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.mainFrame.getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.mainFrame.setGlassPane(component);
    }

    public void parseXMLMenu(String string) {
        System.out.println("The parseXMLMenu method has been disabled to reduce the size OSP jar files.");
    }

    public void saveXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = jFileChooser.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(EjsRes.getString("EjsControlFrame.ReplaceExisting_dialog")) + file.getName() + EjsRes.getString("EjsControlFrame.question_mark"), EjsRes.getString("EjsControlFrame.RepalceFile_dialog_message"), 1)) != 0) {
                return;
            }
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string = XML.getRelativePath(file.getAbsolutePath());
            if (string == null || string.trim().equals("")) {
                return;
            }
            int n3 = string.toLowerCase().lastIndexOf(".xml");
            if (n3 != string.length() - 4) {
                string = String.valueOf(string) + ".xml";
            }
            XMLControlElement xMLControlElement = new XMLControlElement(this.getOSPApp());
            xMLControlElement.write(string);
        }
    }

    public OSPApplication getOSPApp() {
        if (this.app == null) {
            this.app = new OSPApplication(this, this.model);
        }
        return this.app;
    }

    public void loadDefaultXML() {
        if (this.xmlDefault != null) {
            this.xmlDefault.loadObject(this.getOSPApp());
            this.clearItem.setEnabled(true);
        }
    }

    public void clearDefaultXML() {
        if (this.xmlDefault == null || this.model == null) {
            return;
        }
        this.xmlDefault = null;
        this.clearItem.setEnabled(false);
        if (this.model instanceof Calculation) {
            ((Calculation)this.model).resetCalculation();
            ((Calculation)this.model).calculate();
        } else if (this.model instanceof Animation) {
            ((Animation)this.model).stopAnimation();
            ((Animation)this.model).resetAnimation();
            ((Animation)this.model).initializeAnimation();
        }
        GUIUtils.repaintOSPFrames();
    }

    public void loadXML(String string) {
        if (string == null || string.trim().equals("")) {
            this.loadXML();
            return;
        }
        XMLControlElement xMLControlElement = null;
        try {
            xMLControlElement = new XMLControlElement(string);
        }
        catch (Exception exception) {
            System.out.println("XML file not loaded: " + string);
            System.out.println("EjsControlFrame Exception: " + exception);
            return;
        }
        this.loadXML(xMLControlElement, false);
    }

    public void loadXML(XMLControlElement xMLControlElement, boolean bl) {
        if (xMLControlElement == null) {
            OSPLog.finer("XML not found in EjsControlFrame loadXML method.");
            return;
        }
        if (OSPApplication.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            XMLControlElement xMLControlElement2 = (XMLControlElement)xMLControlElement.getChildControl("model");
            if (xMLControlElement2 == null) {
                JOptionPane.showMessageDialog(this.mainFrame, "XML Control not found.", "Data not loaded.", 2);
                return;
            }
            Class clazz = xMLControlElement2.getObjectClass();
            if (clazz == null) {
                JOptionPane.showMessageDialog(this.mainFrame, "Model specified in file not found.", "Data not loaded.", 2);
                return;
            }
            boolean bl2 = XML.getLoader(clazz).getClass() == XML.getLoader(this.model.getClass()).getClass();
            boolean bl3 = bl = bl || clazz == this.model.getClass() || clazz.isAssignableFrom(this.model.getClass()) && bl2;
            if (!bl) {
                JOptionPane.showMessageDialog(this.mainFrame, "Data not loaded. Data was created by: " + clazz + ".", "Incompatible data file.", 2);
                return;
            }
            this.app = this.getOSPApp();
            this.app.setCompatibleModel(bl);
            xMLControlElement.loadObject(this.getOSPApp());
            this.app.setCompatibleModel(false);
            if (this.model.getClass() == this.app.getLoadedModelClass()) {
                this.xmlDefault = xMLControlElement;
                this.clearItem.setEnabled(true);
            } else if (this.app.getLoadedModelClass() != null) {
                this.xmlDefault = new XMLControlElement(this.getOSPApp());
                this.clearItem.setEnabled(true);
            } else {
                this.xmlDefault = null;
                this.clearItem.setEnabled(false);
            }
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, "Data for: " + xMLControlElement.getObjectClass() + ".", "OSP Application data not found.", 2);
        }
    }

    public void loadXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.loadXML(XML.getRelativePath(string));
        }
    }

    public void inspectXML() {
        XMLControlElement xMLControlElement = new XMLControlElement(this.getOSPApp());
        XMLTreePanel xMLTreePanel = new XMLTreePanel(xMLControlElement);
        JDialog jDialog = new JDialog(null, true);
        jDialog.setContentPane(xMLTreePanel);
        jDialog.setSize(new Dimension(600, 300));
        jDialog.setVisible(true);
    }

    public void loadXML(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.loadXML(stringArray[n]);
                ++n;
            }
        }
    }

    class EjsFrame
    extends OSPFrame
    implements MainFrame {
        EjsFrame() {
        }

        public OSPFrame getMainFrame() {
            return this;
        }

        public void render() {
            EjsControlFrame.this.render();
        }

        public void clearData() {
            EjsControlFrame.this.clearData();
        }

        public void clearDataAndRepaint() {
            EjsControlFrame.this.clearDataAndRepaint();
        }

        public void dispose() {
            EjsControlFrame.this.messageFrame.setVisible(false);
            EjsControlFrame.this.messageFrame.dispose();
            super.dispose();
        }

        public void invalidateImage() {
            if (EjsControlFrame.this.defaultDrawingPanel != null) {
                EjsControlFrame.this.defaultDrawingPanel.invalidateImage();
            }
        }

        public OSPApplication getOSPApp() {
            return EjsControlFrame.this.getOSPApp();
        }
    }
}

