/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Container;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsControlFrame;

public class EjsSimulationControl
extends EjsControlFrame {
    protected Simulation model;
    protected DrawingPanel drawingPanel;
    protected JPanel controlPanel;

    public EjsSimulationControl(Simulation simulation, DrawingFrame drawingFrame, String[] stringArray) {
        super(simulation, "name=controlFrame;title=OSP Simulation;location=400,0;layout=border;exit=true; visible=false");
        this.model = simulation;
        this.addTarget("control", this);
        this.addTarget("model", simulation);
        if (drawingFrame != null) {
            this.getMainFrame().setAnimated(drawingFrame.isAnimated());
            this.getMainFrame().setAutoclear(drawingFrame.isAutoclear());
            this.getMainFrame().setBackground(drawingFrame.getBackground());
            this.getMainFrame().setTitle(drawingFrame.getTitle());
            this.drawingPanel = drawingFrame.getDrawingPanel();
            this.addObject(this.drawingPanel, "Panel", "name=drawingPanel; parent=controlFrame; position=center");
            drawingFrame.setDrawingPanel(null);
            drawingFrame.dispose();
        }
        this.add("Panel", "name=controlPanel; parent=controlFrame; layout=border; position=south");
        this.add("Panel", "name=buttonPanel;position=west;parent=controlPanel;layout=flow");
        this.add("Button", "parent=buttonPanel;tooltip=Start and stop simulation;image=/org/opensourcephysics/resources/controls/images/play.gif; action=control.runSimulation();name=runButton");
        this.add("Button", "parent=buttonPanel;tooltip=Step simulation;image=/org/opensourcephysics/resources/controls/images/step.gif; action=control.stepSimulation()");
        this.add("Button", "parent=buttonPanel; tooltip=Reset simulation;image=/org/opensourcephysics/resources/controls/images/reset.gif; action=control.resetSimulation()");
        this.controlPanel = (JPanel)this.getElement("controlPanel").getComponent();
        this.controlPanel.setBorder(new EtchedBorder());
        this.customize();
        simulation.setControl(this);
        this.initialize();
        this.loadXML(stringArray);
        Container container = (Container)this.getElement("controlFrame").getComponent();
        if (!OSPRuntime.appletMode) {
            container.setVisible(true);
        }
        if (simulation instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)((Object)simulation));
        }
        this.getMainFrame().pack();
        this.getMainFrame().doLayout();
        GUIUtils.showDrawingAndTableFrames();
    }

    protected void customize() {
    }

    public void render() {
        if (this.drawingPanel != null) {
            this.drawingPanel.render();
        }
    }

    public void clearDefaultXML() {
        if (this.xmlDefault == null || this.model == null) {
            return;
        }
        this.xmlDefault = null;
        this.clearItem.setEnabled(false);
        this.resetSimulation();
    }

    public void resetSimulation() {
        this.model.stopAnimation();
        this.messageArea.setText("");
        GUIUtils.clearDrawingFrameData(true);
        this.model.resetAnimation();
        if (this.xmlDefault != null) {
            this.xmlDefault.loadObject(this.getOSPApp());
        } else {
            this.initialize();
        }
        this.getControl("runButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/play.gif");
        GUIUtils.showDrawingAndTableFrames();
    }

    public void stepSimulation() {
        if (this.model.isRunning()) {
            this.model.stopAnimation();
        }
        this.getControl("runButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/play.gif");
        this.model.stepAnimation();
        GUIUtils.repaintAnimatedFrames();
    }

    public void runSimulation() {
        if (this.model.isRunning()) {
            this.model.stopSimulation();
            this.getControl("runButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/play.gif");
        } else {
            this.getControl("runButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/pause.gif");
            this.model.startSimulation();
        }
    }

    public void initialize() {
        this.model.stopAnimation();
        this.getControl("runButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/play.gif");
        GUIUtils.clearDrawingFrameData(true);
        this.model.initializeAnimation();
        GUIUtils.showDrawingAndTableFrames();
    }
}

