/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.border.EmptyBorder;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlMenu;
import org.colos.ejs.library.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlMenuBar
extends ControlContainer {
    protected JMenuBar menubar;
    private Rectangle myBorder = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.menubar = new JMenuBar();
        return this.menubar;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("borderPainted");
            infoList.add("border");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("borderPainted")) {
            return "boolean";
        }
        if (string.equals("border")) {
            return "Margins|Object";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.menubar.setBorderPainted(value.getBoolean());
                break;
            }
            case 1: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myBorder) break;
                this.menubar.setBorder(new EmptyBorder(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                this.myBorder = rectangle;
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.menubar.setBorderPainted(true);
                break;
            }
            case 1: {
                this.menubar.setBorder(null);
                this.myBorder = null;
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "true";
            }
            case 1: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }

    @Override
    public void add(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenu)) {
            return;
        }
        this.children.add(controlElement);
        this.menubar.add((JMenu)controlElement.getVisual());
        if (this.getControlWindow() != null) {
            this.getControlWindow().adjustSize();
        }
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenu)) {
            return;
        }
        this.children.remove(controlElement);
        this.menubar.remove(controlElement.getVisual());
        if (this.getControlWindow() != null) {
            this.getControlWindow().adjustSize();
        }
    }
}

