/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.VideoClip;

public class StepperClipControl
extends ClipControl {
    private Timer timer;
    private double frameDuration = 100.0;
    private boolean playing = false;
    private boolean readyToStep = true;
    private boolean stepDisplayed = true;
    private int minDelay = 10;
    private int maxDelay = 5000;

    protected StepperClipControl(VideoClip videoClip) {
        super(videoClip);
        videoClip.addPropertyChangeListener(this);
        if (this.video != null) {
            this.video.addPropertyChangeListener(this);
            if (this.video.getFrameCount() > 1) {
                double d = this.video.getFrameTime(this.video.getStartFrameNumber());
                double d2 = this.video.getFrameTime(this.video.getEndFrameNumber());
                int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
                if (n != 0 && d2 - d > 0.0) {
                    this.frameDuration = (int)(d2 - d) / n;
                }
            }
        }
        int n = (int)(this.frameDuration * (double)this.clip.getStepSize());
        n = Math.min(n, this.maxDelay);
        n = Math.max(n, this.minDelay);
        this.timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepperClipControl.this.readyToStep = true;
                StepperClipControl.this.step();
            }
        });
        this.timer.setRepeats(false);
    }

    public void play() {
        if (this.clip.getStepCount() == 1) {
            return;
        }
        this.playing = true;
        this.readyToStep = true;
        if (this.stepNumber == this.clip.getStepCount() - 1) {
            this.setStepNumber(0);
        } else {
            this.step();
        }
        this.support.firePropertyChange("playing", null, new Boolean(true));
    }

    public void stop() {
        this.timer.stop();
        this.readyToStep = true;
        this.stepDisplayed = true;
        this.playing = false;
        this.support.firePropertyChange("playing", null, new Boolean(false));
    }

    public void step() {
        if (this.stepNumber >= this.clip.getStepCount() - 1 && !this.looping) {
            this.stop();
        } else if (this.stepDisplayed && (!this.playing || this.readyToStep)) {
            this.stepDisplayed = false;
            if (this.playing) {
                this.readyToStep = false;
                this.timer.restart();
            }
            if (this.stepNumber < this.clip.getStepCount() - 1) {
                this.setStepNumber(this.stepNumber + 1);
            } else if (this.looping) {
                this.setStepNumber(0);
            }
        }
    }

    public void back() {
        if (this.stepDisplayed && this.stepNumber > 0) {
            this.stepDisplayed = false;
            this.setStepNumber(this.stepNumber - 1);
        }
    }

    public void setStepNumber(int n) {
        n = Math.max(0, n);
        n = Math.min(this.clip.getStepCount() - 1, n);
        if (n == this.stepNumber && this.clip.stepToFrame(n) == this.getFrameNumber()) {
            return;
        }
        if (this.video == null) {
            super.setStepNumber(n);
            this.stepDisplayed = true;
            this.support.firePropertyChange("stepnumber", null, new Integer(n));
        } else {
            final int n2 = this.clip.stepToFrame(n);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (StepperClipControl.this.video.getFrameNumber() == n2) {
                        StepperClipControl.this.stepDisplayed = true;
                    } else {
                        StepperClipControl.this.video.setFrameNumber(n2);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setRate(double d) {
        if (d == 0.0 || d == this.rate) {
            return;
        }
        this.rate = Math.abs(d);
        int n = (int)(this.frameDuration * (double)this.clip.getStepSize() / this.rate);
        n = Math.min(n, this.maxDelay);
        n = Math.max(n, this.minDelay);
        this.timer.setInitialDelay(n);
        this.support.firePropertyChange("rate", null, new Double(this.rate));
    }

    public double getMeanFrameDuration() {
        return this.frameDuration;
    }

    public void setFrameDuration(double d) {
        if (d == 0.0 || d == this.frameDuration) {
            return;
        }
        this.frameDuration = Math.abs(d);
        int n = (int)(this.frameDuration * (double)this.clip.getStepSize() / this.rate);
        n = Math.min(n, this.maxDelay);
        n = Math.max(n, this.minDelay);
        this.timer.setInitialDelay(n);
        this.support.firePropertyChange("frameduration", null, new Double(this.frameDuration));
    }

    public void setLooping(boolean bl) {
        if (bl == this.looping) {
            return;
        }
        this.looping = bl;
        this.support.firePropertyChange("looping", null, new Boolean(bl));
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public double getTime() {
        return (double)this.stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    public double getStepTime(int n) {
        return (double)n * this.frameDuration * (double)this.clip.getStepSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepsize")) {
            int n = (int)(this.frameDuration * (double)this.clip.getStepSize() / this.rate);
            n = Math.min(n, this.maxDelay);
            n = Math.max(n, this.minDelay);
            this.timer.setInitialDelay(n);
        } else if (string.equals("framenumber")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.stepDisplayed = true;
            if (n != this.frameNumber) {
                super.setFrameNumber(n);
                this.support.firePropertyChange("stepnumber", null, new Integer(this.stepNumber));
            }
            if (this.playing) {
                this.step();
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }
}

