/*
 * Decompiled with CFR 0.152.
 */
package users.berry.timberlake.astronomy.MoonPhases_pkg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.berry.timberlake.astronomy.MoonPhases_pkg.MoonPhasesSimulation;
import users.berry.timberlake.astronomy.MoonPhases_pkg.MoonPhasesView;

public class MoonPhases
extends Model {
    public MoonPhasesSimulation _simulation = null;
    public MoonPhasesView _view = null;
    public MoonPhases _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double ang = 0.0;
    public double theta;
    public double x;
    public double y;
    public double d = 10.0;
    public double rE = 0.8;
    public double rM = 0.4;
    public double angle;
    public double time = 0.0;
    public double tang;
    public double xobs;
    public double yobs;
    public double dspot = this.rE / 4.0;
    public int np = 100;
    public double[][] pl;
    public double[][] pd;
    public double[][] el;
    public double[][] ed;
    public double[][] cone;
    public double h1x;
    public double h1y;
    public double lhx;
    public double lhy;
    public double[][] pv;
    public boolean ShowMoon = true;
    public int transp;
    public Color color;
    public boolean observer = true;
    public boolean ShowMO = true;
    public boolean ShowLC = true;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static String _getEjsModel() {
        return "/users/berry/timberlake/astronomy/MoonPhases.xml";
    }

    public static String _getModelDirectory() {
        return "users/berry/timberlake/astronomy/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(653, 624);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/berry/timberlake/astronomy/MoonPhases/MoonPhases.html");
        hashSet.add("/users/berry/timberlake/astronomy/MoonPhases/FullMoon.jpg");
        hashSet.add("/users/berry/timberlake/astronomy/MoonPhases/MoonPhases.html");
        hashSet.add("/users/berry/timberlake/astronomy/MoonPhases/MoonPhases.jpg");
        hashSet.add("/users/berry/timberlake/astronomy/MoonPhases/MoonView.jpg");
        hashSet.add("/users/berry/timberlake/astronomy/MoonPhases/FullMoon.jpg");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/berry/timberlake/astronomy/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("/Users/ttimberlake/Developer/EJS_4.2.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("/Users/ttimberlake/Developer/EJS_4.2.7/bin/config/");
        }
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!MoonPhases._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        MoonPhases moonPhases = new MoonPhases(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!MoonPhases._common_initialization(stringArray)) {
            return null;
        }
        MoonPhases moonPhases = new MoonPhases("orbitFrame", jFrame, null, null, stringArray, true);
        return (JComponent)moonPhases._getView().getComponent("orbitFrame");
    }

    public MoonPhases() {
        this(null, null, null, null, null, false);
    }

    public MoonPhases(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public MoonPhases(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new MoonPhasesSimulation(this, string, frame, uRL, bl);
        this._view = (MoonPhasesView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.ang = 0.0;
        this.d = 10.0;
        this.rE = 0.8;
        this.rM = 0.4;
        this.time = 0.0;
        this.dspot = this.rE / 4.0;
        this.np = 100;
        this.pl = new double[this.np][2];
        this.pd = new double[this.np][2];
        this.el = new double[this.np][2];
        this.ed = new double[this.np][2];
        this.cone = new double[4][2];
        this.pv = new double[2 * this.np][2];
        this.ShowMoon = true;
        this.observer = true;
        this.ShowMO = true;
        this.ShowLC = true;
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._initializeSolvers();
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._evolution1();
        }
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.pl = null;
        this.pd = null;
        this.el = null;
        this.ed = null;
        this.cone = null;
        this.pv = null;
        System.gc();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Moon Mountain Init".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("MoonPhaseEvol".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
        }
        if ("MoonMountainRelations".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        for (int i = 0; i < this.np; ++i) {
            this.theta = (double)i * Math.PI / (double)(this.np - 1) - 1.5707963267948966;
            this.el[i][0] = this.rE * Math.cos(this.theta);
            this.el[i][1] = this.rE * Math.sin(this.theta);
            this.ed[i][0] = this.rE * Math.cos(this.theta + Math.PI);
            this.ed[i][1] = this.rE * Math.sin(this.theta + Math.PI);
        }
    }

    public void _evolution1() {
        this.ang += 0.008874555518615235;
        if (this.ang > Math.PI * 2) {
            this.ang -= Math.PI * 2;
        }
        this.time += 1.0;
        if (this.time > 24.0) {
            this.time -= 24.0;
        }
    }

    public void _constraints1() {
        int n;
        this.x = this.d * Math.cos(this.ang);
        this.y = this.d * Math.sin(this.ang);
        for (n = 0; n < this.np; ++n) {
            this.theta = (double)n * Math.PI / (double)(this.np - 1) - 1.5707963267948966;
            this.pl[n][0] = this.x + this.rM * Math.cos(this.theta);
            this.pl[n][1] = this.y + this.rM * Math.sin(this.theta);
            this.pd[n][0] = this.x + this.rM * Math.cos(this.theta + Math.PI);
            this.pd[n][1] = this.y + this.rM * Math.sin(this.theta + Math.PI);
        }
        if (this.y > 0.0) {
            for (n = 0; n < this.np; ++n) {
                this.theta = (double)n * Math.PI / (double)(this.np - 1) - 1.5707963267948966;
                this.pv[n][0] = Math.cos(this.ang) * Math.cos(this.theta);
                this.pv[n][1] = Math.sin(this.theta);
            }
            for (n = this.np; n < 2 * this.np; ++n) {
                this.theta = 1.5707963267948966 - (double)(n - this.np) * Math.PI / (double)(this.np - 1);
                this.pv[n][0] = -Math.cos(this.theta);
                this.pv[n][1] = Math.sin(this.theta);
            }
        } else {
            for (n = 0; n < this.np; ++n) {
                this.theta = (double)n * Math.PI / (double)(this.np - 1) + 1.5707963267948966;
                this.pv[n][0] = -Math.cos(this.theta);
                this.pv[n][1] = Math.sin(this.theta);
            }
            for (n = this.np; n < 2 * this.np; ++n) {
                this.theta = 4.71238898038469 - (double)(n - this.np) * Math.PI / (double)(this.np - 1);
                this.pv[n][0] = Math.cos(this.ang) * Math.cos(this.theta);
                this.pv[n][1] = Math.sin(this.theta);
            }
        }
        this.cone[0][0] = this.rE * Math.cos(this.ang - 1.5707963267948966);
        this.cone[0][1] = this.rE * Math.sin(this.ang - 1.5707963267948966);
        this.cone[1][0] = this.x + this.rM * Math.cos(this.ang - 1.5707963267948966);
        this.cone[1][1] = this.y + this.rM * Math.sin(this.ang - 1.5707963267948966);
        this.cone[2][0] = this.x - this.rM * Math.cos(this.ang - 1.5707963267948966);
        this.cone[2][1] = this.y - this.rM * Math.sin(this.ang - 1.5707963267948966);
        this.cone[3][0] = -this.rE * Math.cos(this.ang - 1.5707963267948966);
        this.cone[3][1] = -this.rE * Math.sin(this.ang - 1.5707963267948966);
        this.angle = 180.0 * this.ang / Math.PI;
        this.tang = (this.time - 12.0) * Math.PI / 12.0;
        this.xobs = this.rE * Math.cos(this.tang);
        this.yobs = this.rE * Math.sin(this.tang);
        this.h1x = this.xobs / 60.0 - 12.0 * Math.cos(this.tang + 1.5707963267948966);
        this.h1y = this.yobs / 60.0 - 12.0 * Math.sin(this.tang + 1.5707963267948966);
        this.lhx = 24.0 * Math.cos(this.tang + 1.5707963267948966);
        this.lhy = 24.0 * Math.sin(this.tang + 1.5707963267948966);
        this.transp = 230 - (int)(20.0 * Math.cos(this.ang));
        this.color = new Color(0, 0, 0, this.transp);
    }

    public double _method_for_orbitCircle_sizeX() {
        return 2.0 * this.d;
    }

    public double _method_for_orbitCircle_sizeY() {
        return 2.0 * this.d;
    }

    public double _method_for_angleSlider_maximum() {
        return Math.PI * 2;
    }

    public void _method_for_playButton_actionOn() {
        this._play();
    }

    public void _method_for_playButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }
}

