/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.drawing2d.ControlGroup2D;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.InterpretedValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionListener;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.numerics.Matrix2DTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlElement2D
extends ControlDrawable
implements InteractionListener {
    public static final int E2D_ADDED = 27;
    protected static final int POSITION_X = 0;
    protected static final int POSITION_Y = 1;
    protected static final int POSITION = 2;
    protected static final int SIZE_X = 3;
    protected static final int SIZE_Y = 4;
    protected static final int SIZE = 5;
    protected static final int SCALE_X = 6;
    protected static final int SCALE_Y = 7;
    protected static final int TRANSFORMATION = 8;
    protected static final int VISIBLE = 9;
    protected static final int LINE_COLOR = 10;
    protected static final int LINE_WIDTH = 11;
    protected static final int FILL_COLOR = 12;
    protected static final int DRAWING_FILL = 13;
    protected static final int DRAWING_LINES = 14;
    protected static final int ENABLED_POSITION = 15;
    protected static final int MOVES_GROUP = 16;
    protected static final int ENABLED_SIZE = 17;
    protected static final int RESIZES_GROUP = 18;
    protected static final int SENSITIVITY = 19;
    protected static final int PRESS_ACTION = 20;
    protected static final int DRAG_ACTION = 21;
    protected static final int RELEASE_ACTION = 22;
    protected static final int ENTERED_ACTION = 23;
    protected static final int EXITED_ACTION = 24;
    protected static final int MEASURED = 25;
    protected static final int EXTRA_COLOR = 26;
    public static final Color NULL_COLOR = ConstantParserUtil.NULL_COLOR;
    public static final double TO_RADIANS = Math.PI / 180;
    protected DoubleValue[] posValues;
    protected DoubleValue[] sizeValues;
    protected double defaultX;
    protected double defaultY;
    protected double defaultSizeX;
    protected double defaultSizeY;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double lineWidth = 1.0;
    protected Color defLines;
    protected Color defExtraColor;
    protected Paint defFill;
    protected double[] thePos;
    protected double[] theSize;
    private Element myElement = (Element)this.getDrawable();
    private int[] posSpot;
    private int[] sizeSpot;
    private int fullPosition;
    private int fullSize;
    private static List<String> infoList = null;

    public ControlElement2D() {
        DoubleValue[] doubleValueArray = new DoubleValue[2];
        this.defaultX = this.myElement.getX();
        doubleValueArray[0] = new DoubleValue(this.defaultX);
        this.defaultY = this.myElement.getY();
        doubleValueArray[1] = new DoubleValue(this.defaultY);
        this.posValues = doubleValueArray;
        DoubleValue[] doubleValueArray2 = new DoubleValue[2];
        this.defaultSizeX = this.myElement.getSizeX();
        doubleValueArray2[0] = new DoubleValue(this.defaultSizeX);
        this.defaultSizeY = this.myElement.getSizeY();
        doubleValueArray2[1] = new DoubleValue(this.defaultSizeY);
        this.sizeValues = doubleValueArray2;
        this.defLines = this.myElement.getStyle().getLineColor();
        this.defFill = this.myElement.getStyle().getFillColor();
        this.defExtraColor = this.myElement.getStyle().getExtraColor();
        int n = this.getPropertiesDisplacement();
        this.posSpot = new int[]{0 + n, 1 + n};
        this.sizeSpot = new int[]{3 + n, 4 + n};
        this.fullPosition = 2 + n;
        this.fullSize = 5 + n;
        this.myElement.addInteractionListener(this);
        this.myElement.setDataObject(this);
    }

    protected abstract int getPropertiesDisplacement();

    @Override
    public Object getObject() {
        return this.myElement;
    }

    @Override
    public abstract String getObjectClassname();

    public final Element getElement() {
        return this.myElement;
    }

    public final int[] getPosSpot() {
        return this.posSpot;
    }

    public final int[] getSizeSpot() {
        return this.sizeSpot;
    }

    public final int getFullPositionSpot() {
        return this.fullPosition;
    }

    public final int getFullSizeSpot() {
        return this.fullSize;
    }

    @Override
    protected void setName(String string) {
        this.myElement.setName(string);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("x");
            infoList.add("y");
            infoList.add("position");
            infoList.add("sizeX");
            infoList.add("sizeY");
            infoList.add("size");
            infoList.add("scalex");
            infoList.add("scaley");
            infoList.add("transformation");
            infoList.add("visible");
            infoList.add("lineColor");
            infoList.add("lineWidth");
            infoList.add("fillColor");
            infoList.add("drawingFill");
            infoList.add("drawingLines");
            infoList.add("enabledPosition");
            infoList.add("movesGroup");
            infoList.add("enabledSize");
            infoList.add("resizesGroup");
            infoList.add("sensitivity");
            infoList.add("pressAction");
            infoList.add("dragAction");
            infoList.add("releaseAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("measured");
            infoList.add("extraColor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("position")) {
            return "double[]";
        }
        if (string.equals("sizeX")) {
            return "int|double";
        }
        if (string.equals("sizeY")) {
            return "int|double";
        }
        if (string.equals("size")) {
            return "double[]";
        }
        if (string.equals("scalex")) {
            return "int|double";
        }
        if (string.equals("scaley")) {
            return "int|double";
        }
        if (string.equals("transformation")) {
            return "AffineTransform|int|double|double[]|double[][]|Object";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("lineColor")) {
            return "int|Color|Object";
        }
        if (string.equals("lineWidth")) {
            return "int|double";
        }
        if (string.equals("fillColor")) {
            return "int|Color|Object";
        }
        if (string.equals("drawingFill")) {
            return "boolean";
        }
        if (string.equals("drawingLines")) {
            return "boolean";
        }
        if (string.equals("enabledPosition")) {
            return "Interaction2D|int|boolean";
        }
        if (string.equals("movesGroup")) {
            return "boolean";
        }
        if (string.equals("enabledSize")) {
            return "Interaction2D|int|boolean";
        }
        if (string.equals("resizesGroup")) {
            return "boolean";
        }
        if (string.equals("sensitivity")) {
            return "int";
        }
        if (string.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("measured")) {
            return "boolean";
        }
        if (string.equals("extraColor")) {
            return "int|Color|Object";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.thePos = null;
                this.posValues[0].value = value.getDouble();
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 1: {
                this.thePos = null;
                this.posValues[1].value = value.getDouble();
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 2: {
                if (!(value.getObject() instanceof double[])) break;
                this.thePos = (double[])value.getObject();
                this.posValues[0].value = this.thePos[0];
                this.posValues[1].value = this.thePos[1];
                this.myElement.setXY(this.posValues[0].value, this.posValues[1].value);
                break;
            }
            case 3: {
                this.theSize = null;
                this.sizeValues[0].value = value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 4: {
                this.theSize = null;
                this.sizeValues[1].value = value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 5: {
                if (!(value.getObject() instanceof double[])) break;
                this.theSize = (double[])value.getObject();
                this.sizeValues[0].value = this.theSize[0];
                this.sizeValues[1].value = this.theSize[1];
                this.myElement.setSizeXY(this.sizeValues[0].value * this.scalex, this.sizeValues[1].value * this.scaley);
                break;
            }
            case 6: {
                this.scalex = value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 7: {
                this.scaley = value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 8: {
                Object object = value.getObject();
                if (object instanceof AffineTransform || object instanceof Matrix2DTransformation || object instanceof double[] || object instanceof double[][]) {
                    this.myElement.setTransformation(value.getObject());
                    break;
                }
                if (value instanceof IntegerValue) {
                    this.myElement.setTransformation(AffineTransform.getRotateInstance((double)value.getInteger() * (Math.PI / 180)));
                    break;
                }
                if (value instanceof DoubleValue || value instanceof InterpretedValue) {
                    this.myElement.setTransformation(AffineTransform.getRotateInstance(value.getDouble()));
                    break;
                }
                this.myElement.setTransformation(ControlElement2D.decodeAffineTransform(value.getString()));
                break;
            }
            case 9: {
                this.myElement.setVisible(value.getBoolean());
                break;
            }
            case 10: {
                if (value.getObject() instanceof Color) {
                    this.myElement.getStyle().setLineColor((Color)value.getObject());
                    break;
                }
                this.myElement.getStyle().setLineColor(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth((float)value.getDouble());
                break;
            }
            case 12: {
                if (value.getObject() instanceof Paint) {
                    this.myElement.getStyle().setFillColor((Paint)value.getObject());
                    break;
                }
                this.myElement.getStyle().setFillColor(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 13: {
                this.myElement.getStyle().setDrawingFill(value.getBoolean());
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingLines(value.getBoolean());
                break;
            }
            case 15: {
                if (value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(0).setEnabled(value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(0).setEnabled(value.getInteger());
                break;
            }
            case 16: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(value.getBoolean());
                break;
            }
            case 17: {
                if (value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(1).setEnabled(value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(1).setEnabled(value.getInteger());
                break;
            }
            case 18: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(value.getBoolean());
                break;
            }
            case 19: {
                this.myElement.getStyle().setSensitivity(value.getInteger());
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, value.getString());
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, value.getString());
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, value.getString());
                break;
            }
            case 23: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 24: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 25: {
                this.myElement.setCanBeMeasured(value.getBoolean());
                break;
            }
            case 26: {
                if (value.getObject() instanceof Color) {
                    this.myElement.getStyle().setExtraColor((Color)value.getObject());
                    break;
                }
                this.myElement.getStyle().setExtraColor(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            default: {
                super.setValue(n - 27, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.posValues[0].value = this.defaultX;
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 1: {
                this.posValues[1].value = this.defaultY;
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 2: {
                this.thePos = null;
                break;
            }
            case 3: {
                this.sizeValues[0].value = this.defaultSizeX;
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 4: {
                this.sizeValues[1].value = this.defaultSizeY;
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 5: {
                this.theSize = null;
                break;
            }
            case 6: {
                this.scalex = 1.0;
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 7: {
                this.scaley = 1.0;
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 8: {
                this.myElement.setTransformation(null);
                break;
            }
            case 9: {
                this.myElement.setVisible(true);
                break;
            }
            case 10: {
                this.myElement.getStyle().setLineColor(this.defLines);
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth(1.0f);
                break;
            }
            case 12: {
                this.myElement.getStyle().setFillColor(this.defFill);
                break;
            }
            case 13: {
                this.myElement.getStyle().setDrawingFill(true);
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingLines(true);
                break;
            }
            case 15: {
                this.myElement.getInteractionTarget(0).setEnabled(false);
                break;
            }
            case 16: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(false);
                break;
            }
            case 17: {
                this.myElement.getInteractionTarget(1).setEnabled(false);
                break;
            }
            case 18: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(false);
                break;
            }
            case 19: {
                this.myElement.getStyle().setSensitivity(5);
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 23: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 24: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 25: {
                this.myElement.setCanBeMeasured(true);
                break;
            }
            case 26: {
                this.myElement.getStyle().setExtraColor(this.defExtraColor);
                break;
            }
            default: {
                super.setDefaultValue(n - 27);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return Double.toString(this.defaultX);
            }
            case 1: {
                return Double.toString(this.defaultY);
            }
            case 2: {
                return "<none>";
            }
            case 3: {
                return Double.toString(this.defaultSizeX);
            }
            case 4: {
                return Double.toString(this.defaultSizeY);
            }
            case 5: {
                return "<none>";
            }
            case 6: {
                return "1";
            }
            case 7: {
                return "1";
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "true";
            }
            case 10: {
                return this.defLines.toString();
            }
            case 11: {
                return "1";
            }
            case 12: {
                return this.defFill.toString();
            }
            case 13: 
            case 14: {
                return "true";
            }
            case 15: {
                return "ENABLED_NONE";
            }
            case 16: {
                return "false";
            }
            case 17: {
                return "ENABLED_NONE";
            }
            case 18: {
                return "false";
            }
            case 19: {
                return Integer.toString(5);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return "<no_action>";
            }
            case 25: {
                return "true";
            }
            case 26: {
                return this.defExtraColor.toString();
            }
        }
        return super.getDefaultValueString(n - 27);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 2: {
                return new ObjectValue(this.thePos);
            }
            case 0: {
                return this.posValues[0];
            }
            case 1: {
                return this.posValues[1];
            }
            case 5: {
                return new ObjectValue(this.theSize);
            }
            case 3: {
                return this.sizeValues[0];
            }
            case 4: {
                return this.sizeValues[1];
            }
        }
        return super.getValue(n - 27);
    }

    final ControlGroup2D getControlGroup() {
        if (this.myParent instanceof ControlGroup2D) {
            return (ControlGroup2D)this.myParent;
        }
        return null;
    }

    protected void propagatePosition(ControlElement2D controlElement2D) {
        this.posValues[0].value = this.myElement.getX();
        this.posValues[1].value = this.myElement.getY();
        if (this.thePos != null) {
            this.thePos[0] = this.posValues[0].value;
            this.thePos[1] = this.posValues[1].value;
            ObjectValue objectValue = new ObjectValue(this.thePos);
            this.variableChanged(this.getFullPositionSpot(), objectValue);
            if (this != controlElement2D) {
                controlElement2D.variableChanged(controlElement2D.getFullPositionSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.posValues);
            if (this != controlElement2D) {
                controlElement2D.variablesChanged(controlElement2D.getPosSpot(), this.posValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.posValues);
            }
        }
    }

    protected void propagateSize(ControlElement2D controlElement2D) {
        this.sizeValues[0].value = this.scalex != 0.0 ? this.myElement.getSizeX() / this.scalex : this.myElement.getSizeX();
        this.sizeValues[1].value = this.scaley != 0.0 ? this.myElement.getSizeY() / this.scaley : this.myElement.getSizeY();
        if (this.theSize != null) {
            this.theSize[0] = this.sizeValues[0].value;
            this.theSize[1] = this.sizeValues[1].value;
            ObjectValue objectValue = new ObjectValue(this.theSize);
            this.variableChanged(this.getFullSizeSpot(), objectValue);
            if (this != controlElement2D) {
                controlElement2D.variableChanged(controlElement2D.getFullSizeSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.sizeValues);
            if (this != controlElement2D) {
                controlElement2D.variablesChanged(controlElement2D.getSizeSpot(), this.sizeValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.sizeValues);
            }
        }
    }

    protected final void reportMouseMotion(Object object) {
        InteractionTarget interactionTarget = (InteractionTarget)object;
        ControlGroup2D controlGroup2D = this.getControlGroup();
        if (interactionTarget == this.myElement.getInteractionTarget(0)) {
            if (interactionTarget.getAffectsGroup() && controlGroup2D != null) {
                controlGroup2D.propagatePosition(this);
            } else {
                this.propagatePosition(this);
            }
        } else if (interactionTarget == this.myElement.getInteractionTarget(1)) {
            if (interactionTarget.getAffectsGroup() && controlGroup2D != null) {
                controlGroup2D.propagateSize(this);
            } else {
                this.propagateSize(this);
            }
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                break;
            }
            case 2000: {
                this.reportMouseMotion(interactionEvent.getInfo());
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(interactionEvent.getInfo());
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("AffineTransform") >= 0) {
            AffineTransform affineTransform = ControlElement2D.decodeAffineTransform(string2);
            if (affineTransform != null) {
                return new ObjectValue(affineTransform);
            }
        } else if (string.indexOf("ElementPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (string2.equals("north")) {
                return new IntegerValue(1);
            }
            if (string2.equals("south")) {
                return new IntegerValue(2);
            }
            if (string2.equals("east")) {
                return new IntegerValue(3);
            }
            if (string2.equals("west")) {
                return new IntegerValue(4);
            }
            if (string2.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (string2.equals("north_west")) {
                return new IntegerValue(6);
            }
            if (string2.equals("south_east")) {
                return new IntegerValue(7);
            }
            if (string2.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (string.indexOf("ArrowPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (string2.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (string2.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (string.indexOf("ArrowStyle") >= 0 || string.indexOf("NewArrowStyle") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("arrow")) {
                return new IntegerValue(0);
            }
            if (string2.equals("segment")) {
                return new IntegerValue(1);
            }
            if (string2.equals("box")) {
                return new IntegerValue(2);
            }
            if (string2.equals("triangle")) {
                return new IntegerValue(3);
            }
            if (string2.equals("rhombus")) {
                return new IntegerValue(4);
            }
        } else if (string.indexOf("MarkerShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("ellipse")) {
                return new IntegerValue(1);
            }
            if (string2.equals("rectangle")) {
                return new IntegerValue(2);
            }
            if (string2.equals("round_rectangle")) {
                return new IntegerValue(3);
            }
            if (string2.equals("wheel")) {
                return new IntegerValue(4);
            }
            if (string2.equals("none")) {
                return new IntegerValue(0);
            }
        } else if (string.indexOf("Interaction2D") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("enabled_none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("enabled_any")) {
                return new IntegerValue(1);
            }
            if (string2.equals("enabled_x")) {
                return new IntegerValue(2);
            }
            if (string2.equals("enabled_y")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(string, string2);
    }

    public static AffineTransform createAffineTransform(String string) {
        AffineTransform affineTransform = new AffineTransform();
        if (string == null || string.equals("null")) {
            return affineTransform;
        }
        if (string.indexOf(58) < 0 && string.indexOf(44) < 0) {
            return affineTransform;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = string2.toLowerCase();
            try {
                double d;
                AffineTransform affineTransform2;
                double d2;
                String string4;
                if (string3.startsWith("ro:")) {
                    string4 = string2.substring(3).trim();
                    boolean bl = false;
                    if (string4.endsWith("\u222b") || string4.endsWith("d")) {
                        string4 = string4.substring(0, string4.length() - 1).trim();
                        bl = true;
                    }
                    d2 = Double.parseDouble(string4);
                    if (bl) {
                        d2 *= Math.PI / 180;
                    }
                    affineTransform2 = AffineTransform.getRotateInstance(d2);
                } else if (string3.startsWith("sc:")) {
                    string4 = string2.substring(3).trim();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                    d2 = Double.parseDouble(stringTokenizer2.nextToken());
                    d = Double.parseDouble(stringTokenizer2.nextToken());
                    affineTransform2 = AffineTransform.getScaleInstance(d2, d);
                } else if (string3.startsWith("sh:")) {
                    string4 = string2.substring(3).trim();
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ",");
                    d2 = Double.parseDouble(stringTokenizer3.nextToken());
                    d = Double.parseDouble(stringTokenizer3.nextToken());
                    affineTransform2 = AffineTransform.getShearInstance(d2, d);
                } else if (string3.startsWith("tr:")) {
                    string4 = string2.substring(3).trim();
                    StringTokenizer stringTokenizer4 = new StringTokenizer(string4, ",");
                    d2 = Double.parseDouble(stringTokenizer4.nextToken());
                    d = Double.parseDouble(stringTokenizer4.nextToken());
                    affineTransform2 = AffineTransform.getTranslateInstance(d2, d);
                } else {
                    string4 = string2;
                    StringTokenizer stringTokenizer5 = new StringTokenizer(string4, ",");
                    d2 = Double.parseDouble(stringTokenizer5.nextToken());
                    d = Double.parseDouble(stringTokenizer5.nextToken());
                    double d3 = Double.parseDouble(stringTokenizer5.nextToken());
                    double d4 = Double.parseDouble(stringTokenizer5.nextToken());
                    double d5 = Double.parseDouble(stringTokenizer5.nextToken());
                    double d6 = Double.parseDouble(stringTokenizer5.nextToken());
                    affineTransform2 = new AffineTransform(d2, d, d3, d4, d5, d6);
                }
                affineTransform2.concatenate(affineTransform);
                affineTransform = affineTransform2;
            }
            catch (Exception exception) {
                System.out.println("Incorrect value for transformation: " + string2);
                exception.printStackTrace();
            }
        }
        return affineTransform;
    }

    public static AffineTransform decodeAffineTransform(String string) {
        if (string.indexOf(34) >= 0) {
            return null;
        }
        if (string.indexOf(37) >= 0) {
            return null;
        }
        if (string.indexOf(123) >= 0 || string.indexOf(125) >= 0) {
            return null;
        }
        if (string.indexOf(58) < 0 && string.indexOf(44) < 0) {
            return null;
        }
        return ControlElement2D.createAffineTransform(string.trim());
    }
}

