/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.TransformationWrapper;
import org.opensourcephysics.numerics.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlTransformation3D
extends ControlElement
implements TransformationWrapper {
    public static final int TR3D_NAME = 0;
    public static final int TR3D_PARENT = 1;
    public static final int TR3D_ENABLED = 2;
    protected boolean enabled = true;
    protected Transformation transformation = this.createTransformation();
    protected ControlElement3D myParent = null;
    private static List<String> infoList = null;

    protected ControlTransformation3D() {
    }

    protected abstract Transformation createTransformation();

    @Override
    public Object getObject() {
        return this.transformation;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.numerics.Transformation";
    }

    public final void setParent(ControlElement3D controlElement3D) {
        if (this.myParent != null) {
            this.myParent.getElement().removeSecondaryTransformation(this);
            this.setAffectedElement(null);
        }
        if (controlElement3D != null) {
            this.myParent = controlElement3D;
            String string = this.getProperty("_ejs_indexInParent_");
            int n = -1;
            if (string != null) {
                n = Integer.parseInt(string);
            }
            this.setProperty("_ejs_indexInParent_", null);
            if (n >= 0) {
                this.myParent.getElement().addSecondaryTransformation(this, n);
            } else {
                this.myParent.getElement().addSecondaryTransformation(this);
            }
            this.setAffectedElement(this.myParent.getElement());
            this.myParent.updatePanel();
        }
    }

    protected void setAffectedElement(Element element) {
    }

    public final ControlElement3D getParent() {
        return this.myParent;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("enabled");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlElement3D) {
                    this.setParent((ControlElement3D)controlElement);
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlElements3DParent");
                break;
            }
            case 2: {
                this.enabled = value.getBoolean();
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                break;
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                if (this.myGroup.getElement(this.getProperty("parent")) == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.enabled = true;
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int n) {
        return null;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public final Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public abstract Object clone();
}

