/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementEllipsoid;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementEllipsoid;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementEllipsoid
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngleU = 0;
    private int maxAngleU = 360;
    private int minAngleV = -90;
    private int maxAngleV = 90;

    public ElementEllipsoid() {
        this.getStyle().setResolution(new Resolution(3, 12, 12));
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementEllipsoid(this);
            }
            case 1: 
        }
        return new Java3dElementEllipsoid(this);
    }

    public void setClosedBottom(boolean bl) {
        if (this.closedBottom == bl) {
            return;
        }
        this.closedBottom = bl;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        if (this.closedTop == bl) {
            return;
        }
        this.closedTop = bl;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        if (this.closedLeft == bl) {
            return;
        }
        this.closedLeft = bl;
        this.addChange(8);
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        if (this.closedRight == bl) {
            return;
        }
        this.closedRight = bl;
        this.addChange(8);
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngleU(int n) {
        if (this.minAngleU == n) {
            return;
        }
        this.minAngleU = Math.max(0, Math.min(360, n));
        this.addChange(8);
    }

    public int getMinimumAngleU() {
        return this.minAngleU;
    }

    public void setMaximumAngleU(int n) {
        if (this.maxAngleU == n) {
            return;
        }
        this.maxAngleU = Math.max(0, Math.min(360, n));
        this.addChange(8);
    }

    public int getMaximumAngleU() {
        return this.maxAngleU;
    }

    public void setMinimumAngleV(int n) {
        if (this.minAngleV == n) {
            return;
        }
        this.minAngleV = Math.max(-90, Math.min(90, n));
        this.addChange(8);
    }

    public int getMinimumAngleV() {
        return this.minAngleV;
    }

    public void setMaximumAngleV(int n) {
        if (this.maxAngleV == n) {
            return;
        }
        this.maxAngleV = Math.max(-90, Math.min(90, n));
        this.addChange(8);
    }

    public int getMaximumAngleV() {
        return this.maxAngleV;
    }

    public boolean checkStandarEllipsoid() {
        return this.minAngleU == 0 && this.maxAngleU == 360 && this.minAngleV == -90 && this.maxAngleV == 90;
    }

    public static double[][][] createStandardEllipsoid(int n, int n2, int n3, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4;
        int n5;
        int n6;
        double d5;
        int n7 = n2 * n3;
        if (Math.abs(d4 - d3) < 180.0) {
            if (bl2) {
                n7 += n * n2;
            }
            if (bl) {
                n7 += n * n2;
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n7 += n * n3;
            }
            if (bl4) {
                n7 += n * n3;
            }
        }
        double[][][] dArray = new double[n7][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        double[] dArray4 = new double[n3 + 1];
        double[] dArray5 = new double[n3 + 1];
        int n8 = 0;
        while (n8 <= n2) {
            d5 = ((double)(n2 - n8) * d + (double)n8 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n8] = Math.cos(d5);
            dArray3[n8] = Math.sin(d5);
            ++n8;
        }
        n8 = 0;
        while (n8 <= n3) {
            d5 = ((double)(n3 - n8) * d3 + (double)n8 * d4) * (Math.PI / 180) / (double)n3;
            dArray4[n8] = Math.cos(d5) / 2.0;
            dArray5[n8] = Math.sin(d5) / 2.0;
            ++n8;
        }
        n8 = 0;
        double[] dArray6 = Element.X_UNIT_VECTOR;
        double[] dArray7 = Element.Y_UNIT_VECTOR;
        double[] dArray8 = Element.Z_UNIT_VECTOR;
        double[] dArray9 = new double[]{0.0, 0.0, 0.0};
        int n9 = 0;
        while (n9 < n3) {
            n6 = 0;
            while (n6 < n2) {
                n5 = 0;
                while (n5 < 3) {
                    dArray[n8][0][n5] = (dArray2[n6] * dArray6[n5] + dArray3[n6] * dArray7[n5]) * dArray4[n9] + dArray5[n9] * dArray8[n5];
                    dArray[n8][1][n5] = (dArray2[n6 + 1] * dArray6[n5] + dArray3[n6 + 1] * dArray7[n5]) * dArray4[n9] + dArray5[n9] * dArray8[n5];
                    dArray[n8][2][n5] = (dArray2[n6 + 1] * dArray6[n5] + dArray3[n6 + 1] * dArray7[n5]) * dArray4[n9 + 1] + dArray5[n9 + 1] * dArray8[n5];
                    dArray[n8][3][n5] = (dArray2[n6] * dArray6[n5] + dArray3[n6] * dArray7[n5]) * dArray4[n9 + 1] + dArray5[n9 + 1] * dArray8[n5];
                    ++n5;
                }
                ++n6;
                ++n8;
            }
            ++n9;
        }
        if (Math.abs(d4 - d3) < 180.0) {
            if (bl2) {
                dArray9[2] = dArray5[0];
                n9 = 0;
                while (n9 < n2) {
                    n6 = 0;
                    while (n6 < n) {
                        n5 = 0;
                        while (n5 < 3) {
                            dArray[n8][0][n5] = ((double)(n - n6) * dArray9[n5] + (double)n6 * dArray[n9][0][n5]) / (double)n;
                            dArray[n8][1][n5] = ((double)(n - n6 - 1) * dArray9[n5] + (double)(n6 + 1) * dArray[n9][0][n5]) / (double)n;
                            dArray[n8][2][n5] = ((double)(n - n6 - 1) * dArray9[n5] + (double)(n6 + 1) * dArray[n9][1][n5]) / (double)n;
                            dArray[n8][3][n5] = ((double)(n - n6) * dArray9[n5] + (double)n6 * dArray[n9][1][n5]) / (double)n;
                            ++n5;
                        }
                        ++n6;
                        ++n8;
                    }
                    ++n9;
                }
            }
            if (bl) {
                dArray9[2] = dArray5[n3];
                n9 = n2 * (n3 - 1);
                n6 = 0;
                while (n6 < n2) {
                    n5 = 0;
                    while (n5 < n) {
                        n4 = 0;
                        while (n4 < 3) {
                            dArray[n8][0][n4] = ((double)(n - n5) * dArray9[n4] + (double)n5 * dArray[n9 + n6][3][n4]) / (double)n;
                            dArray[n8][1][n4] = ((double)(n - n5 - 1) * dArray9[n4] + (double)(n5 + 1) * dArray[n9 + n6][3][n4]) / (double)n;
                            dArray[n8][2][n4] = ((double)(n - n5 - 1) * dArray9[n4] + (double)(n5 + 1) * dArray[n9 + n6][2][n4]) / (double)n;
                            dArray[n8][3][n4] = ((double)(n - n5) * dArray9[n4] + (double)n5 * dArray[n9 + n6][2][n4]) / (double)n;
                            ++n4;
                        }
                        ++n5;
                        ++n8;
                    }
                    ++n6;
                }
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            int n10;
            double[] dArray10 = new double[]{0.0, 0.0, 0.0};
            if (bl4) {
                n6 = 0;
                n5 = 0;
                while (n5 < n3) {
                    dArray9[2] = dArray5[n5];
                    dArray10[2] = dArray5[n5 + 1];
                    n4 = 0;
                    while (n4 < n) {
                        n10 = 0;
                        while (n10 < 3) {
                            dArray[n8][0][n10] = ((double)(n - n4) * dArray9[n10] + (double)n4 * dArray[n6][0][n10]) / (double)n;
                            dArray[n8][1][n10] = ((double)(n - n4 - 1) * dArray9[n10] + (double)(n4 + 1) * dArray[n6][0][n10]) / (double)n;
                            dArray[n8][2][n10] = ((double)(n - n4 - 1) * dArray10[n10] + (double)(n4 + 1) * dArray[n6][3][n10]) / (double)n;
                            dArray[n8][3][n10] = ((double)(n - n4) * dArray10[n10] + (double)n4 * dArray[n6][3][n10]) / (double)n;
                            ++n10;
                        }
                        ++n4;
                        ++n8;
                    }
                    ++n5;
                    n6 += n2;
                }
            }
            if (bl3) {
                n6 = n2 - 1;
                n5 = 0;
                while (n5 < n3) {
                    dArray9[2] = dArray5[n5];
                    dArray10[2] = dArray5[n5 + 1];
                    n4 = 0;
                    while (n4 < n) {
                        n10 = 0;
                        while (n10 < 3) {
                            dArray[n8][0][n10] = ((double)(n - n4) * dArray9[n10] + (double)n4 * dArray[n6][1][n10]) / (double)n;
                            dArray[n8][1][n10] = ((double)(n - n4 - 1) * dArray9[n10] + (double)(n4 + 1) * dArray[n6][1][n10]) / (double)n;
                            dArray[n8][2][n10] = ((double)(n - n4 - 1) * dArray10[n10] + (double)(n4 + 1) * dArray[n6][2][n10]) / (double)n;
                            dArray[n8][3][n10] = ((double)(n - n4) * dArray10[n10] + (double)n4 * dArray[n6][2][n10]) / (double)n;
                            ++n10;
                        }
                        ++n4;
                        ++n8;
                    }
                    ++n5;
                    n6 += n2;
                }
            }
        }
        return dArray;
    }
}

