/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.java3d.Java3dElementSegment;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSegment;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementSegment
extends Element {
    protected double[] origin = new double[3];
    protected double[] end = new double[3];

    public ElementSegment() {
        this.setSize(new double[]{0.1, 0.1, 0.1});
        this.getStyle().setRelativePosition(5);
        this.getStyle().setDrawingLines(true);
        this.getStyle().setDrawingFill(false);
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementSegment(this);
            }
            case 1: 
        }
        return new Java3dElementSegment(this);
    }

    public void projectInteractionPoints() {
        switch (this.getStyle().getRelativePosition()) {
            case 5: {
                System.arraycopy(STD_ORIGIN, 0, this.origin, 0, 3);
                System.arraycopy(STD_CENTERED_END, 0, this.center, 0, 3);
                System.arraycopy(STD_END, 0, this.end, 0, 3);
                break;
            }
            default: {
                System.arraycopy(STD_CENTERED_ORIGIN, 0, this.origin, 0, 3);
                System.arraycopy(STD_ORIGIN, 0, this.center, 0, 3);
                System.arraycopy(STD_CENTERED_END, 0, this.end, 0, 3);
                break;
            }
            case 8: {
                System.arraycopy(STD_END, 0, this.origin, 0, 3);
                System.arraycopy(STD_CENTERED_END, 0, this.center, 0, 3);
                System.arraycopy(STD_ORIGIN, 0, this.end, 0, 3);
            }
        }
        this.sizeAndToSpaceFrame(this.origin);
        this.sizeAndToSpaceFrame(this.center);
        this.sizeAndToSpaceFrame(this.end);
        this.getPanel().projectPosition(this.origin);
        this.getPanel().projectPosition(this.center);
        this.getPanel().projectPosition(this.end);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isEnabled()) {
            return null;
        }
        int n3 = this.getStyle().getSensitivity();
        if (this.targetPosition.isEnabled()) {
            if (Math.abs(this.origin[0] - (double)n) < (double)n3 && Math.abs(this.origin[1] - (double)n2) < (double)n3) {
                return this.targetPosition;
            }
            if (Math.abs(this.center[0] - (double)n) < (double)n3 && Math.abs(this.center[1] - (double)n2) < (double)n3) {
                return this.targetPosition;
            }
        }
        if (this.targetSize.isEnabled() && Math.abs(this.end[0] - (double)n) < (double)n3 && Math.abs(this.end[1] - (double)n2) < (double)n3) {
            return this.targetSize;
        }
        return null;
    }

    double[] getProjectedOrigin() {
        return this.origin;
    }

    double[] getProjectedEnd() {
        return this.end;
    }
}

