/*
 * Decompiled with CFR 0.152.
 */
package users.dav.wc.chaos.FixedTorqueDynamoAndMotor_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EJSODE;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.CashKarp45;
import org.opensourcephysics.tools.ResourceLoader;
import users.dav.wc.chaos.FixedTorqueDynamoAndMotor_pkg.FixedTorqueDynamoAndMotorSimulation;
import users.dav.wc.chaos.FixedTorqueDynamoAndMotor_pkg.FixedTorqueDynamoAndMotorView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedTorqueDynamoAndMotor
extends Model {
    public FixedTorqueDynamoAndMotorSimulation _simulation = null;
    public FixedTorqueDynamoAndMotorView _view = null;
    public FixedTorqueDynamoAndMotor _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EJSODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public String initialConditions = "Chaotic A";
    public double L = 0.11;
    public double J = 1.38E-4;
    public double Is = 0.6;
    public double I0 = 1.8;
    public double C = 0.3;
    public double R = 2.3;
    public double K = 0.17;
    public double omega1 = 1.0;
    public double omega2 = 2.0;
    public double I = 1.0;
    public double t = 0.0;
    public double dt = 0.002;
    public double tol = 1.0E-8;
    public boolean showPhaseSpace;
    public boolean showOmega1;
    public boolean showOmega2;
    public boolean showI;
    public double scale = 50.0;
    public double twoPi = Math.PI * 2;
    public double f1;
    public double f2;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return FixedTorqueDynamoAndMotor._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/dav/wc/chaos/FixedTorqueDynamoAndMotor.ejs";
    }

    public static String _getModelDirectory() {
        return "users/dav/wc/chaos/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(739, 407);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/dav/wc/chaos/FixedTorqueDynamoAndMotor/FixedTorqueDynamoAndMotor.html");
        hashSet.add("/users/dav/wc/chaos/FixedTorqueDynamoAndMotor/dynamo_eqn.gif");
        hashSet.add("/users/dav/wc/chaos/FixedTorqueDynamoAndMotor/FixedTorqueDynamoAndMotor.html");
        hashSet.add("/users/dav/wc/chaos/FixedTorqueDynamoAndMotor/MotorAndDynamo.jpg");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/dav/wc/chaos/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("C:/Users/wochristian/ejs/EJS_4.3.4/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Users/wochristian/ejs/EJS_4.3.4/bin/config/");
        }
        FixedTorqueDynamoAndMotor._addHtmlPageInfo("Fixed Torque Dynamo and Motor", "_default_", "Fixed Torque Dynamo and Motor", "/users/dav/wc/chaos/FixedTorqueDynamoAndMotor/FixedTorqueDynamoAndMotor.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!FixedTorqueDynamoAndMotor._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        FixedTorqueDynamoAndMotor fixedTorqueDynamoAndMotor = new FixedTorqueDynamoAndMotor(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!FixedTorqueDynamoAndMotor._common_initialization(stringArray)) {
            return null;
        }
        FixedTorqueDynamoAndMotor fixedTorqueDynamoAndMotor = new FixedTorqueDynamoAndMotor("frame", jFrame, null, null, stringArray, true);
        return (JComponent)fixedTorqueDynamoAndMotor._getView().getComponent("frame");
    }

    public FixedTorqueDynamoAndMotor() {
        this(null, null, null, null, null, false);
    }

    public FixedTorqueDynamoAndMotor(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public FixedTorqueDynamoAndMotor(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new FixedTorqueDynamoAndMotorSimulation(this, string, frame, uRL, bl);
        this._view = (FixedTorqueDynamoAndMotorView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return FixedTorqueDynamoAndMotor._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return FixedTorqueDynamoAndMotor._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return FixedTorqueDynamoAndMotor._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 5;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.initialConditions = "Chaotic A";
        this.L = 0.11;
        this.J = 1.38E-4;
        this.Is = 0.6;
        this.I0 = 1.8;
        this.C = 0.3;
        this.R = 2.3;
        this.K = 0.17;
        this.omega1 = 1.0;
        this.omega2 = 2.0;
        this.I = 1.0;
        this.t = 0.0;
        this.dt = 0.002;
        this.tol = 1.0E-8;
        this.scale = 50.0;
        this.twoPi = Math.PI * 2;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EJSODE eJSODE : this._privateOdesList.values()) {
            eJSODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
        this._external.resetIC();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.step();
        }
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EJSODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("ODE Evol".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("Unit conversions".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        if (!this.showOmega1 && !this.showOmega2) {
            this.showI = true;
        }
        this._view.currentCheck.setSelected(this.showI);
        this._view.omega1Check.setSelected(this.showOmega1);
        this._view.omega2Check.setSelected(this.showOmega2);
    }

    public void _constraints1() {
        this.f1 = this.omega1 / this.twoPi;
        this.f2 = this.omega2 / this.twoPi;
    }

    public void clearOrbit() {
        this.t = 0.0;
        this._view.clearData();
        this._resetSolvers();
    }

    public void selectConditions() {
        if (this.initialConditions.equals("Chaotic A")) {
            this.J = 1.38E-4;
            this.L = 0.11;
            this.C = 0.3;
            this.K = 0.17;
            this.R = 2.1;
            this.I0 = 1.8;
            this.Is = 0.6;
        } else if (this.initialConditions.equals("Chaotic B")) {
            this.J = 1.38E-4;
            this.L = 0.11;
            this.C = 0.2;
            this.K = 0.17;
            this.R = 2.1;
            this.I0 = 1.8;
            this.Is = 0.6;
        } else if (this.initialConditions.equals("Anharmonic")) {
            this.J = 1.38E-4;
            this.L = 0.11;
            this.C = 0.4;
            this.K = 0.17;
            this.R = 2.3;
            this.I0 = 1.8;
            this.Is = 0.6;
        }
        this.clearOrbit();
    }

    public void _method_for_omega1Field_action() {
        this.omega1 = this.f1 * this.twoPi;
        this.clearOrbit();
    }

    public void _method_for_omega2Field_action() {
        this.omega2 = this.f2 * this.twoPi;
        this.clearOrbit();
    }

    public void _method_for_currentField_action() {
        this.clearOrbit();
    }

    public void _method_for_startStopButton_actionOn() {
        this._play();
    }

    public void _method_for_startStopButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetTime_action() {
        this.t = 0.0;
        this.clearOrbit();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_toolButton_action() {
        this._view.showDataTool(this._view.trajectoryTrail);
    }

    public void _method_for_IsField_action() {
        this.clearOrbit();
    }

    public void _method_for_cField_action() {
        this.clearOrbit();
    }

    public void _method_for_rField_action() {
        this.clearOrbit();
    }

    public void _method_for_experiment_action() {
        this.selectConditions();
    }

    public double _method_for_drawingPanel3D_minimumX() {
        return -this.scale;
    }

    public double _method_for_drawingPanel3D_minimumY() {
        return -this.scale;
    }

    public double _method_for_drawingPanel3D_maximumZ() {
        return 2.0 * this.scale;
    }

    public double _method_for_trajectoryTrail_inputY() {
        return Math.abs(this.f2);
    }

    public double _method_for_stateMarker_y() {
        return Math.abs(this.f2);
    }

    public void _method_for_stateMarker_dragAction() {
        this.clearOrbit();
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements EJSODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            FixedTorqueDynamoAndMotor.this._privateOdesList.put("ODE Evol", this);
        }

        @Override
        public ODEInterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else if (string.indexOf("qss") >= 0) {
                string = string2 + "qss.Qss3";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[4];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getSolver().getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            this.__pushState();
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.initialize(FixedTorqueDynamoAndMotor.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(FixedTorqueDynamoAndMotor.this.tol, FixedTorqueDynamoAndMotor.this.tol);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != FixedTorqueDynamoAndMotor.this.omega1) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = FixedTorqueDynamoAndMotor.this.omega1;
            if (this.__state[n] != FixedTorqueDynamoAndMotor.this.omega2) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = FixedTorqueDynamoAndMotor.this.omega2;
            if (this.__state[n] != FixedTorqueDynamoAndMotor.this.I) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = FixedTorqueDynamoAndMotor.this.I;
            if (this.__state[n] != FixedTorqueDynamoAndMotor.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = FixedTorqueDynamoAndMotor.this.t;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(FixedTorqueDynamoAndMotor.this._view.getComponent(FixedTorqueDynamoAndMotor.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                FixedTorqueDynamoAndMotor.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(FixedTorqueDynamoAndMotor.this.dt);
            this.__eventSolver.setInternalStepSize(FixedTorqueDynamoAndMotor.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(FixedTorqueDynamoAndMotor.this.tol, FixedTorqueDynamoAndMotor.this.tol);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            FixedTorqueDynamoAndMotor.this.omega1 = this.__state[n++];
            FixedTorqueDynamoAndMotor.this.omega2 = this.__state[n++];
            FixedTorqueDynamoAndMotor.this.I = this.__state[n++];
            FixedTorqueDynamoAndMotor.this.t = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != 0) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            int n3 = 0;
            dArray2[n3++] = (FixedTorqueDynamoAndMotor.this.C - d3 * FixedTorqueDynamoAndMotor.this.K * Math.tanh(d3 / FixedTorqueDynamoAndMotor.this.I0)) / FixedTorqueDynamoAndMotor.this.J;
            dArray2[n3++] = d3 * FixedTorqueDynamoAndMotor.this.K * Math.tanh(FixedTorqueDynamoAndMotor.this.Is / FixedTorqueDynamoAndMotor.this.I0) / FixedTorqueDynamoAndMotor.this.J;
            dArray2[n3++] = (d * FixedTorqueDynamoAndMotor.this.K * Math.tanh(d3 / FixedTorqueDynamoAndMotor.this.I0) - FixedTorqueDynamoAndMotor.this.R * d3 - d2 * FixedTorqueDynamoAndMotor.this.K * Math.tanh(FixedTorqueDynamoAndMotor.this.Is / FixedTorqueDynamoAndMotor.this.I0)) / FixedTorqueDynamoAndMotor.this.L;
            dArray2[n3++] = 1.0;
        }
    }
}

