/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;

public class DisplayColors {
    static Color[] phaseColors = null;
    static Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue, Color.yellow.darker(), Color.cyan, Color.magenta};
    static Color[] markerColors = new Color[]{Color.black, Color.blue, Color.red, Color.green, Color.darkGray, Color.lightGray};

    private DisplayColors() {
    }

    public static Color[] getPhaseToColorArray() {
        if (phaseColors == null) {
            phaseColors = new Color[256];
            int n = 0;
            while (n < 256) {
                double d = Math.abs(Math.sin(Math.PI * (double)n / 255.0));
                int n2 = (int)(255.0 * d * d);
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 1.0471975511965976));
                int n3 = (int)(255.0 * d * d * Math.sqrt(d));
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 2.0943951023931953));
                int n4 = (int)(255.0 * d * d);
                DisplayColors.phaseColors[n] = new Color(n4, n3, n2);
                ++n;
            }
        }
        return phaseColors;
    }

    public static Color phaseToColor(double d) {
        int n = (int)(127.5 * (1.0 + d / Math.PI));
        n %= 255;
        if (phaseColors == null) {
            return DisplayColors.getPhaseToColorArray()[n];
        }
        return phaseColors[n];
    }

    public static Color randomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static Color getLineColor(int n) {
        if (n < lineColors.length - 1) {
            return lineColors[n];
        }
        return DisplayColors.randomColor();
    }

    public static Color getMarkerColor(int n) {
        if (n < markerColors.length - 1) {
            return markerColors[n];
        }
        return DisplayColors.randomColor();
    }
}

