/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.colos.ejs.library.Simulation;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetPoligonMovingPoint;
import org.opensourcephysics.displayejs.InteractionTargetPoligonPoint;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.frames.TableFrame;
import org.opensourcephysics.tools.DataTool;

public class InteractivePoligon
extends AbstractInteractiveElement {
    public static final int PLAIN = 0;
    public static final int CIRCLE = 1;
    public static final int DIAMOND = 2;
    public static final int SQUARE = 3;
    public static final int ARROW = 4;
    public static final int LINE = 5;
    public static final int FILLED_CIRCLE = 6;
    public static final int FILLED_DIAMOND = 7;
    public static final int FILLED_SQUARE = 8;
    public static final int FILLED_ARROW = 9;
    protected boolean closed = true;
    protected int numPoints = -1;
    protected int startType = 0;
    protected int endType = 0;
    protected double neumaticDash = 0.0;
    protected double startSize = Double.NaN;
    protected double endSize = Double.NaN;
    protected double[][] coordinates = null;
    protected boolean[] connect = null;
    protected boolean[] pointSizeEnabled = null;
    protected Color[] lineColors = null;
    protected int[] shapeType = null;
    protected Color[] shapeEdgeColor = null;
    protected Color[] shapeFillColor = null;
    protected int[] shapeSize = null;
    protected int sides = 0;
    protected int dashSize = 0;
    protected int theStartSize = 0;
    protected int theEndSize = 0;
    protected int[] aPoints = null;
    protected int[] bPoints = null;
    protected double[] center = new double[3];
    protected double[] pixel = new double[3];
    protected double[] pixelOrigin = new double[5];
    protected double[] point = new double[3];
    protected double[] origin = new double[6];
    protected double[] size = new double[3];
    protected Object3D[] lineObjects = null;
    protected Object3D[] closedObject = new Object3D[]{new Object3D(this, -1)};
    protected InteractionTargetPoligonPoint targetPoint = new InteractionTargetPoligonPoint(this, -1);
    protected Shape[] shape = null;
    private boolean showZ = false;
    private boolean allowTable = false;
    protected String name = "polygon";
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private static final int MAX = 10;
    private int startPoints = 0;
    private int endPoints = 0;
    private int[] startA = new int[10];
    private int[] startB = new int[10];
    private int[] endA = new int[10];
    private int[] endB = new int[10];

    public InteractivePoligon() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractivePoligon) {
            InteractivePoligon interactivePoligon = (InteractivePoligon)interactiveElement;
            this.setNumberOfPoints(interactivePoligon.getNumberOfPoints());
            this.setClosed(interactivePoligon.isClosed());
            this.setData(interactivePoligon.getData());
            int n = 0;
            while (n < this.numPoints) {
                this.connect[n] = interactivePoligon.connect[n];
                ++n;
            }
            n = 0;
            while (n < this.numPoints) {
                this.pointSizeEnabled[n] = interactivePoligon.pointSizeEnabled[n];
                ++n;
            }
            n = 0;
            while (n < this.numPoints) {
                this.shapeType[n] = interactivePoligon.shapeType[n];
                ++n;
            }
            n = 0;
            while (n < this.numPoints) {
                this.shapeSize[n] = interactivePoligon.shapeSize[n];
                ++n;
            }
            n = 0;
            while (n < this.numPoints) {
                this.shapeEdgeColor[n] = interactivePoligon.shapeEdgeColor[n];
                ++n;
            }
            n = 0;
            while (n < this.numPoints) {
                this.shapeFillColor[n] = interactivePoligon.shapeFillColor[n];
                ++n;
            }
            n = 0;
            while (n < this.numPoints) {
                this.shape[n] = interactivePoligon.shape[n];
                ++n;
            }
            this.setName(((InteractiveTrace)interactiveElement).getName());
            this.setAllowTable(((InteractivePoligon)interactiveElement).allowTable);
        }
    }

    public void setNumberOfPoints(int n) {
        if (n == this.numPoints) {
            return;
        }
        if (n < 1) {
            return;
        }
        this.numPoints = n;
        this.sides = this.numPoints - 1;
        this.coordinates = new double[3][this.numPoints];
        this.connect = new boolean[this.numPoints];
        this.pointSizeEnabled = new boolean[this.numPoints];
        this.aPoints = new int[this.numPoints];
        this.bPoints = new int[this.numPoints];
        this.lineObjects = new Object3D[this.numPoints];
        this.lineColors = new Color[this.numPoints];
        this.shapeType = new int[this.numPoints];
        this.shapeSize = new int[this.numPoints];
        this.shapeEdgeColor = new Color[this.numPoints];
        this.shapeFillColor = new Color[this.numPoints];
        this.shape = new Shape[this.numPoints];
        int n2 = 0;
        while (n2 < this.numPoints) {
            this.coordinates[2][n2] = 0.0;
            this.coordinates[1][n2] = 0.0;
            this.coordinates[0][n2] = 0.0;
            this.connect[n2] = true;
            this.lineColors[n2] = null;
            this.pointSizeEnabled[n2] = true;
            this.lineObjects[n2] = new Object3D(this, n2);
            this.shapeType[n2] = 0;
            this.shapeSize[n2] = 10;
            this.shapeEdgeColor[n2] = Color.BLACK;
            this.shapeFillColor[n2] = Color.RED;
            this.shape[n2] = null;
            ++n2;
        }
        this.connect[this.sides] = this.closed;
        this.hasChanged = true;
    }

    public int getNumberOfPoints() {
        return this.numPoints;
    }

    public void setStartType(int n) {
        if (n == this.startType) {
            return;
        }
        this.startType = n;
        this.hasChanged = true;
    }

    public int getStartType() {
        return this.startType;
    }

    public void setStartSize(double d) {
        if (d == this.startSize) {
            return;
        }
        this.startSize = d;
        this.hasChanged = true;
    }

    public double getStartSize() {
        return this.startSize;
    }

    public void setEndType(int n) {
        if (n == this.endType) {
            return;
        }
        this.endType = n;
        this.hasChanged = true;
    }

    public int getEndType() {
        return this.endType;
    }

    public void setEndSize(double d) {
        if (d == this.endSize) {
            return;
        }
        this.endSize = d;
        this.hasChanged = true;
    }

    public double getEndSize() {
        return this.endSize;
    }

    public void setNeumatic(double d) {
        if (this.neumaticDash == d) {
            return;
        }
        this.neumaticDash = d;
        this.hasChanged = true;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
        if (this.sides > 0) {
            this.connect[this.sides] = this.closed;
        }
        this.hasChanged = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setAllowTable(boolean bl) {
        this.allowTable = bl;
    }

    public void setData(double[][] dArray) {
        if (this.numPoints != dArray.length) {
            this.setNumberOfPoints(dArray.length);
        }
        int n = Math.min(dArray.length, this.numPoints);
        int n2 = Math.min(dArray[0].length, 3);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.coordinates[n4][n3] = dArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
        this.hasChanged = true;
    }

    public double[][] getData() {
        return this.coordinates;
    }

    public double[] getPoint(int n) {
        double[] dArray = new double[this.coordinates.length];
        int n2 = 0;
        while (n2 < this.coordinates.length) {
            dArray[n2] = this.coordinates[n2][n];
            ++n2;
        }
        return dArray;
    }

    public void setXs(double[] dArray) {
        int n = 0;
        int n2 = Math.min(dArray.length, this.numPoints);
        while (n < n2) {
            this.coordinates[0][n] = dArray[n];
            ++n;
        }
        this.hasChanged = true;
    }

    public void setXs(double d) {
        int n = 0;
        while (n < this.numPoints) {
            this.coordinates[0][n] = d;
            ++n;
        }
        this.hasChanged = true;
    }

    public void setYs(double[] dArray) {
        int n = 0;
        int n2 = Math.min(dArray.length, this.numPoints);
        while (n < n2) {
            this.coordinates[1][n] = dArray[n];
            ++n;
        }
        this.hasChanged = true;
    }

    public void setYs(double d) {
        int n = 0;
        while (n < this.numPoints) {
            this.coordinates[1][n] = d;
            ++n;
        }
        this.hasChanged = true;
    }

    public void setZs(double[] dArray) {
        int n = 0;
        int n2 = Math.min(dArray.length, this.numPoints);
        while (n < n2) {
            this.coordinates[2][n] = dArray[n];
            ++n;
        }
        this.showZ = true;
        this.hasChanged = true;
    }

    public void setZs(double d) {
        int n = 0;
        while (n < this.numPoints) {
            this.coordinates[2][n] = d;
            ++n;
        }
        this.showZ = true;
        this.hasChanged = true;
    }

    public void setConnections(boolean[] blArray) {
        if (blArray == null) {
            int n = 0;
            while (n < this.numPoints) {
                this.connect[n] = true;
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.numPoints) {
                this.connect[n] = blArray[n];
                ++n;
            }
        }
        if (this.connect != null) {
            this.connect[this.sides] = this.closed;
        }
        this.hasChanged = true;
    }

    public void setConnected(int n, boolean bl) {
        if (n < this.numPoints) {
            this.connect[n] = bl;
        }
        this.hasChanged = true;
    }

    public void setPointSizeEnableds(boolean[] blArray) {
        int n = 0;
        int n2 = Math.min(blArray.length, this.numPoints);
        while (n < n2) {
            this.pointSizeEnabled[n] = blArray[n];
            ++n;
        }
    }

    public void setPointSizeEnabled(int n, boolean bl) {
        if (n > -1 && n < this.numPoints) {
            this.pointSizeEnabled[n] = bl;
        }
    }

    public void setColors(Color[] colorArray) {
        if (colorArray == null) {
            int n = 0;
            while (n < this.numPoints) {
                this.lineColors[n] = null;
                ++n;
            }
        } else {
            int n = 0;
            int n2 = Math.min(colorArray.length, this.numPoints);
            while (n < n2) {
                this.lineColors[n] = colorArray[n];
                ++n;
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void showPopup(final Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){

            public void actionPerformed(ActionEvent actionEvent) {
                InteractivePoligon.this.showTable(component);
            }
        });
        jPopupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetTool")){

            public void actionPerformed(ActionEvent actionEvent) {
                InteractivePoligon.this.showDatasetTool();
            }
        });
        jPopupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetManager")){

            public void actionPerformed(ActionEvent actionEvent) {
                InteractiveTrace.showDatasetManagerTool(component);
            }
        });
        jPopupMenu.show(component, n, n2);
    }

    public static Dataset createDataset(InteractivePoligon interactivePoligon) {
        Dataset dataset = new Dataset();
        dataset.setName(interactivePoligon.getName());
        dataset.setConnected(true);
        dataset.setLineColor(interactivePoligon.getStyle().getEdgeColor());
        dataset.setMarkerShape(2);
        dataset.setMarkerColor(new Color(255, 128, 128, 128), interactivePoligon.getStyle().getEdgeColor());
        int n = 0;
        while (n < interactivePoligon.numPoints) {
            dataset.append(interactivePoligon.coordinates[0][n], interactivePoligon.coordinates[1][n]);
            ++n;
        }
        return dataset;
    }

    public DataTool showDatasetTool() {
        DataTool dataTool = new DataTool(InteractivePoligon.createDataset(this), this.name);
        dataTool.setVisible(true);
        return dataTool;
    }

    public TableFrame showTable(Component component) {
        TableFrame tableFrame = new TableFrame("Trace Data");
        tableFrame.setRowNumberVisible(false);
        tableFrame.setColumnNames(0, "x");
        tableFrame.setColumnNames(1, "y");
        if (this.showZ) {
            tableFrame.setColumnNames(2, "z");
        }
        int n = 0;
        while (n < this.numPoints) {
            if (this.showZ) {
                tableFrame.appendRow(new double[]{this.coordinates[0][n], this.coordinates[1][n], this.coordinates[2][n]});
            } else {
                tableFrame.appendRow(new double[]{this.coordinates[0][n], this.coordinates[1][n]});
            }
            ++n;
        }
        tableFrame.setDefaultCloseOperation(2);
        tableFrame.setLocationRelativeTo(component);
        tableFrame.setVisible(true);
        return tableFrame;
    }

    public void setShapesType(int[] nArray) {
        if (nArray == null) {
            int n = 0;
            while (n < this.numPoints) {
                this.createShape(n, 0);
                ++n;
            }
        } else {
            int n = 0;
            int n2 = Math.min(nArray.length, this.numPoints);
            while (n < n2) {
                this.createShape(n, nArray[n]);
                ++n;
            }
        }
    }

    public void setShapesType(int n) {
        int n2 = 0;
        while (n2 < this.numPoints) {
            this.createShape(n2, n);
            ++n2;
        }
    }

    public void setShapesSize(int[] nArray) {
        if (nArray == null) {
            int n = 0;
            while (n < this.numPoints) {
                this.shapeSize[n] = 10;
                ++n;
            }
        } else {
            int n = 0;
            int n2 = Math.min(nArray.length, this.numPoints);
            while (n < n2) {
                this.shapeSize[n] = nArray[n];
                ++n;
            }
        }
    }

    public void setShapesSize(int n) {
        int n2 = 0;
        while (n2 < this.numPoints) {
            this.shapeSize[n2] = n;
            ++n2;
        }
    }

    public void setShapesEdgeColor(Object[] objectArray) {
        if (objectArray == null) {
            int n = 0;
            while (n < this.numPoints) {
                this.shapeEdgeColor[n] = Color.BLACK;
                ++n;
            }
        } else {
            int n = 0;
            int n2 = Math.min(objectArray.length, this.numPoints);
            while (n < n2) {
                this.shapeEdgeColor[n] = (Color)objectArray[n];
                ++n;
            }
        }
    }

    public void setShapesEdgeColor(Color color) {
        int n = 0;
        while (n < this.numPoints) {
            this.shapeEdgeColor[n] = color;
            ++n;
        }
    }

    public void setShapesFillColor(Object[] objectArray) {
        if (objectArray == null) {
            int n = 0;
            while (n < this.numPoints) {
                this.shapeFillColor[n] = Color.RED;
                ++n;
            }
        } else {
            int n = 0;
            int n2 = Math.min(objectArray.length, this.numPoints);
            while (n < n2) {
                this.shapeFillColor[n] = (Color)objectArray[n];
                ++n;
            }
        }
    }

    public void setShapesFillColor(Color color) {
        int n = 0;
        while (n < this.numPoints) {
            this.shapeFillColor[n] = color;
            ++n;
        }
    }

    private void createShape(int n, int n2) {
        if (this.shapeType[n] == n2) {
            return;
        }
        this.shapeType[n] = n2;
        switch (this.shapeType[n]) {
            default: {
                this.shape[n] = null;
                break;
            }
            case 1: {
                this.shape[n] = new Ellipse2D.Float();
                break;
            }
            case 2: {
                this.shape[n] = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.shape[n] = new RoundRectangle2D.Float();
            }
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        int n3;
        if (this.numPoints <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.sizeEnabled) {
            n3 = 0;
            while (n3 < this.numPoints) {
                if (this.pointSizeEnabled[n3] && Math.abs(this.aPoints[n3] - n) < SENSIBILITY && Math.abs(this.bPoints[n3] - n2) < SENSIBILITY) {
                    return new InteractionTargetPoligonPoint(this, n3);
                }
                ++n3;
            }
        }
        if (this.positionEnabled) {
            n3 = 0;
            while (n3 < this.numPoints) {
                if (Math.abs(this.aPoints[n3] - n) < SENSIBILITY && Math.abs(this.bPoints[n3] - n2) < SENSIBILITY) {
                    return new InteractionTargetPoligonMovingPoint(this, n3);
                }
                ++n3;
            }
        }
        if (this.allowTable) {
            n3 = 0;
            while (n3 < this.numPoints) {
                if (Math.abs(this.aPoints[n3] - n) < SENSIBILITY && Math.abs(this.bPoints[n3] - n2) < SENSIBILITY) {
                    return this;
                }
                ++n3;
            }
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.numPoints <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        if (this.closed && this.style.fillPattern != null) {
            return this.closedObject;
        }
        return this.lineObjects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        if (n < 0) {
            Paint paint = this.style.fillPattern;
            if (paint instanceof Color) {
                paint = drawingPanel3D.projectColor((Color)paint, this.closedObject[0].distance);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.fillPolygon(this.aPoints, this.bPoints, this.numPoints);
            if (this.style.edgeColor == null && this.lineColors[0] == null) {
                return;
            }
            if (this.connect[0]) {
                if (this.lineColors[0] != null) {
                    graphics2D.setColor(drawingPanel3D.projectColor(this.lineColors[0], this.lineObjects[0].distance));
                } else {
                    graphics2D.setColor(drawingPanel3D.projectColor(this.style.edgeColor, this.lineObjects[0].distance));
                }
                this.drawStart(graphics2D);
            }
            int n2 = 1;
            while (n2 < this.sides) {
                if (this.connect[n2]) {
                    if (this.lineColors[n2] != null) {
                        graphics2D.setColor(drawingPanel3D.projectColor(this.lineColors[n2], this.lineObjects[n2].distance));
                    } else {
                        graphics2D.setColor(drawingPanel3D.projectColor(this.style.edgeColor, this.lineObjects[n2].distance));
                    }
                    this.drawLine(graphics2D, this.aPoints[n2], this.bPoints[n2], this.aPoints[n2 + 1], this.bPoints[n2 + 1]);
                }
                ++n2;
            }
            if (this.connect[this.sides]) {
                if (this.lineColors[this.sides] != null) {
                    graphics2D.setColor(drawingPanel3D.projectColor(this.lineColors[this.sides], this.lineObjects[this.sides].distance));
                } else {
                    graphics2D.setColor(drawingPanel3D.projectColor(this.style.edgeColor, this.lineObjects[this.sides].distance));
                }
                this.drawEnd(graphics2D, this.aPoints[this.sides], this.bPoints[this.sides], this.aPoints[0], this.bPoints[0]);
            }
            return;
        }
        if (this.connect[n] && (this.lineColors[n] != null || this.style.edgeColor != null)) {
            if (this.lineColors[n] != null) {
                graphics2D.setColor(drawingPanel3D.projectColor(this.lineColors[n], this.lineObjects[n].distance));
            } else {
                graphics2D.setColor(drawingPanel3D.projectColor(this.style.edgeColor, this.lineObjects[n].distance));
            }
            graphics2D.setStroke(this.style.edgeStroke);
            if (n == 0) {
                if (this.numPoints == 2) {
                    this.drawStartAndEnd(graphics2D);
                } else {
                    this.drawStart(graphics2D);
                }
            } else if (n < this.sides - 1) {
                this.drawLine(graphics2D, this.aPoints[n], this.bPoints[n], this.aPoints[n + 1], this.bPoints[n + 1]);
            } else if (n < this.sides) {
                if (this.closed) {
                    this.drawLine(graphics2D, this.aPoints[n], this.bPoints[n], this.aPoints[this.sides], this.bPoints[this.sides]);
                } else {
                    this.drawEnd(graphics2D, this.aPoints[n], this.bPoints[n], this.aPoints[this.sides], this.bPoints[this.sides]);
                }
            } else {
                this.drawEnd(graphics2D, this.aPoints[n], this.bPoints[n], this.aPoints[0], this.bPoints[0]);
            }
        }
        if (this.shapeType[n] != 0) {
            this.drawMarker(graphics2D, this.aPoints[n], this.bPoints[n], n);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.numPoints <= 0 || !this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.projectPoints(drawingPanel);
        graphics2D.setStroke(this.style.edgeStroke);
        if (this.closed && this.style.fillPattern != null) {
            graphics2D.setPaint(this.style.fillPattern);
            graphics2D.fillPolygon(this.aPoints, this.bPoints, this.numPoints);
        }
        if (this.style.edgeColor != null || this.lineColors[0] != null) {
            if (this.lineColors[0] != null) {
                graphics2D.setColor(this.lineColors[0]);
            } else {
                graphics2D.setColor(this.style.edgeColor);
            }
            if (this.numPoints == 2) {
                if (this.connect[0]) {
                    this.drawStartAndEnd(graphics2D);
                }
                this.drawMarkers(graphics2D);
                return;
            }
            if (this.connect[0]) {
                this.drawStart(graphics2D);
            }
            int n = this.sides;
            int n2 = 0;
            if (!this.closed) {
                n = this.sides - 1;
                n2 = this.sides;
            }
            int n3 = 1;
            while (n3 < n) {
                if (this.connect[n3]) {
                    if (this.lineColors[n3] != null) {
                        graphics2D.setColor(this.lineColors[n3]);
                    } else {
                        graphics2D.setColor(this.style.edgeColor);
                    }
                    this.drawLine(graphics2D, this.aPoints[n3], this.bPoints[n3], this.aPoints[n3 + 1], this.bPoints[n3 + 1]);
                }
                ++n3;
            }
            if (this.connect[n]) {
                if (this.lineColors[n] != null) {
                    graphics2D.setColor(this.lineColors[n]);
                } else {
                    graphics2D.setColor(this.style.edgeColor);
                }
                this.drawEnd(graphics2D, this.aPoints[n], this.bPoints[n], this.aPoints[n2], this.bPoints[n2]);
            }
        }
        this.drawMarkers(graphics2D);
    }

    private void drawMarker(Graphics2D graphics2D, int n, int n2, int n3) {
        RectangularShape rectangularShape = (RectangularShape)this.shape[n3];
        int n4 = this.shapeSize[n3] / 2;
        rectangularShape.setFrame(n - n4, n2 - n4, this.shapeSize[n3], this.shapeSize[n3]);
        if (this.shapeFillColor[n3] != null) {
            graphics2D.setPaint(this.shapeFillColor[n3]);
            graphics2D.fill(rectangularShape);
        }
        if (this.shapeEdgeColor[n3] != null) {
            graphics2D.setColor(this.shapeEdgeColor[n3]);
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.draw(rectangularShape);
        }
    }

    private void drawMarkers(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.numPoints) {
            if (this.shapeType[n] != 0) {
                this.drawMarker(graphics2D, this.aPoints[n], this.bPoints[n], n);
            }
            ++n;
        }
    }

    public boolean isMeasured() {
        return this.canBeMeasured && this.numPoints > 0;
    }

    public double getXMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.numPoints) {
            if (this.coordinates[0][n] < d) {
                d = this.coordinates[0][n];
            }
            ++n;
        }
        if (this.group == null) {
            return this.x + d * this.sizex;
        }
        return this.group.x + (this.x + d * this.sizex) * this.group.sizex;
    }

    public double getXMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numPoints) {
            if (this.coordinates[0][n] > d) {
                d = this.coordinates[0][n];
            }
            ++n;
        }
        if (this.group == null) {
            return this.x + d * this.sizex;
        }
        return this.group.x + (this.x + d * this.sizex) * this.group.sizex;
    }

    public double getYMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.numPoints) {
            if (this.coordinates[1][n] < d) {
                d = this.coordinates[1][n];
            }
            ++n;
        }
        if (this.group == null) {
            return this.y + d * this.sizey;
        }
        return this.group.y + (this.y + d * this.sizey) * this.group.sizey;
    }

    public double getYMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numPoints) {
            if (this.coordinates[1][n] > d) {
                d = this.coordinates[1][n];
            }
            ++n;
        }
        if (this.group == null) {
            return this.y + d * this.sizey;
        }
        return this.group.y + (this.y + d * this.sizey) * this.group.sizey;
    }

    public double getZMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.numPoints) {
            if (this.coordinates[2][n] < d) {
                d = this.coordinates[2][n];
            }
            ++n;
        }
        if (this.group == null) {
            return this.z + d * this.sizez;
        }
        return this.group.z + (this.z + d * this.sizez) * this.group.sizez;
    }

    public double getZMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numPoints) {
            if (this.coordinates[2][n] > d) {
                d = this.coordinates[2][n];
            }
            ++n;
        }
        if (this.group == null) {
            return this.z + d * this.sizez;
        }
        return this.group.z + (this.z + d * this.sizez) * this.group.sizez;
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        this.center[0] = 0.0;
        this.center[1] = 0.0;
        this.center[2] = 0.0;
        if (this.group == null) {
            this.origin[0] = this.x;
            this.origin[1] = this.y;
            this.origin[2] = this.z;
            this.size[0] = this.sizex;
            this.size[1] = this.sizey;
            this.size[2] = this.sizez;
        } else {
            this.origin[0] = this.group.x + this.x * this.group.sizex;
            this.origin[1] = this.group.y + this.y * this.group.sizey;
            this.origin[2] = this.group.z + this.z * this.group.sizez;
            this.size[0] = this.sizex * this.group.sizex;
            this.size[1] = this.sizey * this.group.sizey;
            this.size[2] = this.sizez * this.group.sizez;
        }
        this.origin[4] = this.origin[5] = this.neumaticDash;
        this.origin[3] = this.origin[5];
        drawingPanel.project(this.origin, this.pixelOrigin);
        this.dashSize = this.neumaticDash > 0.0 ? (int)(Math.max(this.pixelOrigin[2], this.pixelOrigin[3]) / 2.82) : (int)(Math.min(this.pixelOrigin[2], this.pixelOrigin[3]) / 2.82);
        if (this.startType != 0 && !Double.isNaN(this.startSize)) {
            this.origin[4] = this.origin[5] = this.startSize;
            this.origin[3] = this.origin[5];
            drawingPanel.project(this.origin, this.pixelOrigin);
            this.theStartSize = (int)Math.max(this.pixelOrigin[2], this.pixelOrigin[3]);
        }
        if (this.endType != 0 && !Double.isNaN(this.endSize)) {
            this.origin[4] = this.origin[5] = this.endSize;
            this.origin[3] = this.origin[5];
            drawingPanel.project(this.origin, this.pixelOrigin);
            this.theEndSize = (int)Math.max(this.pixelOrigin[2], this.pixelOrigin[3]);
        }
        int n = 0;
        while (n < this.numPoints) {
            int n2 = 0;
            while (n2 < 3) {
                double d = this.coordinates[n2][n] * this.size[n2];
                int n3 = n2;
                this.center[n3] = this.center[n3] + d;
                this.point[n2] = this.origin[n2] + d;
                ++n2;
            }
            drawingPanel.project(this.point, this.pixel);
            this.aPoints[n] = (int)this.pixel[0];
            this.bPoints[n] = (int)this.pixel[1];
            this.lineObjects[n].distance = this.connect[n] ? this.pixel[2] : Double.NaN;
            ++n;
        }
        n = 0;
        while (n < 3) {
            this.center[n] = this.origin[n] + this.center[n] / (double)this.numPoints;
            ++n;
        }
        if (this.closed && this.style.fillPattern != null) {
            drawingPanel.project(this.center, this.pixel);
            this.closedObject[0].distance = this.pixel[2];
        } else {
            this.closedObject[0].distance = Double.NaN;
        }
        this.computeStart();
        this.computeEnd();
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
    }

    private void computeStart() {
        this.startPoints = this.computeExtreme(this.startA, this.startB, 1, 0, this.startType, this.startSize, this.theStartSize);
    }

    private void computeEnd() {
        this.endPoints = this.closed ? this.computeExtreme(this.endA, this.endB, this.numPoints - 1, 0, this.endType, this.endSize, this.theEndSize) : this.computeExtreme(this.endA, this.endB, this.numPoints - 2, this.numPoints - 1, this.endType, this.endSize, this.theEndSize);
    }

    private int computeExtreme(int[] nArray, int[] nArray2, int n, int n2, int n3, double d, int n4) {
        double d2;
        double d3;
        if (n3 == 0) {
            nArray[0] = this.aPoints[n2];
            nArray2[0] = this.bPoints[n2];
            nArray[1] = this.aPoints[n];
            nArray2[1] = this.bPoints[n];
            return 2;
        }
        double d4 = this.aPoints[n2] - this.aPoints[n];
        double d5 = this.bPoints[n2] - this.bPoints[n];
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        if (d6 == 0.0) {
            nArray[0] = this.aPoints[n2];
            nArray2[0] = this.bPoints[n2];
            nArray[1] = this.aPoints[n];
            nArray2[1] = this.bPoints[n];
            return 2;
        }
        if (Double.isNaN(d)) {
            d4 *= 0.35 / d6;
            d5 *= 0.35 / d6;
            if (d6 > 25.0) {
                d6 = 25.0;
            }
            d3 = (double)this.aPoints[n2] - d4 * d6;
            d2 = (double)this.bPoints[n2] - d5 * d6;
        } else {
            d6 = (double)n4 / d6;
            d3 = (double)this.aPoints[n2] - d4 * d6;
            d2 = (double)this.bPoints[n2] - d5 * d6;
        }
        d4 *= d6 / 2.0;
        d5 *= d6 / 2.0;
        switch (n3) {
            default: {
                nArray[0] = this.aPoints[n2];
                nArray2[0] = this.bPoints[n2];
                nArray[1] = this.aPoints[n];
                nArray2[1] = this.bPoints[n];
                return 2;
            }
            case 1: 
            case 6: {
                int n5 = 9;
                double d7 = Math.atan2(d5, d4);
                double d8 = Math.PI * 2 / (double)(n5 - 1);
                double d9 = Math.sqrt(d4 * d4 + d5 * d5);
                int n6 = 0;
                while (n6 < n5) {
                    double d10 = d7 + (double)n6 * d8;
                    nArray[n6] = (int)((double)this.aPoints[n2] - d4 - d9 * Math.cos(d10));
                    nArray2[n6] = (int)((double)this.bPoints[n2] - d5 - d9 * Math.sin(d10));
                    ++n6;
                }
                nArray[n5] = this.aPoints[n];
                nArray2[n5] = this.bPoints[n];
                return 10;
            }
            case 2: 
            case 7: {
                nArray[0] = (int)d3;
                nArray2[0] = (int)d2;
                nArray[1] = (int)((double)this.aPoints[n2] - d4 - d5);
                nArray2[1] = (int)((double)this.bPoints[n2] - d5 + d4);
                nArray[2] = this.aPoints[n2];
                nArray2[2] = this.bPoints[n2];
                nArray[3] = (int)((double)this.aPoints[n2] - d4 + d5);
                nArray2[3] = (int)((double)this.bPoints[n2] - d5 - d4);
                nArray[4] = (int)d3;
                nArray2[4] = (int)d2;
                nArray[5] = this.aPoints[n];
                nArray2[5] = this.bPoints[n];
                return 6;
            }
            case 3: 
            case 8: {
                nArray[0] = (int)d3;
                nArray2[0] = (int)d2;
                nArray[1] = (int)(d3 - d5);
                nArray2[1] = (int)(d2 + d4);
                nArray[2] = (int)((double)this.aPoints[n2] - d5);
                nArray2[2] = (int)((double)this.bPoints[n2] + d4);
                nArray[3] = (int)((double)this.aPoints[n2] + d5);
                nArray2[3] = (int)((double)this.bPoints[n2] - d4);
                nArray[4] = (int)(d3 + d5);
                nArray2[4] = (int)(d2 - d4);
                nArray[5] = (int)d3;
                nArray2[5] = (int)d2;
                nArray[6] = this.aPoints[n];
                nArray2[6] = this.bPoints[n];
                return 7;
            }
            case 5: {
                nArray[0] = (int)((double)this.aPoints[n2] - d5);
                nArray2[0] = (int)((double)this.bPoints[n2] + d4);
                nArray[1] = (int)((double)this.aPoints[n2] + d5);
                nArray2[1] = (int)((double)this.bPoints[n2] - d4);
                nArray[2] = this.aPoints[n2];
                nArray2[2] = this.bPoints[n2];
                nArray[3] = this.aPoints[n];
                nArray2[3] = this.bPoints[n];
                return 4;
            }
            case 4: 
            case 9: 
        }
        nArray[0] = (int)d3;
        nArray2[0] = (int)d2;
        nArray[1] = (int)(d3 - d5);
        nArray2[1] = (int)(d2 + d4);
        nArray[2] = this.aPoints[n2];
        nArray2[2] = this.bPoints[n2];
        nArray[3] = (int)(d3 + d5);
        nArray2[3] = (int)(d2 - d4);
        nArray[4] = (int)d3;
        nArray2[4] = (int)d2;
        nArray[5] = this.aPoints[n];
        nArray2[5] = this.bPoints[n];
        return 6;
    }

    private void drawStart(Graphics2D graphics2D) {
        if (this.startType >= 6 && this.style.fillPattern != null) {
            Color color = graphics2D.getColor();
            graphics2D.setPaint(this.style.fillPattern);
            graphics2D.fillPolygon(this.startA, this.startB, this.startPoints - 1);
            graphics2D.setColor(color);
        }
        graphics2D.drawPolyline(this.startA, this.startB, this.startPoints);
        this.drawDash(graphics2D, this.aPoints[0], this.bPoints[0], this.aPoints[1], this.bPoints[1]);
    }

    private void drawEnd(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.endType >= 6 && this.style.fillPattern != null) {
            Color color = graphics2D.getColor();
            graphics2D.setPaint(this.style.fillPattern);
            graphics2D.fillPolygon(this.endA, this.endB, this.endPoints - 1);
            graphics2D.setColor(color);
        }
        graphics2D.drawPolyline(this.endA, this.endB, this.endPoints);
        this.drawDash(graphics2D, n, n2, n3, n4);
    }

    private void drawStartAndEnd(Graphics2D graphics2D) {
        if (this.style.fillPattern != null) {
            Color color = graphics2D.getColor();
            graphics2D.setPaint(this.style.fillPattern);
            if (this.startType >= 6) {
                graphics2D.fillPolygon(this.startA, this.startB, this.startPoints - 1);
            }
            if (this.endType >= 6) {
                graphics2D.fillPolygon(this.endA, this.endB, this.endPoints - 1);
            }
            graphics2D.setColor(color);
        }
        graphics2D.drawPolyline(this.startA, this.startB, this.startPoints - 1);
        graphics2D.drawPolyline(this.endA, this.endB, this.endPoints - 1);
        graphics2D.drawLine(this.startA[this.startPoints - 2], this.startB[this.startPoints - 2], this.endA[this.endPoints - 2], this.endB[this.endPoints - 2]);
        this.drawDash(graphics2D, this.startA[this.startPoints - 2], this.startB[this.startPoints - 2], this.endA[this.endPoints - 2], this.endB[this.endPoints - 2]);
    }

    private void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.drawLine(n, n2, n3, n4);
        this.drawDash(graphics2D, n, n2, n3, n4);
    }

    private void drawDash(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.neumaticDash == 0.0) {
            return;
        }
        if ((double)Math.max(Math.abs(n3 - n), Math.abs(n4 - n2)) < 2.82 * (double)this.dashSize) {
            return;
        }
        int n5 = (n + n3) / 2;
        int n6 = (n2 + n4) / 2;
        if (this.neumaticDash > 0.0) {
            graphics2D.drawLine(n5 - this.dashSize, n6 + this.dashSize, n5 + this.dashSize, n6 - this.dashSize);
        } else {
            graphics2D.drawLine(n5 - this.dashSize, n6 - this.dashSize, n5 + this.dashSize, n6 + this.dashSize);
        }
    }
}

