/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.NumericMethodException;
import org.opensourcephysics.numerics.Util;

public class Derivative {
    private Derivative() {
    }

    public static Function getFirst(final Function function, final double d) {
        return new Function(){

            public double evaluate(double d2) {
                return (function.evaluate(d2 + d) - function.evaluate(d2 - d)) / d / 2.0;
            }
        };
    }

    public static Function getSecond(final Function function, final double d) {
        return new Function(){

            public double evaluate(double d2) {
                return (function.evaluate(d2 + d) - 2.0 * function.evaluate(d2) + function.evaluate(d2 - d)) / d / d;
            }
        };
    }

    public static double romberg(Function function, double d, double d2, double d3) {
        int n = 6;
        double[] dArray = new double[n];
        dArray[0] = (function.evaluate(d + d2) - function.evaluate(d - d2)) / d2 / 2.0;
        int n2 = 1;
        int n3 = 1;
        while (n3 <= n - 1) {
            dArray[n3] = 0.0;
            double d4 = dArray[0];
            double d5 = d2;
            if ((d2 *= 0.5) < Util.defaultNumericalPrecision) {
                n2 = 2;
                break;
            }
            dArray[0] = (function.evaluate(d + d2) - function.evaluate(d - d2)) / d5;
            int n4 = 4;
            int n5 = 1;
            while (n5 <= n3) {
                double d6 = dArray[n5];
                dArray[n5] = ((double)n4 * dArray[n5 - 1] - d4) / (double)(n4 - 1);
                d4 = d6;
                ++n5;
                n4 *= 4;
            }
            if (Math.abs(dArray[n3] - dArray[n3 - 1]) < d3) {
                return dArray[n3];
            }
            ++n3;
        }
        throw new NumericMethodException("Derivative did not converge.", n2, dArray[0]);
    }

    public static double first(Function function, double d, double d2) {
        return (function.evaluate(d + d2) - function.evaluate(d - d2)) / d2 / 2.0;
    }

    public static double centered(Function function, double d, double d2) {
        return (function.evaluate(d + d2) - function.evaluate(d - d2)) / d2 / 2.0;
    }

    public static double backward(Function function, double d, double d2) {
        return (function.evaluate(d - 2.0 * d2) - 4.0 * function.evaluate(d - d2) + 3.0 * function.evaluate(d)) / d2 / 2.0;
    }

    public static double forward(Function function, double d, double d2) {
        return (-function.evaluate(d + 2.0 * d2) + 4.0 * function.evaluate(d + d2) - 3.0 * function.evaluate(d)) / d2 / 2.0;
    }

    public static double firstPartial(MultiVarFunction multiVarFunction, double[] dArray, int n, double d) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        int n2 = n;
        dArray2[n2] = dArray2[n2] + d;
        double[] dArray3 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        int n3 = n;
        dArray3[n3] = dArray3[n3] - d;
        return (multiVarFunction.evaluate(dArray2) - multiVarFunction.evaluate(dArray3)) / 2.0 / d;
    }

    public static double second(Function function, double d, double d2) {
        return (function.evaluate(d + d2) - 2.0 * function.evaluate(d) + function.evaluate(d - d2)) / d2 / d2;
    }
}

