/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class PBC {
    private PBC() {
    }

    public static double position(double d, double d2) {
        return d < 0.0 ? d % d2 + d2 : d % d2;
    }

    public static int position(int n, int n2) {
        return n < 0 ? (n + 1) % n2 + n2 - 1 : n % n2;
    }

    public static double separation(double d, double d2) {
        return d - d2 * Math.floor(d / d2 + 0.5);
    }

    public static int separation(int n, int n2) {
        if (n < 0) {
            return n + n2 * ((-2 * n + n2) / (2 * n2));
        }
        return n - n2 * ((2 * n + n2 - 1) / (2 * n2));
    }
}

