/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Vec3D;

public class ElementBox
extends Element
implements org.opensourcephysics.display3d.core.ElementBox {
    private boolean hasTop = true;
    private boolean hasBottom = true;
    private int theNx;
    private int theNy;
    private int theNz;
    private double[][][] data;
    private Vec3D[] normals;

    public ElementBox() {
        this.getStyle().setResolution(new Resolution(3, 3, 3));
        this.getStyle().setDrawingLines(false);
    }

    private void createStandardBox(int n, int n2, int n3, boolean bl, boolean bl2) {
        double d;
        int n4;
        double d2;
        int n5 = 2 * n * n3 + 2 * n2 * n3;
        if (bl2) {
            n5 += n * n2;
        }
        if (bl) {
            n5 += n * n2;
        }
        this.data = new double[n5][4][3];
        this.normals = new Vec3D[n5];
        int n6 = 0;
        double d3 = 1.0 / (double)n;
        double d4 = 1.0 / (double)n2;
        double d5 = 1.0 / (double)n3;
        int n7 = 0;
        while (n7 < n) {
            d2 = (double)n7 * d3 - 0.5;
            n4 = 0;
            while (n4 < n2) {
                d = (double)n4 * d4 - 0.5;
                if (bl2) {
                    this.normals[n6] = new Vec3D(0.0, 0.0, -1.0);
                    this.data[n6][3][0] = d2;
                    this.data[n6][3][1] = d;
                    this.data[n6][3][2] = -0.5;
                    this.data[n6][2][0] = d2 + d3;
                    this.data[n6][2][1] = d;
                    this.data[n6][2][2] = -0.5;
                    this.data[n6][1][0] = d2 + d3;
                    this.data[n6][1][1] = d + d4;
                    this.data[n6][1][2] = -0.5;
                    this.data[n6][0][0] = d2;
                    this.data[n6][0][1] = d + d4;
                    this.data[n6][0][2] = -0.5;
                    ++n6;
                }
                if (bl) {
                    this.normals[n6] = new Vec3D(0.0, 0.0, 1.0);
                    this.data[n6][0][0] = d2;
                    this.data[n6][0][1] = d;
                    this.data[n6][0][2] = 0.5;
                    this.data[n6][1][0] = d2 + d3;
                    this.data[n6][1][1] = d;
                    this.data[n6][1][2] = 0.5;
                    this.data[n6][2][0] = d2 + d3;
                    this.data[n6][2][1] = d + d4;
                    this.data[n6][2][2] = 0.5;
                    this.data[n6][3][0] = d2;
                    this.data[n6][3][1] = d + d4;
                    this.data[n6][3][2] = 0.5;
                    ++n6;
                }
                ++n4;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n) {
            d2 = (double)n7 * d3 - 0.5;
            n4 = 0;
            while (n4 < n3) {
                this.normals[n6] = new Vec3D(-1.0, 0.0, 0.0);
                d = (double)n4 * d5 - 0.5;
                this.data[n6][0][0] = d2;
                this.data[n6][0][2] = d;
                this.data[n6][0][1] = -0.5;
                this.data[n6][1][0] = d2 + d3;
                this.data[n6][1][2] = d;
                this.data[n6][1][1] = -0.5;
                this.data[n6][2][0] = d2 + d3;
                this.data[n6][2][2] = d + d5;
                this.data[n6][2][1] = -0.5;
                this.data[n6][3][0] = d2;
                this.data[n6][3][2] = d + d5;
                this.data[n6][3][1] = -0.5;
                this.normals[++n6] = new Vec3D(1.0, 0.0, 0.0);
                this.data[n6][3][0] = d2;
                this.data[n6][3][2] = d;
                this.data[n6][3][1] = 0.5;
                this.data[n6][2][0] = d2 + d3;
                this.data[n6][2][2] = d;
                this.data[n6][2][1] = 0.5;
                this.data[n6][1][0] = d2 + d3;
                this.data[n6][1][2] = d + d5;
                this.data[n6][1][1] = 0.5;
                this.data[n6][0][0] = d2;
                this.data[n6][0][2] = d + d5;
                this.data[n6][0][1] = 0.5;
                ++n6;
                ++n4;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            d2 = (double)n7 * d5 - 0.5;
            n4 = 0;
            while (n4 < n2) {
                this.normals[n6] = new Vec3D(0.0, -1.0, 0.0);
                d = (double)n4 * d4 - 0.5;
                this.data[n6][0][2] = d2;
                this.data[n6][0][1] = d;
                this.data[n6][0][0] = -0.5;
                this.data[n6][1][2] = d2 + d5;
                this.data[n6][1][1] = d;
                this.data[n6][1][0] = -0.5;
                this.data[n6][2][2] = d2 + d5;
                this.data[n6][2][1] = d + d4;
                this.data[n6][2][0] = -0.5;
                this.data[n6][3][2] = d2;
                this.data[n6][3][1] = d + d4;
                this.data[n6][3][0] = -0.5;
                this.normals[++n6] = new Vec3D(0.0, 1.0, 0.0);
                this.data[n6][3][2] = d2;
                this.data[n6][3][1] = d;
                this.data[n6][3][0] = 0.5;
                this.data[n6][2][2] = d2 + d5;
                this.data[n6][2][1] = d;
                this.data[n6][2][0] = 0.5;
                this.data[n6][1][2] = d2 + d5;
                this.data[n6][1][1] = d + d4;
                this.data[n6][1][0] = 0.5;
                this.data[n6][0][2] = d2;
                this.data[n6][0][1] = d + d4;
                this.data[n6][0][0] = 0.5;
                ++n6;
                ++n4;
            }
            ++n7;
        }
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        int n;
        int n2;
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        gL.glScaled(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        if (this.getStyle().isDrawingFill()) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getRGBComponents(null), 0);
            this.checkData();
            gL.glDisable(2884);
            this.preFillGL(gLAutoDrawable);
            n2 = 0;
            while (n2 < this.data.length) {
                gL.glBegin(7);
                gL.glNormal3d(this.normals[n2].x, this.normals[n2].y, this.normals[n2].z);
                n = this.data[n2].length - 1;
                while (n >= 0) {
                    gL.glVertex3dv(this.data[n2][n], 0);
                    --n;
                }
                gL.glEnd();
                ++n2;
            }
        }
        if (this.getStyle().isDrawingLines()) {
            this.checkData();
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getRGBComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
            this.preLinesGL(gLAutoDrawable);
            n2 = 0;
            while (n2 < this.data.length) {
                gL.glBegin(2);
                n = 0;
                while (n < this.data[n2].length) {
                    gL.glVertex3dv(this.data[n2][n], 0);
                    ++n;
                }
                gL.glEnd();
                ++n2;
            }
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    private void checkData() {
        if (this.data == null) {
            Resolution resolution = this.getStyle().getResolution();
            switch (resolution.getType()) {
                case 0: {
                    this.theNx = Math.max(resolution.getN1(), 1);
                    this.theNy = Math.max(resolution.getN2(), 1);
                    this.theNz = Math.max(resolution.getN3(), 1);
                    break;
                }
                default: {
                    this.theNx = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeX()) / resolution.getMaxLength()), 1);
                    this.theNy = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeY()) / resolution.getMaxLength()), 1);
                    this.theNz = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
            this.createStandardBox(this.theNx, this.theNy, this.theNz, this.hasTop, this.hasBottom);
        }
    }

    public void setClosedBottom(boolean bl) {
        this.hasBottom = bl;
    }

    public boolean isClosedBottom() {
        return this.hasBottom;
    }

    public void setClosedTop(boolean bl) {
        this.hasTop = bl;
    }

    public boolean isClosedTop() {
        return this.hasTop;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingFill()) {
            if (this.getStyle().getFillColor().getAlpha() < 255) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

