/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLUquadric;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

public class ElementCylinder
extends Element
implements org.opensourcephysics.display3d.core.ElementCylinder {
    private boolean isClosedTop;
    private boolean isClosedBottom;
    public double[] rotationMatrix;
    private static GLUquadric quadObj;

    public ElementCylinder() {
        this.getStyle().setFillColor(Color.blue);
        this.getStyle().setResolution(new Resolution(20, 20, 0));
        this.getStyle().setDrawingLines(false);
        this.isClosedBottom = true;
        this.isClosedTop = true;
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        gL.glTranslated(0.0, 0.0, -this.getSizeZ() / 2.0);
        gL.glScaled(1.0, this.getSizeY() / this.getSizeX(), 1.0);
        if (this.getStyle().isDrawingFill()) {
            this.drawCylinder(gLAutoDrawable, true);
        }
        if (this.getStyle().isDrawingLines()) {
            this.drawCylinder(gLAutoDrawable, false);
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    private void drawCylinder(GLAutoDrawable gLAutoDrawable, boolean bl) {
        double d;
        double d2;
        int n;
        int n2;
        GL gL = gLAutoDrawable.getGL();
        gL.glEnable(2896);
        if (bl) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
        } else {
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
        }
        if (this.getStyle().getResolution().getType() == 1) {
            n2 = (int)Math.floor(Math.min(this.getSizeX(), this.getSizeZ()) / this.getStyle().getResolution().getMaxLength());
            n = (int)Math.floor(this.getSizeY() / this.getStyle().getResolution().getMaxLength());
        } else {
            n2 = this.getStyle().getResolution().getN2();
            n = this.getStyle().getResolution().getN3();
        }
        n2 = Math.max(3, n2);
        n = Math.max(1, n);
        if (!this.isClosedTop || !this.isClosedBottom) {
            gL.glDisable(2884);
        }
        if (bl) {
            this.preFillGL(gLAutoDrawable);
        } else {
            this.preLinesGL(gLAutoDrawable);
        }
        ElementCylinder.quadObjInit();
        GLTools.GLU.gluQuadricDrawStyle(quadObj, bl ? 100012 : 100011);
        GLTools.GLU.gluQuadricNormals(quadObj, 100000);
        int n3 = bl ? -90 : 0;
        gL.glRotated((double)n3, 0.0, 0.0, 1.0);
        GLTools.GLU.gluCylinder(quadObj, this.getSizeX() / 2.0, this.getSizeX() / 2.0, this.getSizeZ(), n2, n);
        gL.glRotated((double)(-n3), 0.0, 0.0, 1.0);
        if (this.isClosedBottom) {
            gL.glBegin(bl ? 9 : 2);
            gL.glNormal3d(0.0, 0.0, -1.0);
            d2 = 360.0;
            while (d2 >= 0.0) {
                d = d2 * Math.PI / 180.0;
                gL.glVertex3d(Math.cos(d) * this.getSizeX() / 2.0, Math.sin(d) * this.getSizeX() / 2.0, 0.0);
                d2 -= 360.0 / (double)n2;
            }
            gL.glEnd();
        }
        if (this.isClosedTop) {
            gL.glTranslated(0.0, 0.0, this.getSizeZ());
            gL.glNormal3d(0.0, 0.0, 1.0);
            gL.glBegin(bl ? 9 : 2);
            d2 = 0.0;
            while (d2 < 360.0) {
                d = d2 * Math.PI / 180.0;
                gL.glVertex3d(Math.cos(d) * this.getSizeX() / 2.0, Math.sin(d) * this.getSizeX() / 2.0, 0.0);
                d2 += 360.0 / (double)n2;
            }
            gL.glEnd();
            gL.glTranslated(0.0, 0.0, -this.getSizeZ());
        }
    }

    private static void quadObjInit() {
        if (quadObj == null) {
            quadObj = GLTools.GLU.gluNewQuadric();
        }
        if (quadObj == null) {
            throw new GLException("Out of memory");
        }
    }

    public void setMinimumAngle(int n) {
    }

    public int getMinimumAngle() {
        return 0;
    }

    public void setMaximumAngle(int n) {
    }

    public int getMaximumAngle() {
        return 0;
    }

    public void setClosedBottom(boolean bl) {
        this.isClosedBottom = bl;
    }

    public boolean isClosedBottom() {
        return this.isClosedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.isClosedTop = bl;
    }

    public boolean isClosedTop() {
        return this.isClosedTop;
    }

    public void setClosedLeft(boolean bl) {
    }

    public boolean isClosedLeft() {
        return true;
    }

    public void setClosedRight(boolean bl) {
    }

    public boolean isClosedRight() {
        return true;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingFill()) {
            if (this.getStyle().getFillColor().getAlpha() < 255) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

