/*
 * Decompiled with CFR 0.152.
 */
package EP.EP_chapter17.capacitor_v2;

import EP.EP_chapter17.capacitor_v2.capacitor_v2Simulation;
import EP.EP_chapter17.capacitor_v2.capacitor_v2View;
import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class capacitor_v2
extends AbstractModel {
    public capacitor_v2Simulation _simulation = null;
    public capacitor_v2View _view = null;
    public capacitor_v2 _model = this;
    public double Q = 1.0;
    public double V = 1.0;
    public double C = 1.0;
    public double E = 1.0;
    public double U = 1.0;
    public double K = 1.0;
    public double d = 0.3;
    public boolean batteryflag = true;
    public boolean switchopenflag = false;
    public String helpLabel = "Show Help";
    public boolean helpFlag = false;
    public int redness = 100;
    public int greenness = 100;
    public int blueness = 100;
    public Object dielectricColor = null;
    public double colorValue = 0.0;
    public double switchlengthx = 0.0;
    public double switchlengthy = 0.2;
    public double switchlengthx2 = 0.0;
    public double switchlengthy2 = 0.2;
    public double switchlengthx3 = -0.14;
    public double switchlengthy3 = 0.14;
    public int number;
    public int i = this.number = 16;
    public boolean[] fieldflag;
    public double[] fieldy;
    public double[] field2y;
    public double ymaximum = 0.0;
    public double yspacing = 0.0;

    public static String _getEjsModel() {
        return "EP/EP_chapter17/capacitor_v2.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("EP/EP_chapter17/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/Documents and Settings/andrew/Desktop/Ejs2008/Ejs_4.0/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/Documents and Settings/andrew/Desktop/Ejs2008/Ejs_4.0/bin/");
        }
        capacitor_v2 capacitor_v22 = new capacitor_v2(stringArray);
    }

    public capacitor_v2() {
        this(null, null, null, null, null, false);
    }

    public capacitor_v2(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public capacitor_v2(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new capacitor_v2Simulation(this, string, frame, uRL, bl);
        this._view = (capacitor_v2View)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.dielectricColor = new Color(this.redness, this.greenness, this.blueness);
    }

    public void _constraints1() {
        this.C = this.K * 0.3 / this.d;
        if (this.batteryflag) {
            this.V = 1.0;
            this.Q = this.C * this.V;
        } else {
            this.V = this.Q / this.C;
        }
        this.E = 0.3 * this.V / this.d;
        this.U = this.Q * this.V;
        this.ymaximum = 7.5 / this.E;
        this.yspacing = this.ymaximum / (double)this.number;
        this.i = 0;
        while (this.i < this.number) {
            this.fieldy[this.i] = 0.5 * this.yspacing + (double)this.i * this.yspacing;
            this.field2y[this.i] = -1.0 * this.fieldy[this.i];
            this.fieldflag[this.i] = true;
            if (this.fieldy[this.i] > 0.5) {
                this.fieldflag[this.i] = false;
            }
            ++this.i;
        }
    }

    public void _method_for_close_actionon() {
        this._simulation.disableLoop();
        this.switchlengthx = this.switchlengthx2;
        this.switchlengthy = this.switchlengthy2;
        this._simulation.enableLoop();
    }

    public void _method_for_close_actionoff() {
        this._simulation.disableLoop();
        this.switchopenflag = true;
        this.switchlengthx = this.switchlengthx3;
        this.switchlengthy = this.switchlengthy3;
        this._simulation.enableLoop();
    }

    public void _method_for_open_actionon() {
        this._simulation.disableLoop();
        this.batteryflag = false;
        this.switchlengthx = this.switchlengthx3;
        this.switchlengthy = this.switchlengthy3;
        this._simulation.enableLoop();
    }

    public void _method_for_open_actionoff() {
        this._simulation.disableLoop();
        this.batteryflag = true;
        this.switchlengthx = this.switchlengthx2;
        this.switchlengthy = this.switchlengthy2;
        this._simulation.enableLoop();
    }

    public void _method_for_dielectric_dragaction() {
        this._simulation.disableLoop();
        this.greenness = (int)(100.0 + 36.0 * (this.K - 1.0));
        this.dielectricColor = new Color(this.redness, this.greenness, this.blueness);
        this._simulation.enableLoop();
    }

    public void _method_for_dielectric_action() {
        this._simulation.disableLoop();
        this.greenness = (int)(100.0 + 36.0 * (this.K - 1.0));
        this.dielectricColor = new Color(this.redness, this.greenness, this.blueness);
        this._simulation.enableLoop();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_instructions_action() {
        this._simulation.disableLoop();
        if (this.helpFlag) {
            this.helpFlag = false;
            this.helpLabel = "Show Help";
        } else {
            this.helpFlag = true;
            this.helpLabel = "Hide Help";
        }
        this._simulation.enableLoop();
    }

    public double _method_for_rightplate_x() {
        return this.d / 2.0;
    }

    public double _method_for_leftplate_x() {
        return -this.d / 2.0;
    }

    public double _method_for_switch3_x() {
        return -0.34 + this.switchlengthx3;
    }

    public double _method_for_switch3_y() {
        return 0.3 + this.switchlengthy3;
    }

    public double _method_for_plusvectors_x() {
        return -this.d / 2.0;
    }

    public double _method_for_minusvectors_x() {
        return -this.d / 2.0;
    }

    public void _method_for_helpBox_onClosing() {
        this._simulation.disableLoop();
        this.helpFlag = false;
        this.helpLabel = "Show Help";
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.Q = 1.0;
        this.V = 1.0;
        this.C = 1.0;
        this.E = 1.0;
        this.U = 1.0;
        this.K = 1.0;
        this.d = 0.3;
        this.batteryflag = true;
        this.switchopenflag = false;
        this.helpLabel = "Show Help";
        this.helpFlag = false;
        this.redness = 100;
        this.greenness = 100;
        this.blueness = 100;
        this.colorValue = 0.0;
        this.switchlengthx = 0.0;
        this.switchlengthy = 0.2;
        this.switchlengthx2 = 0.0;
        this.switchlengthy2 = 0.2;
        this.switchlengthx3 = -0.14;
        this.switchlengthy3 = 0.14;
        this.i = this.number = 16;
        this.fieldflag = new boolean[this.number];
        for (n = 0; n < this.number; ++n) {
            this.fieldflag[n] = true;
        }
        this.fieldy = new double[this.number];
        for (n = 0; n < this.number; ++n) {
            this.fieldy[n] = 0.0;
        }
        this.field2y = new double[this.number];
        for (n = 0; n < this.number; ++n) {
            this.field2y[n] = 0.0;
        }
        this.ymaximum = 0.0;
        this.yspacing = 0.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.fieldflag = null;
        this.fieldy = null;
        this.field2y = null;
        System.gc();
    }
}

