/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetElementPosition
implements InteractionTarget {
    protected InteractiveElement element;

    InteractionTargetElementPosition(InteractiveElement interactiveElement) {
        this.element = interactiveElement;
    }

    public InteractionSource getSource() {
        return this.element;
    }

    public Point3D getHotspot(DrawingPanel drawingPanel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX(), this.element.getY(), this.element.getZ());
        }
        return new Point3D(this.element.getGroup().getX() + this.element.getX() * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + this.element.getY() * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + this.element.getZ() * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel drawingPanel, Point3D point3D) {
        if (this.element.getGroup() == null) {
            this.element.setXYZ(point3D.x, point3D.y, point3D.z);
        } else if (this.element.isGroupEnabled(0)) {
            this.element.getGroup().setXYZ(point3D.x - this.element.getX() * this.element.getGroup().getSizeX(), point3D.y - this.element.getY() * this.element.getGroup().getSizeY(), point3D.z - this.element.getZ() * this.element.getGroup().getSizeZ());
        } else {
            double d = this.element.getGroup().getSizeX();
            double d2 = this.element.getGroup().getSizeY();
            double d3 = this.element.getGroup().getSizeZ();
            d = d == 0.0 ? this.element.getX() : (point3D.x - this.element.getGroup().getX()) / d;
            d2 = d2 == 0.0 ? this.element.getY() : (point3D.y - this.element.getGroup().getY()) / d2;
            d3 = d3 == 0.0 ? this.element.getZ() : (point3D.z - this.element.getGroup().getZ()) / d3;
            this.element.setXYZ(d, d2, d3);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return this.element;
    }

    public void setEnabled(boolean bl) {
        this.element.setEnabled(0, bl);
    }

    public boolean isEnabled() {
        return this.element.isEnabled(0);
    }

    public void setXY(double d, double d2) {
        this.element.setXY(d, d2);
    }

    public void setX(double d) {
        this.element.setX(d);
    }

    public void setY(double d) {
        this.element.setY(d);
    }

    public double getX() {
        return this.element.getX();
    }

    public double getY() {
        return this.element.getY();
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.element.getXMin();
    }

    public double getXMax() {
        return this.element.getXMax();
    }

    public double getYMin() {
        return this.element.getYMin();
    }

    public double getYMax() {
        return this.element.getYMax();
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.element.draw(drawingPanel, graphics);
    }
}

