/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Adams4;
import org.opensourcephysics.numerics.Adams5;
import org.opensourcephysics.numerics.Adams6;
import org.opensourcephysics.numerics.Butcher5;
import org.opensourcephysics.numerics.CashKarp45;
import org.opensourcephysics.numerics.DormandPrince45;
import org.opensourcephysics.numerics.Euler;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.Fehlberg8;
import org.opensourcephysics.numerics.Heun3;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.Ralston2;
import org.opensourcephysics.numerics.Verlet;

public class ODESolverFactory {
    private ODESolverFactory() {
    }

    public static ODESolver createODESolver(ODE oDE, String string) {
        if ((string = string.trim().toLowerCase()).equals("rk4")) {
            return new RK4(oDE);
        }
        if (string.equals("multistep")) {
            return new ODEMultistepSolver(oDE);
        }
        if (string.equals("adams4")) {
            return new Adams4(oDE);
        }
        if (string.equals("adams5")) {
            return new Adams5(oDE);
        }
        if (string.equals("adams6")) {
            return new Adams6(oDE);
        }
        if (string.equals("butcher5")) {
            return new Butcher5(oDE);
        }
        if (string.equals("cashkarp45")) {
            return new CashKarp45(oDE);
        }
        if (string.equals("dormandprince45")) {
            return new DormandPrince45(oDE);
        }
        if (string.equals("eulerrichardson")) {
            return new EulerRichardson(oDE);
        }
        if (string.equals("euler")) {
            return new Euler(oDE);
        }
        if (string.equals("fehlberg8")) {
            return new Fehlberg8(oDE);
        }
        if (string.equals("heun3")) {
            return new Heun3(oDE);
        }
        if (string.equals("ralston2")) {
            return new Ralston2(oDE);
        }
        if (string.equals("verlet")) {
            return new Verlet(oDE);
        }
        return null;
    }
}

