/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.LAComplexEquation;
import org.opensourcephysics.ode.IRK.LAEComplexSolverLU;
import org.opensourcephysics.ode.IRK.LAESolverLU;
import org.opensourcephysics.ode.IRK.LAEquation;

public class IRKSimplifiedNewtonStep
implements AlgebraicEquationSimpleSolver {
    protected double uround = 2.220446049250313E-16;
    private IRKAlgebraicEquation eqn;
    private int numEqn;
    private InnerLinearAlgebraicEquation innerLinearAlgebraicEquation;
    private LAESolverLU laeSolver;
    private LAEComplexSolverLU laeComplexSolver;
    private double[][] temporary;
    private double multiplier = 1.0;
    private boolean bestConvergenceRequired;
    private boolean refreshLAEsMatrixes;
    private double[][] substitutedApproximation;
    private double[][] approximation;
    private double[][] substitutedApproximationIncrement;
    private double incrementNormOnPreviousStep = 1.0;

    public IRKSimplifiedNewtonStep(IRKAlgebraicEquation iRKAlgebraicEquation) {
        this.eqn = iRKAlgebraicEquation;
        this.numEqn = iRKAlgebraicEquation.getApproximation()[0].length;
        this.innerLinearAlgebraicEquation = new InnerLinearAlgebraicEquation();
        this.initialize(new LAESolverLU(this.innerLinearAlgebraicEquation));
    }

    public IRKSimplifiedNewtonStep(IRKAlgebraicEquation iRKAlgebraicEquation, LAESolverLU lAESolverLU) {
        this.eqn = iRKAlgebraicEquation;
        this.numEqn = iRKAlgebraicEquation.getApproximation()[0].length;
        this.innerLinearAlgebraicEquation = new InnerLinearAlgebraicEquation();
        this.initialize(lAESolverLU);
    }

    private void initialize(LAESolverLU lAESolverLU) {
        this.laeSolver = lAESolverLU;
        lAESolverLU.assignEquation(this.innerLinearAlgebraicEquation);
        this.laeComplexSolver = new LAEComplexSolverLU(this.innerLinearAlgebraicEquation);
        this.approximation = this.eqn.getApproximation();
        this.temporary = new double[3][this.numEqn];
        this.substitutedApproximation = new double[3][this.numEqn];
        this.substitutedApproximationIncrement = new double[3][this.numEqn];
        this.refreshLAEsMatrixes = true;
        this.bestConvergenceRequired = true;
    }

    public void updateInitialValue() {
        this.eqn.directChangeOfVariables(this.approximation, this.substitutedApproximation);
    }

    public void restart(boolean bl) {
        this.refreshLAEsMatrixes = this.multiplier != this.eqn.getScalarMultiplier();
        this.eqn.directChangeOfVariables(this.approximation, this.substitutedApproximation);
        this.bestConvergenceRequired = bl;
        this.incrementNormOnPreviousStep = 0.0;
    }

    protected double[][] getSubstitutedApproximationIncrement() {
        return this.substitutedApproximationIncrement;
    }

    public double singleStep() {
        this.multiplier = this.eqn.getScalarMultiplier();
        this.innerLinearAlgebraicEquation.initialize();
        if (this.refreshLAEsMatrixes || this.bestConvergenceRequired) {
            this.laeSolver.initialize();
            this.laeComplexSolver.initialize();
        }
        this.laeSolver.resolve(this.substitutedApproximationIncrement[0]);
        this.laeComplexSolver.resolve(this.substitutedApproximationIncrement[1], this.substitutedApproximationIncrement[2]);
        this.refreshLAEsMatrixes = false;
        this.bestConvergenceRequired = false;
        double d = this.estimateIncrementNorm(this.substitutedApproximationIncrement);
        double d2 = this.incrementNormOnPreviousStep != 0.0 ? d / this.incrementNormOnPreviousStep : 0.001;
        this.incrementNormOnPreviousStep = Math.max(d, this.uround);
        return d2;
    }

    protected void commitStep() {
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < this.numEqn) {
                double[] dArray = this.substitutedApproximation[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] + this.substitutedApproximationIncrement[n][n2];
                ++n2;
            }
            ++n;
        }
        this.eqn.inverseChangeOfVariables(this.substitutedApproximation, this.approximation);
    }

    public double resolve() {
        double d = this.singleStep();
        this.commitStep();
        return d;
    }

    protected double estimateIncrementNorm(double[][] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.numEqn) {
            int n2 = 0;
            while (n2 < 3) {
                d += Math.pow(dArray[n2][n], 2.0);
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d / (double)(3 * this.numEqn));
    }

    private class InnerLinearAlgebraicEquation
    implements LAEquation,
    LAComplexEquation {
        private double[][] jac;
        private double[] realEigenvalues;
        private double[] complexEigenvalues;
        private double[][] substitutedNonLinearComponent;

        public InnerLinearAlgebraicEquation() {
            this.realEigenvalues = IRKSimplifiedNewtonStep.this.eqn.getRealEigenvalues();
            this.complexEigenvalues = IRKSimplifiedNewtonStep.this.eqn.getComplexEigenvalues();
            this.substitutedNonLinearComponent = new double[3][IRKSimplifiedNewtonStep.this.numEqn];
            this.jac = new double[IRKSimplifiedNewtonStep.this.numEqn][IRKSimplifiedNewtonStep.this.numEqn];
        }

        public void initialize() {
            int n = 0;
            while (n < 3) {
                IRKSimplifiedNewtonStep.this.eqn.evaluateNonLinearComponent(IRKSimplifiedNewtonStep.this.approximation[n], IRKSimplifiedNewtonStep.this.temporary[n]);
                ++n;
            }
            IRKSimplifiedNewtonStep.this.eqn.directChangeOfVariables(IRKSimplifiedNewtonStep.this.temporary, this.substitutedNonLinearComponent);
            if (IRKSimplifiedNewtonStep.this.bestConvergenceRequired) {
                IRKSimplifiedNewtonStep.this.eqn.evaluateNonLinearComponentJacobian(IRKSimplifiedNewtonStep.this.approximation[2], this.jac);
            }
        }

        public int getDimension() {
            return IRKSimplifiedNewtonStep.this.numEqn;
        }

        public void getMatrix(double[][] dArray) {
            int n = 0;
            while (n < IRKSimplifiedNewtonStep.this.numEqn) {
                int n2 = 0;
                while (n2 < IRKSimplifiedNewtonStep.this.numEqn) {
                    dArray[n][n2] = -this.jac[n][n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                int n3 = n++;
                dArray2[n3] = dArray2[n3] + IRKSimplifiedNewtonStep.this.multiplier * this.realEigenvalues[0];
            }
        }

        public void getMatrixes(double[][] dArray, double[][] dArray2) {
            int n = 0;
            while (n < IRKSimplifiedNewtonStep.this.numEqn) {
                int n2 = 0;
                while (n2 < IRKSimplifiedNewtonStep.this.numEqn) {
                    dArray[n][n2] = -this.jac[n][n2];
                    dArray2[n][n2] = 0.0;
                    ++n2;
                }
                double[] dArray3 = dArray[n];
                int n3 = n;
                dArray3[n3] = dArray3[n3] + IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[0];
                double[] dArray4 = dArray2[n];
                int n4 = n++;
                dArray4[n4] = dArray4[n4] + IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[1];
            }
        }

        public void getVector(double[] dArray) {
            int n = 0;
            while (n < IRKSimplifiedNewtonStep.this.numEqn) {
                double d = IRKSimplifiedNewtonStep.this.multiplier * this.realEigenvalues[0];
                dArray[n] = this.substitutedNonLinearComponent[0][n] - d * IRKSimplifiedNewtonStep.this.substitutedApproximation[0][n];
                ++n;
            }
        }

        public void getVectors(double[] dArray, double[] dArray2) {
            int n = 0;
            while (n < IRKSimplifiedNewtonStep.this.numEqn) {
                double d = IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[0];
                double d2 = IRKSimplifiedNewtonStep.this.multiplier * this.complexEigenvalues[1];
                double d3 = -IRKSimplifiedNewtonStep.this.substitutedApproximation[1][n];
                double d4 = -IRKSimplifiedNewtonStep.this.substitutedApproximation[2][n];
                dArray[n] = this.substitutedNonLinearComponent[1][n];
                dArray2[n] = this.substitutedNonLinearComponent[2][n];
                int n2 = n;
                dArray[n2] = dArray[n2] + (d3 * d - d4 * d2);
                int n3 = n++;
                dArray2[n3] = dArray2[n3] + (d4 * d + d3 * d2);
            }
        }
    }
}

