/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.ode.Dopri5;
import org.opensourcephysics.ode.Dopri853;
import org.opensourcephysics.ode.IRK.Radau5;
import org.opensourcephysics.ode.ODEInterpolator;

public class ODEInterpolationSolver
implements org.opensourcephysics.numerics.ODEInterpolationSolver,
ODE {
    private double fixedStepSize;
    private double remainder;
    private double takenStepSize;
    private double[] odeSolverState;
    private ODEInterpolator solverCore;
    private ODE userODE;

    private ODEInterpolationSolver() {
        this.remainder = this.fixedStepSize = 0.1;
        this.takenStepSize = 0.0;
        this.remainder = this.fixedStepSize;
    }

    public ODEInterpolationSolver(ODE oDE) {
        this.remainder = this.fixedStepSize = 0.1;
        this.takenStepSize = 0.0;
        this.odeSolverState = new double[oDE.getState().length];
        this.solverCore = new Dopri853(this.setODE(oDE));
        this.initialize(0.1);
    }

    public ODEInterpolationSolver(ODE oDE, String string) {
        this.remainder = this.fixedStepSize = 0.1;
        this.takenStepSize = 0.0;
        this.odeSolverState = new double[oDE.getState().length];
        this.solverCore = "dopri5".equalsIgnoreCase(string) ? new Dopri5(this.setODE(oDE)) : ("radau5".equalsIgnoreCase(string) ? new Radau5(this.setODE(oDE)) : new Dopri853(this.setODE(oDE)));
        this.initialize(0.1);
    }

    public static ODEAdaptiveSolver Dopri5(ODE oDE) {
        ODEInterpolationSolver oDEInterpolationSolver = new ODEInterpolationSolver(oDE);
        oDEInterpolationSolver.solverCore = new Dopri5(oDEInterpolationSolver.setODE(oDE));
        return oDEInterpolationSolver;
    }

    public static ODEAdaptiveSolver Dopri853(ODE oDE) {
        ODEInterpolationSolver oDEInterpolationSolver = new ODEInterpolationSolver(oDE);
        oDEInterpolationSolver.solverCore = new Dopri853(oDEInterpolationSolver.setODE(oDE));
        return oDEInterpolationSolver;
    }

    public static ODEAdaptiveSolver Radau5(ODE oDE) {
        ODEInterpolationSolver oDEInterpolationSolver = new ODEInterpolationSolver(oDE);
        oDEInterpolationSolver.solverCore = new Radau5(oDEInterpolationSolver.setODE(oDE));
        return oDEInterpolationSolver;
    }

    public void initialize(double d) {
        this.remainder = this.fixedStepSize = d;
        System.arraycopy(this.userODE.getState(), 0, this.odeSolverState, 0, this.odeSolverState.length);
        this.solverCore.initialize(0.1);
    }

    public double step() {
        while (this.fixedStepSize * this.remainder > 0.0) {
            this.takenStepSize = this.solverCore.step();
            this.remainder -= this.takenStepSize;
        }
        this.solverCore.doInterpolation(this.remainder + this.takenStepSize, this.userODE.getState());
        this.remainder += this.fixedStepSize;
        return this.fixedStepSize;
    }

    public int getErrorCode() {
        return this.solverCore.getErrorCode();
    }

    public void getRate(double[] dArray, double[] dArray2) {
        this.userODE.getRate(dArray, dArray2);
    }

    public double[] getState() {
        return this.odeSolverState;
    }

    public double getStepSize() {
        return this.fixedStepSize;
    }

    public double getTolerance() {
        return this.solverCore.getTolerance();
    }

    private ODE setODE(ODE oDE) {
        this.userODE = oDE;
        System.arraycopy(oDE.getState(), 0, this.odeSolverState, 0, this.odeSolverState.length);
        return this;
    }

    public void setStepSize(double d) {
        if (d == 0.0) {
            System.err.println("Error: The stepsize in ODE solvers cannot be zero.");
            d = 0.1;
        }
        if (this.fixedStepSize * d < 0.0) {
            this.solverCore.setStepSize(-this.solverCore.getStepSize());
        }
        this.remainder += d - this.fixedStepSize;
        this.fixedStepSize = d;
    }

    public void setTolerance(double d) {
        this.solverCore.setTolerance(d);
    }
}

