/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;

public class Parameter {
    final String paramName;
    final String expression;
    String description;
    double value = Double.NaN;
    boolean expressionEditable = true;
    boolean nameEditable = true;

    public Parameter(String string, String string2) {
        this.paramName = string;
        this.expression = string2;
    }

    public Parameter(String string, String string2, String string3) {
        this(string, string2);
        this.setDescription(string3);
    }

    public String getName() {
        return this.paramName;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isExpressionEditable() {
        return this.expressionEditable;
    }

    public void setExpressionEditable(boolean bl) {
        this.expressionEditable = bl;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean bl) {
        this.nameEditable = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            return parameter.getName().equals(this.paramName) && parameter.getExpression().equals(this.expression) && parameter.isExpressionEditable() == this.expressionEditable && parameter.isNameEditable() == this.nameEditable;
        }
        return false;
    }

    protected double evaluate(List list) {
        int n = list.contains(this) ? list.size() - 1 : list.size();
        Parameter[] parameterArray = new Parameter[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            Parameter parameter = (Parameter)list.get(n3);
            if (parameter != this) {
                parameterArray[n2++] = parameter;
            }
            ++n3;
        }
        return this.evaluate(parameterArray);
    }

    public double evaluate(Parameter[] parameterArray) {
        int n = parameterArray.length;
        String[] stringArray = new String[n];
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = parameterArray[n2].paramName;
            dArray[n2] = parameterArray[n2].value;
            ++n2;
        }
        try {
            ParsedMultiVarFunction parsedMultiVarFunction = new ParsedMultiVarFunction(this.expression, stringArray);
            this.value = parsedMultiVarFunction.evaluate(dArray);
        }
        catch (ParserException parserException) {
            this.value = Double.NaN;
        }
        return this.value;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Parameter parameter = (Parameter)object;
            xMLControl.setValue("name", parameter.getName());
            xMLControl.setValue("function", parameter.getExpression());
            xMLControl.setValue("editable", parameter.isExpressionEditable());
            xMLControl.setValue("name_editable", parameter.isNameEditable());
            xMLControl.setValue("description", parameter.getDescription());
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            String string2 = xMLControl.getString("function");
            return new Parameter(string, string2);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Parameter parameter = (Parameter)object;
            if (xMLControl.getPropertyNames().contains("editable")) {
                parameter.setExpressionEditable(xMLControl.getBoolean("editable"));
            }
            if (xMLControl.getPropertyNames().contains("name_editable")) {
                parameter.setNameEditable(xMLControl.getBoolean("name_editable"));
            }
            parameter.setDescription(xMLControl.getString("description"));
            return object;
        }
    }
}

