/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.KnownFunction;

public class UserFunction
implements KnownFunction,
MultiVarFunction {
    protected String name;
    protected String[] paramNames = new String[0];
    protected double[] paramValues = new double[0];
    protected String expression = "0";
    protected String inputString = "0";
    protected String[] dummyVars = new String[]{"'", "@", "`", "~", "#"};
    protected MultiVarFunction function = null;
    protected String[] vars = new String[]{"x"};
    protected UserFunction[] references = new UserFunction[0];
    protected boolean nameEditable = true;
    protected String description;

    public UserFunction(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!this.isNameEditable()) {
            return;
        }
        this.name = string;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean bl) {
        this.nameEditable = bl;
    }

    public String getIndependentVariable() {
        return this.vars[0];
    }

    public String[] getIndependentVariables() {
        return this.vars;
    }

    public String getInputString() {
        String string = this.inputString;
        int n = 0;
        while (n < this.vars.length) {
            string = string.replaceAll(this.dummyVars[n], this.vars[n]);
            ++n;
        }
        return string;
    }

    public String getExpression() {
        String string = this.expression;
        int n = 0;
        while (n < this.vars.length) {
            string = string.replaceAll(this.dummyVars[n], this.vars[n]);
            ++n;
        }
        return string;
    }

    public String getExpression(String string) {
        this.vars = new String[]{string};
        return this.getExpression();
    }

    public String getExpression(String[] stringArray) {
        this.vars = stringArray;
        return this.getExpression();
    }

    public boolean setExpression(String string, String[] stringArray) {
        int n;
        this.vars = stringArray;
        String[] stringArray2 = new String[this.references.length + this.paramNames.length + this.vars.length];
        int n2 = 0;
        while (n2 < this.paramNames.length) {
            stringArray2[n2 + this.vars.length] = this.paramNames[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.references.length) {
            stringArray2[n2 + this.vars.length + this.paramNames.length] = this.references[n2].getName();
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.vars[0]);
        int n3 = 1;
        while (n3 < this.vars.length) {
            int n4 = arrayList.size();
            n = 0;
            while (n < n4) {
                if (this.vars[n3].length() > arrayList.get(n).toString().length()) {
                    arrayList.add(n, this.vars[n3]);
                    break;
                }
                if (n == n4 - 1) {
                    arrayList.add(this.vars[n3]);
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < arrayList.size()) {
            String string2 = arrayList.get(n3).toString();
            n = 0;
            while (n < this.vars.length) {
                if (string2.equals(this.vars[n])) {
                    string = string.replaceAll(this.vars[n], this.dummyVars[n]);
                    stringArray2[n] = this.dummyVars[n];
                    int n5 = this.vars.length;
                    while (n5 < stringArray2.length) {
                        stringArray2[n5] = stringArray2[n5].replaceAll(this.vars[n], this.dummyVars[n]);
                        ++n5;
                    }
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.paramNames.length) {
            string = string.replaceAll(stringArray2[this.vars.length + n3], this.paramNames[n3]);
            stringArray2[this.vars.length + n3] = this.paramNames[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.references.length) {
            string = string.replaceAll(stringArray2[this.vars.length + this.paramNames.length + n3], this.references[n3].getName());
            stringArray2[this.vars.length + this.paramNames.length + n3] = this.references[n3].getName();
            ++n3;
        }
        this.inputString = string;
        try {
            this.function = new ParsedMultiVarFunction(string, stringArray2);
            if (string.indexOf("=") == -1) {
                this.expression = string;
                return true;
            }
        }
        catch (ParserException parserException) {
            try {
                this.function = new ParsedMultiVarFunction("0", stringArray2);
            }
            catch (ParserException parserException2) {}
            this.expression = "0";
        }
        return false;
    }

    public int getParameterCount() {
        return this.paramNames.length;
    }

    public String getParameterName(int n) {
        return this.paramNames[n];
    }

    public double getParameterValue(int n) {
        return this.paramValues[n];
    }

    public void setParameterValue(int n, double d) {
        this.paramValues[n] = d;
    }

    public void setParameters(String[] stringArray, double[] dArray) {
        this.paramNames = stringArray;
        this.paramValues = dArray;
    }

    public void setReferences(UserFunction[] userFunctionArray) {
        this.references = userFunctionArray;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public double evaluate(double d) {
        if (this.function == null) {
            return Double.NaN;
        }
        double[] dArray = this.evaluateSupportFunctions(d);
        int n = dArray.length + this.paramValues.length + 1;
        double[] dArray2 = new double[n];
        dArray2[0] = d;
        System.arraycopy(this.paramValues, 0, dArray2, 1, this.paramValues.length);
        System.arraycopy(dArray, 0, dArray2, 1 + this.paramValues.length, dArray.length);
        return this.function.evaluate(dArray2);
    }

    public double evaluate(double[] dArray) {
        if (this.function == null) {
            return Double.NaN;
        }
        double[] dArray2 = this.evaluateSupportFunctions(dArray);
        int n = dArray2.length + this.paramValues.length + dArray.length;
        double[] dArray3 = new double[n];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(this.paramValues, 0, dArray3, dArray.length, this.paramValues.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length + this.paramValues.length, dArray2.length);
        return this.function.evaluate(dArray3);
    }

    protected double[] evaluateSupportFunctions(double d) {
        double[] dArray = new double[this.references.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this.references[n].evaluate(d);
            ++n;
        }
        return dArray;
    }

    protected double[] evaluateSupportFunctions(double[] dArray) {
        double[] dArray2 = new double[this.references.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = this.references[n].evaluate(dArray);
            ++n;
        }
        return dArray2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            UserFunction userFunction = (UserFunction)object;
            xMLControl.setValue("name", userFunction.getName());
            xMLControl.setValue("expression", userFunction.getInputString());
            xMLControl.setValue("variables", userFunction.getIndependentVariables());
            xMLControl.setValue("description", userFunction.getDescription());
            xMLControl.setValue("name_editable", userFunction.isNameEditable());
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            return new UserFunction(string);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            UserFunction userFunction = (UserFunction)object;
            userFunction.setName(xMLControl.getString("name"));
            String[] stringArray = (String[])xMLControl.getObject("variables");
            if (stringArray == null) {
                String string = xMLControl.getString("variable");
                stringArray = new String[]{string};
            }
            userFunction.setExpression(xMLControl.getString("expression"), stringArray);
            userFunction.setDescription(xMLControl.getString("description"));
            if (xMLControl.getPropertyNames().contains("name_editable")) {
                userFunction.setNameEditable(xMLControl.getBoolean("name_editable"));
            }
            return object;
        }
    }
}

