pkg load image

Iy = imread('sub-10228_anat_sub-10228_T1w.nii.gz.png');  %read  target image
hy = imhist(Iy);         % compute image histogram hy


S = size(Iy);
Imax = 255;             % 8 bit
K = Imax / (S(1)*S(2)); % Scale factor
Hy = zeros(1,256);      % compute CDF(Cumulative Distribution Function ) Hy(i) of input image 
Hy(1)=hy(1);
for i=2:256
  Hy(i) = Hy(i-1) + hy(i);
end
Hy = K*Hy; % compute CDF of target image



% Get the reference image and histograms:
I_des = imread('TE_16.8.png');%read  reference image
S = size(I_des);
h_des = imhist(I_des);% compute image histogram h_des


h_des(h_des < (S(1)*S(2)/(Imax*8))) = h_des(h_des < (S(1)*S(2)/(Imax*8))) + 32; % HERE  paddings 
Hz = zeros(1,256);  % This is reference CDF 
Hz(1)= h_des(1);
for i=2:256
  Hz(i)=Hz(i-1)+h_des(i);
end
K_des = Imax / (Hz(256));
Hz = K_des*Hz;% compute CDF of reference image


% MATCH is performed
Imatch = (Iy);     % Processed image from matching
for i=0:255       % for each intensity level
 ind = (Iy==i);   % find those index with an intensity value of "i"

 j = Hy(i+1);

 looping=1;  
 while looping
    k = find( (Hz > (j-1)) & (Hz < (j+1)));
    if length(k)>0   % for practical matters
      looping =0;
    else
      j = j + 1;    % when there is no match, update a little
    end 
 end

 Imatch(ind) = k(1); % Adjust the original intensity now
end



h_match = imhist(Imatch);
figure(1),subplot(3,3,1), imshow(Iy), title('original image ')
figure(1),subplot(3,3,2), stem(hy), title('original image histogram')
figure(1),subplot(3,3,3), stem(Hy), title('CDF of original input image')
figure(1),subplot(3,3,4), imshow(I_des),title('reference image ')
figure(1),subplot(3,3,5), stem(h_des),title('reference image histogram')
figure(1),subplot(3,3,6), stem(Hz), title('reference CDF Hz')
figure(1),subplot(3,3,7), imshow(Imatch),title('Image Matched to reference histogram')
figure(1),subplot(3,3,8), stem(h_match),title(' Matched Histogram')
