% Tsichlaki Styliani mtp209
% Advances in Digital Imaging and Computer Vision
% Assignment1
% 2nd Implementation

% Target Image
Target = imread('images/Fig1.tif');
% Reference Image
Ref = imread('images/Fig2.tif');

% Plot original images
figure;subplot(2,2,1);imshow(Target);title('Original Target Image')
subplot(2,2,2);plot(imhist(Target));title('Original Target Histogram')
subplot(2,2,3);imshow(Ref);title('Original Reference Image')
subplot(2,2,4);plot(imhist(Ref));title('Original Reference Histogram')

% Histogram Equalization of the reference image
[B,L] = histeq(Ref);

% Histogram Equalization of the target image
% Performs contrast-limited adaptive histogram equalization. 
% Unlike histeq, it operates on small data regions (tiles) 
% rather than the entire image. Each tile's contrast is enhanced
% so that the histogram of each output region approximately matches the 
% specified histogram (uniform distribution by default). The contrast enhancement
% can be limited in order to avoid amplifying the noise which might be present in the image.
A = adapthisteq(Target);

% Computing target image's CDF
[pixelCounts, grayLevels] = imhist(A);
cdf = cumsum(pixelCounts); % Make transfer function (look up table).
cdf = cdf / sum(cdf); % Normalize

% Plot CDF and Histogram of histogram equalized target and reference images 
f = figure;
subplot(1,2,1);
a1 = axes('Parent',f);
plot(imhist(A));
a2 = axes('Parent',f);
plot(grayLevels, cdf, 'b-');
grid off
set(a2,'Color','none')
title('Target CDF and Hist');

% Plot CDF and Histogram of 
f = figure;
subplot(1,2,2);
r1 = axes('Parent',f);
plot((0:255)/255, imhist(B));
r2 = axes('Parent',f);
plot((0:255)/255, L);
grid off
set(r2,'Color','none')
title('Ref CDF and Hist');

% View the Histogram Equalized images Ref and A 
figure;subplot(1,2,1);imshow(A);title('Histogram Equalized Target Image');
subplot(1,2,2);imshow(Ref);title('Histogram Equalized Target Reference Image');

% Generate a histogram-matched output image using histograms. 
% Using the default number of bins, 64.
HM = imhistmatch(A(:,:,1),Ref(:,:,1));  % default: 64 bins

% Save images
imwrite(Ref, 'images/HEref.tif', 'tif');
imwrite(A, 'images/HEtarget.tif', 'tif');
imwrite(HM, 'images/HMres.tif', 'tif');
imwrite(HM, 'images/HMres.png', 'png');

res = imread('images/HMres.png');
%View the results of the histogram matching operation.
figure;subplot(2,2,1);imshow(A);title('Target Image');
subplot(2,2,2);imshow(B);title('Reference Image ')
subplot(2,2,3);imshow(res);title('Result Image');
subplot(2,2,4);plot(imhist(res));title('Result Image Histogram');